/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ProcessStreamResult
implements Runnable {
    protected InputStream in;
    protected OutputStreamWriter outStream;
    protected String encoding;
    protected boolean finished;
    protected IOException ioe;
    protected Thread myThread;
    protected long startTime;
    protected boolean interrupted;
    protected int timeout;

    public ProcessStreamResult(InputStream in, BufferedOutputStream bos, String timemin) throws IOException, InterruptedException {
        this(in, bos, timemin, null, null);
    }

    public ProcessStreamResult(InputStream in, BufferedOutputStream bos, String timemin, String inEncoding, String outEncoding) throws IOException, InterruptedException {
        this.in = in;
        this.outStream = outEncoding == null ? new OutputStreamWriter(bos) : new OutputStreamWriter((OutputStream)bos, outEncoding);
        this.encoding = inEncoding;
        this.startTime = System.currentTimeMillis();
        if (timemin != null) {
            Integer i = Integer.valueOf(timemin);
            this.timeout = i;
        } else {
            this.timeout = 0;
        }
        this.myThread = new Thread(this);
        this.myThread.setPriority(1);
        this.myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.in == null) {
            System.out.println("The inputstream is null");
            System.exit(1);
        }
        try {
            int valid;
            char[] ca = new char[1024];
            this.interrupted = false;
            InputStreamReader inStream = this.encoding != null ? new InputStreamReader(this.in, this.encoding) : new InputStreamReader(this.in);
            while ((valid = inStream.read(ca, 0, ca.length)) != -1 && !this.interrupted) {
                this.outStream.write(ca, 0, valid);
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interrupted) {
            return;
        }
        ProcessStreamResult processStreamResult = this;
        synchronized (processStreamResult) {
            this.finished = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Wait() throws IOException {
        ProcessStreamResult processStreamResult = this;
        synchronized (processStreamResult) {
            long millis;
            long diff;
            int mins;
            if (this.finished) {
                return this.interrupted;
            }
            if (this.timeout > 0 && (mins = (int)((diff = (millis = System.currentTimeMillis()) - this.startTime) / 60000L)) > this.timeout) {
                this.interrupted = true;
                return this.interrupted;
            }
            try {
                long timeoutms = (long)(this.timeout * 60) * 1000L;
                if (this.timeout > 0) {
                    this.wait(timeoutms);
                } else {
                    this.wait();
                }
                if (!this.finished) {
                    this.interrupted = true;
                }
            }
            catch (InterruptedException ie) {
                this.interrupted = true;
                System.out.println("Interrupted: " + ie.toString());
            }
        }
        return this.interrupted;
    }
}

