/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.Version;

abstract class AbstractCompatibilityTest
extends BaseJDBCTestCase {
    public static final String SERVER_VERSION_FUNCTION = "getVMVersion";
    private static final String VERSION_PROPERTY = "java.version";
    private static Version _clientVMLevel;
    private static Version _serverVMLevel;
    private static DerbyVersion _driverLevel;
    private static final int JDBC_BOOLEAN = 16;
    private static final String FUNCTION = "function";
    private static final String PROCEDURE = "procedure";
    private static final String TYPE = "type";

    public AbstractCompatibilityTest(String name) {
        super(name);
    }

    public DerbyVersion getServerVersion() throws SQLException {
        return AbstractCompatibilityTest.getServerVersion(this.getConnection());
    }

    protected static DerbyVersion getServerVersion(Connection con) throws SQLException {
        return DerbyVersion.parseVersionString(con.getMetaData().getDatabaseProductVersion());
    }

    public DerbyVersion getDriverVersion() throws SQLException {
        if (_driverLevel == null) {
            _driverLevel = DerbyVersion.parseVersionString(this.getConnection().getMetaData().getDriverVersion());
        }
        return _driverLevel;
    }

    public static Version getServerVMVersion() {
        return _serverVMLevel;
    }

    public Version getClientVMVersion() {
        return _clientVMLevel;
    }

    public boolean serverSupportsUDTs() throws SQLException {
        return AbstractCompatibilityTest.serverSupportsUDTs(this.getConnection());
    }

    public static boolean serverSupportsUDTs(Connection con) throws SQLException {
        return AbstractCompatibilityTest.getServerVersion(con).atLeast(DerbyVersion._10_6);
    }

    public static String getVMVersion() {
        return System.getProperty(VERSION_PROPERTY);
    }

    public void compareObjects(String message, Object left, Object right) throws SQLException {
        message = message + "\n\t expected = " + left + "\n\t actual = " + right;
        if (left == null) {
            AbstractCompatibilityTest.assertNull((String)message, (Object)right);
        } else {
            AbstractCompatibilityTest.assertNotNull((String)message, (Object)right);
            if (left instanceof byte[]) {
                this.compareBytes(message, left, right);
            } else if (left instanceof Date) {
                this.compareDates(message, left, right);
            } else {
                AbstractCompatibilityTest.assertTrue((String)message, (boolean)left.equals(right));
            }
        }
    }

    public void compareBytes(String message, Object left, Object right) {
        if (left == null) {
            AbstractCompatibilityTest.assertNull((String)message, (Object)right);
        } else {
            AbstractCompatibilityTest.assertNotNull((Object)right);
        }
        if (!(left instanceof byte[])) {
            AbstractCompatibilityTest.fail((String)message);
        }
        if (!(right instanceof byte[])) {
            AbstractCompatibilityTest.fail((String)message);
        }
        byte[] leftBytes = (byte[])left;
        byte[] rightBytes = (byte[])right;
        int count = leftBytes.length;
        AbstractCompatibilityTest.assertEquals((String)message, (int)count, (int)rightBytes.length);
        for (int i = 0; i < count; ++i) {
            AbstractCompatibilityTest.assertEquals((String)(message + "[ " + i + " ]"), (byte)leftBytes[i], (byte)rightBytes[i]);
        }
    }

    public void compareDates(String message, Object left, Object right) {
        if (left == null) {
            AbstractCompatibilityTest.assertNull((String)message, (Object)right);
        } else {
            AbstractCompatibilityTest.assertNotNull((Object)right);
        }
        if (!(left instanceof Date)) {
            AbstractCompatibilityTest.fail((String)message);
        }
        if (!(right instanceof Date)) {
            AbstractCompatibilityTest.fail((String)message);
        }
        AbstractCompatibilityTest.assertEquals((String)message, (String)left.toString(), (String)right.toString());
    }

    protected Object getColumn(ResultSet rs, String columnName, int jdbcType) throws SQLException {
        Object retval = null;
        switch (jdbcType) {
            case 16: {
                retval = rs.getBoolean(columnName);
                break;
            }
            case -5: {
                retval = rs.getLong(columnName);
                break;
            }
            case 2004: {
                retval = rs.getBlob(columnName);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                retval = rs.getString(columnName);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                retval = rs.getBytes(columnName);
                break;
            }
            case 2005: {
                retval = rs.getClob(columnName);
                break;
            }
            case 91: {
                retval = rs.getDate(columnName);
                break;
            }
            case 2: 
            case 3: {
                retval = rs.getBigDecimal(columnName);
                break;
            }
            case 8: {
                retval = rs.getDouble(columnName);
                break;
            }
            case 7: {
                retval = Float.valueOf(rs.getFloat(columnName));
                break;
            }
            case 4: {
                retval = rs.getInt(columnName);
                break;
            }
            case 5: {
                retval = rs.getShort(columnName);
                break;
            }
            case 92: {
                retval = rs.getTime(columnName);
                break;
            }
            case 93: {
                retval = rs.getTimestamp(columnName);
                break;
            }
            default: {
                AbstractCompatibilityTest.fail((String)("Unknown jdbc type " + jdbcType + " used to retrieve column: " + columnName));
            }
        }
        if (rs.wasNull()) {
            retval = null;
        }
        return retval;
    }

    protected void setParameter(PreparedStatement ps, int param, int jdbcType, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(param, jdbcType);
            return;
        }
        switch (jdbcType) {
            case 16: {
                ps.setBoolean(param, (Boolean)value);
                break;
            }
            case -5: {
                ps.setLong(param, (Long)value);
                break;
            }
            case 2004: {
                ps.setBlob(param, (Blob)value);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                ps.setString(param, (String)value);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                ps.setBytes(param, (byte[])value);
                break;
            }
            case 2005: {
                ps.setClob(param, (Clob)value);
                break;
            }
            case 91: {
                ps.setDate(param, (java.sql.Date)value);
                break;
            }
            case 2: 
            case 3: {
                ps.setBigDecimal(param, (BigDecimal)value);
                break;
            }
            case 8: {
                ps.setDouble(param, (Double)value);
                break;
            }
            case 7: {
                ps.setFloat(param, ((Float)value).floatValue());
                break;
            }
            case 4: {
                ps.setInt(param, (Integer)value);
                break;
            }
            case 5: {
                ps.setShort(param, (Short)value);
                break;
            }
            case 92: {
                ps.setTime(param, (Time)value);
                break;
            }
            case 93: {
                ps.setTimestamp(param, (Timestamp)value);
                break;
            }
            default: {
                AbstractCompatibilityTest.fail((String)("Unknown jdbc type: " + jdbcType));
            }
        }
    }

    protected void dropFunction(String name) {
        this.dropSchemaObject(FUNCTION, name, false);
    }

    protected void dropProcedure(String name) {
        this.dropSchemaObject(PROCEDURE, name, false);
    }

    protected void dropUDT(String name) {
        this.dropSchemaObject(TYPE, name, true);
    }

    protected void dropSchemaObject(String genus, String objectName, boolean restrict) {
        try {
            String text = "drop " + genus + " " + objectName;
            if (restrict) {
                text = text + " restrict";
            }
            PreparedStatement ps = this.prepareStatement(text);
            ps.execute();
            ps.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

