/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.planexporter;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.tools.ToolUtils;
import org.apache.derby.impl.tools.planexporter.TreeNode;

public class AccessDatabase {
    private final Connection conn;
    private final String schema;
    private final String query;
    private final boolean schemaExists;
    private TreeNode[] data;
    private int depth = 0;
    private String xmlDetails = "";
    private static final int ID = 0;
    private static final int P_ID = 1;
    private static final int NODE_TYPE = 2;
    private static final int NO_OF_OPENS = 3;
    private static final int INPUT_ROWS = 4;
    private static final int RETURNED_ROWS = 5;
    private static final int VISITED_PAGES = 6;
    private static final int SCAN_QUALIFIERS = 7;
    private static final int NEXT_QUALIFIERS = 8;
    private static final int SCANNED_OBJECT = 9;
    private static final int SCAN_TYPE = 10;
    private static final int SORT_TYPE = 11;
    private static final int NO_OF_OUTPUT_ROWS_BY_SORTER = 12;

    public String getQuery() {
        return this.query;
    }

    public int getDepth() {
        return this.depth;
    }

    public AccessDatabase(String dburl, String aSchema, String aQuery) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, InvocationTargetException {
        this(AccessDatabase.createConnection(dburl), aSchema, aQuery);
    }

    public AccessDatabase(Connection aConn, String aSchema, String aQuery) throws SQLException {
        this.conn = aConn;
        this.schema = aSchema;
        this.query = aQuery;
        this.schemaExists = this.schemaExists();
        if (this.schemaExists) {
            this.setSchema();
        }
    }

    private static Connection createConnection(String dbURL) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = dbURL.indexOf("://") != -1 ? Class.forName("org.apache.derby.jdbc.ClientDriver") : Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        return DriverManager.getConnection(dbURL);
    }

    private void setSchema() throws SQLException {
        PreparedStatement setSchema = this.conn.prepareStatement("SET SCHEMA ?");
        setSchema.setString(1, this.schema);
        setSchema.execute();
        setSchema.close();
    }

    private boolean schemaExists() throws SQLException {
        try (ResultSet result = this.conn.getMetaData().getSchemas();){
            while (result.next()) {
                if (!result.getString(1).equals(this.schema)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean verifySchemaExistance() {
        return this.schemaExists;
    }

    public void createXMLFragment() throws SQLException {
        this.createXMLData("select 'id=\"' ||RS_ID|| '\"' from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 0);
        this.createXMLData("select PARENT_RS_ID from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 1);
        this.createXMLData("select 'name=\"' ||OP_IDENTIFIER|| '\"' from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 2);
        this.createXMLData("select 'no_opens=\"' || TRIM(CHAR(NO_OPENS))|| '\"' from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 3);
        this.createXMLData("select 'input_rows=\"' || TRIM(CHAR(INPUT_ROWS))|| '\"' from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 4);
        this.createXMLData("select 'returned_rows=\"' || TRIM(CHAR(RETURNED_ROWS))|| '\"' from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 5);
        this.createXMLData("select 'visited_pages=\"'|| TRIM(CHAR(NO_VISITED_PAGES))|| '\"' from (SYSXPLAIN_SCAN_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 6);
        this.createXMLData("select 'scan_qualifiers=\"'||SCAN_QUALIFIERS|| '\"' from (SYSXPLAIN_SCAN_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 7);
        this.createXMLData("select 'next_qualifiers=\"'||NEXT_QUALIFIERS|| '\"' from (SYSXPLAIN_SCAN_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 8);
        this.createXMLData("select 'scanned_object=\"'||SCAN_OBJECT_NAME|| '\"' from (SYSXPLAIN_SCAN_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 9);
        this.createXMLData("select 'scan_type=\"'||TRIM(SCAN_TYPE)|| '\"' from (SYSXPLAIN_SCAN_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 10);
        this.createXMLData("select 'sort_type=\"'||TRIM(SORT_TYPE)|| '\"' from (SYSXPLAIN_SORT_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 11);
        this.createXMLData("select 'sorter_output=\"'||TRIM(CHAR(NO_OUTPUT_ROWS))|| '\"' from (SYSXPLAIN_SORT_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 12);
    }

    public String getXmlString() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].getDepth() != 0) continue;
            this.xmlDetails = this.xmlDetails + this.indent(1);
            this.xmlDetails = this.xmlDetails + this.data[i].toString();
            this.getChildren(1, this.data[i].getId());
            this.xmlDetails = this.xmlDetails + this.indent(1) + "</node>\n";
            break;
        }
        return this.xmlDetails;
    }

    private void getChildren(int currentLevel, String id) {
        if (currentLevel <= this.depth) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i].getDepth() != currentLevel || id.indexOf(this.data[i].getParent()) == -1) continue;
                this.xmlDetails = this.xmlDetails + this.indent(currentLevel + 1);
                this.xmlDetails = this.xmlDetails + this.data[i].toString();
                this.getChildren(currentLevel + 1, this.data[i].getId());
                this.xmlDetails = this.xmlDetails + this.indent(currentLevel + 1) + "</node>\n";
            }
        }
    }

    public String indent(int j) {
        String str = "";
        for (int i = 0; i <= j + 1; ++i) {
            str = str + "    ";
        }
        return str;
    }

    public void markTheDepth() {
        int i = 0;
        while (this.data[i].getParent().indexOf("null") == -1) {
            ++i;
        }
        this.data[i].setDepth(this.depth);
        this.findChildren(i, this.depth);
    }

    private void findChildren(int idx, int dep) {
        if (dep > this.depth) {
            this.depth = dep;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].getParent().indexOf("null") != -1 || this.data[idx].getId().indexOf(this.data[i].getParent()) == -1 || i == idx) continue;
            this.data[i].setDepth(dep + 1);
            this.findChildren(i, dep + 1);
        }
    }

    public boolean initializeDataArray() throws SQLException {
        if (this.noOfNodes() == 0) {
            return false;
        }
        this.data = new TreeNode[this.noOfNodes()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new TreeNode();
        }
        return true;
    }

    private void createXMLData(String qry, int x) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(qry);
        ps.setString(1, this.getQuery());
        ResultSet results = ps.executeQuery();
        int i = 0;
        while (results.next()) {
            String text = results.getString(1);
            if (text != null) {
                text = this.escapeInAttribute(text);
                switch (x) {
                    case 0: {
                        this.data[i].setId(text + " ");
                        break;
                    }
                    case 1: {
                        this.data[i].setParent(text);
                        break;
                    }
                    case 2: {
                        this.data[i].setNodeType(text + " ");
                        break;
                    }
                    case 3: {
                        this.data[i].setNoOfOpens(text + " ");
                        break;
                    }
                    case 4: {
                        this.data[i].setInputRows(text + " ");
                        break;
                    }
                    case 5: {
                        this.data[i].setReturnedRows(text + " ");
                        break;
                    }
                    case 6: {
                        this.data[i].setVisitedPages(text + " ");
                        break;
                    }
                    case 7: {
                        this.data[i].setScanQualifiers(text + " ");
                        break;
                    }
                    case 8: {
                        this.data[i].setNextQualifiers(text + " ");
                        break;
                    }
                    case 9: {
                        this.data[i].setScannedObject(text + " ");
                        break;
                    }
                    case 10: {
                        this.data[i].setScanType(text + " ");
                        break;
                    }
                    case 11: {
                        this.data[i].setSortType(text + " ");
                        break;
                    }
                    case 12: {
                        this.data[i].setSorterOutput(text + " ");
                    }
                }
            } else {
                switch (x) {
                    case 1: {
                        this.data[i].setParent(text + "");
                    }
                }
            }
            ++i;
        }
        results.close();
        ps.close();
    }

    private int noOfNodes() throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("select count(*) from SYSXPLAIN_RESULTSETS where STMT_ID = ?");
        ps.setString(1, this.getQuery());
        ResultSet results = ps.executeQuery();
        results.next();
        int no = results.getInt(1);
        results.close();
        ps.close();
        return no;
    }

    public String statement() throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("select STMT_TEXT from SYSXPLAIN_STATEMENTS where STMT_ID = ?");
        ps.setString(1, this.getQuery());
        ResultSet results = ps.executeQuery();
        results.next();
        String statement = results.getString(1);
        results.close();
        ps.close();
        statement = AccessDatabase.escapeForXML(statement);
        return "<statement>" + statement + "</statement>\n";
    }

    private static String escapeForXML(String text) {
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private String escapeInAttribute(String text) {
        if (text.indexOf(34) == -1) {
            return text;
        }
        String correctXMLString = AccessDatabase.escapeForXML(text.substring(text.indexOf(34) + 1, text.length() - 1));
        return text.substring(0, text.indexOf(34) + 1) + correctXMLString + "\"";
    }

    public String time() throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("select '<time>'||TRIM(CHAR(XPLAIN_TIME))||'</time>' from SYSXPLAIN_STATEMENTS where STMT_ID = ?");
        ps.setString(1, this.getQuery());
        ResultSet results = ps.executeQuery();
        results.next();
        String time = results.getString(1);
        results.close();
        ps.close();
        return time + "\n";
    }

    public String stmtID() {
        return "<stmt_id>" + this.getQuery() + "</stmt_id>\n";
    }

    public void closeConnection() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public TreeNode[] getData() {
        return (TreeNode[])ToolUtils.copy(this.data);
    }
}

