/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class UnaryArithmeticOperatorNode
extends UnaryOperatorNode {
    private static final String[] UNARY_OPERATORS = new String[]{"+", "-", "SQRT", "ABS/ABSVAL"};
    private static final String[] UNARY_METHODS = new String[]{"plus", "minus", "sqrt", "absolute"};
    static final int K_PLUS = 0;
    static final int K_MINUS = 1;
    static final int K_SQRT = 2;
    static final int K_ABS = 3;
    final int kind;

    UnaryArithmeticOperatorNode(ValueNode operand, int kind, ContextManager cm) throws StandardException {
        super(operand, UNARY_OPERATORS[kind], UNARY_METHODS[kind], cm);
        this.kind = kind;
    }

    @Override
    public boolean requiresTypeFromContext() {
        if (this.kind == 0 || this.kind == 1) {
            return this.operand.requiresTypeFromContext();
        }
        return false;
    }

    @Override
    public boolean isParameterNode() {
        if (this.kind == 0 || this.kind == 1) {
            return this.operand.isParameterNode();
        }
        return false;
    }

    @Override
    void bindParameter() throws StandardException {
        if (this.kind == 2 || this.kind == 3) {
            this.operand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), true));
            return;
        }
        if (this.kind == 1 || this.kind == 0) {
            return;
        }
        super.bindParameter();
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        if (this.operand.requiresTypeFromContext() && (this.kind == 0 || this.kind == 1) && this.operand.getTypeServices() == null) {
            return this;
        }
        this.bindOperand(fromList, subqueryList, aggregates);
        if (this.kind == 2 || this.kind == 3) {
            this.bindSQRTABS();
        } else if (this.kind == 0 || this.kind == 1) {
            this.checkOperandIsNumeric(this.operand.getTypeId());
        }
        super.setType(this.operand.getTypeServices());
        return this;
    }

    private void checkOperandIsNumeric(TypeId operandType) throws StandardException {
        if (!operandType.isNumericTypeId()) {
            throw StandardException.newException("42X37", this.kind == 0 ? "+" : "-", operandType.getSQLTypeName());
        }
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.kind == 0) {
            this.operand.generateExpression(acb, mb);
        } else {
            super.generateExpression(acb, mb);
        }
    }

    private void bindSQRTABS() throws StandardException {
        TypeId operandType = this.operand.getTypeId();
        if (operandType.userType()) {
            this.operand = this.operand.genSQLJavaSQLTree();
        }
        int jdbcType = operandType.getJDBCTypeId();
        if (!operandType.isNumericTypeId()) {
            throw StandardException.newException("42X25", this.getOperatorString(), operandType.getSQLTypeName());
        }
        if (this.kind == 2 && jdbcType != 8) {
            this.operand = new CastNode(this.operand, new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), true), this.getContextManager());
            ((CastNode)this.operand).bindCastNodeOnly();
        }
    }

    @Override
    void setType(DataTypeDescriptor descriptor) throws StandardException {
        if (this.operand.requiresTypeFromContext() && this.operand.getTypeServices() == null) {
            this.checkOperandIsNumeric(descriptor.getTypeId());
            this.operand.setType(descriptor);
        }
        super.setType(descriptor);
    }

    @Override
    boolean isSameNodeKind(ValueNode o) {
        return super.isSameNodeKind(o) && ((UnaryArithmeticOperatorNode)o).kind == this.kind;
    }
}

