/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

class UnaryOperatorNode
extends OperatorNode {
    String operator;
    String methodName;
    String resultInterfaceType;
    String receiverInterfaceType;
    ValueNode operand;
    static final int K_XMLPARSE = 0;
    static final int K_XMLSERIALIZE = 1;
    static final int K_BASE = 2;
    final int kind;
    static final String[] UnaryOperators = new String[]{"xmlparse", "xmlserialize"};
    static final String[] UnaryMethodNames = new String[]{"XMLParse", "XMLSerialize"};
    static final String[] UnaryResultTypes = new String[]{"org.apache.derby.iapi.types.XMLDataValue", "org.apache.derby.iapi.types.StringDataValue"};
    static final String[] UnaryArgTypes = new String[]{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.XMLDataValue"};
    private DataTypeDescriptor targetType;
    private boolean preserveWhitespace;

    UnaryOperatorNode(ValueNode operand, String operator, String methodNameOrAddedArgs, ContextManager cm) throws StandardException {
        super(cm);
        this.operand = operand;
        this.operator = operator;
        this.methodName = methodNameOrAddedArgs;
        this.kind = 2;
    }

    UnaryOperatorNode(ValueNode operand, ContextManager cm) {
        super(cm);
        this.operand = operand;
        this.kind = 2;
    }

    UnaryOperatorNode(ValueNode operand, int kind, DataTypeDescriptor targetType, boolean preserveWhiteSpace, ContextManager cm) {
        super(cm);
        this.operand = operand;
        this.kind = kind;
        this.operator = UnaryOperators[this.kind];
        this.methodName = UnaryMethodNames[this.kind];
        this.resultInterfaceType = UnaryResultTypes[this.kind];
        this.receiverInterfaceType = UnaryArgTypes[this.kind];
        if (kind == 1) {
            this.targetType = targetType;
        } else if (kind == 0) {
            this.preserveWhitespace = preserveWhiteSpace;
        } else {
            SanityManager.THROWASSERT("Don't know how to handle operator type " + kind);
        }
    }

    void setOperator(String operator) {
        this.operator = operator;
    }

    String getOperatorString() {
        return this.operator;
    }

    void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\nmethodName: " + this.methodName + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.operand != null) {
            this.printLabel(depth, "operand: ");
            this.operand.treePrint(depth + 1);
        }
    }

    ValueNode getOperand() {
        return this.operand;
    }

    ParameterNode getParameterOperand() throws StandardException {
        if (!this.requiresTypeFromContext()) {
            return null;
        }
        UnaryOperatorNode tempUON = this;
        while (!(tempUON.getOperand() instanceof ParameterNode)) {
            tempUON = (UnaryOperatorNode)tempUON.getOperand();
        }
        return (ParameterNode)tempUON.getOperand();
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregates);
        if (this.kind == 0) {
            this.bindXMLParse();
        } else if (this.kind == 1) {
            this.bindXMLSerialize();
        }
        return this;
    }

    protected void bindOperand(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.operand = this.operand.bindExpression(fromList, subqueryList, aggregates);
        if (this.operand.requiresTypeFromContext()) {
            this.bindParameter();
            if (this.operand.getTypeServices() == null) {
                return;
            }
        }
        if (!(this.operand instanceof UntypedNullConstantNode) && this.operand.getTypeId().userType() && !(this instanceof IsNullNode)) {
            this.operand = this.operand.genSQLJavaSQLTree();
        }
    }

    private void bindXMLParse() throws StandardException {
        TypeId operandType = this.operand.getTypeId();
        if (operandType != null) {
            switch (operandType.getJDBCTypeId()) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    break;
                }
                default: {
                    throw StandardException.newException("42X25", this.methodName, operandType.getSQLTypeName());
                }
            }
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009));
    }

    private void bindXMLSerialize() throws StandardException {
        TypeId operandType = this.operand.getTypeId();
        if (operandType != null && !operandType.isXMLTypeId()) {
            throw StandardException.newException("42X25", this.methodName, operandType.getSQLTypeName());
        }
        SanityManager.ASSERT(this.targetType != null, "Failed to locate target type for XMLSERIALIZE operator");
        TypeId targetTypeId = this.targetType.getTypeId();
        switch (targetTypeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                throw StandardException.newException("42Z73", targetTypeId.getSQLTypeName());
            }
        }
        this.setType(this.targetType);
        this.setCollationUsingCompilationSchema();
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        }
        return this;
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.operand == null ? false : this.operand.categorize(referencedTabs, simplePredsOnly);
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.remapColumnReferencesToExpressions();
        }
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.operand == null ? true : this.operand.isConstantExpression();
    }

    @Override
    boolean constantExpression(PredicateList whereClause) {
        return this.operand == null ? true : this.operand.constantExpression(whereClause);
    }

    void bindParameter() throws StandardException {
        if (this.kind == 0) {
            throw StandardException.newException("42Z79", new Object[0]);
        }
        if (this.kind == 1) {
            throw StandardException.newException("42Z70", new Object[0]);
        }
        if (this.operand.getTypeServices() == null) {
            throw StandardException.newException("42X36", this.operator);
        }
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        String resultTypeName = this.kind == 2 ? this.getTypeCompiler().interfaceName() : this.resultInterfaceType;
        boolean needField = !this.getTypeId().isBooleanTypeId();
        String receiverType = this.getReceiverInterfaceName();
        this.operand.generateExpression(acb, mb);
        mb.cast(receiverType);
        if (needField) {
            LocalField field = acb.newFieldDeclaration(2, resultTypeName);
            mb.getField(field);
            int numArgs = 1;
            mb.callMethod((short)185, null, this.methodName, resultTypeName, numArgs += this.addXmlOpMethodParams(acb, mb, field));
            mb.putField(field);
        } else {
            mb.callMethod((short)185, null, this.methodName, resultTypeName, 0);
        }
    }

    String getReceiverInterfaceName() throws StandardException {
        SanityManager.ASSERT(this.operand != null, "cannot get interface without operand");
        if (this.kind != 2) {
            return this.receiverInterfaceType;
        }
        return this.operand.getTypeCompiler().interfaceName();
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.operand != null ? this.operand.getOrderableVariantType() : 3;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.operand != null) {
            this.operand = (ValueNode)this.operand.accept(v);
        }
    }

    int addXmlOpMethodParams(ExpressionClassBuilder acb, MethodBuilder mb, LocalField resultField) throws StandardException {
        if (this.kind != 0 && this.kind != 1) {
            return 0;
        }
        if (this.kind == 1) {
            mb.push(this.targetType.getJDBCTypeId());
            mb.push(this.targetType.getMaximumWidth());
            mb.push(this.getSchemaDescriptor(null, false).getCollationType());
            return 3;
        }
        MethodBuilder constructor = acb.getConstructor();
        acb.generateNull(constructor, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        constructor.setField(resultField);
        mb.swap();
        mb.push(this.preserveWhitespace);
        UnaryOperatorNode.pushSqlXmlUtil(acb, mb, null, null);
        return 2;
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeKind(o)) {
            UnaryOperatorNode other = (UnaryOperatorNode)o;
            return this.operator.equals(other.operator) && (this.operand == other.operand || this.operand != null && this.operand.isEquivalent(other.operand));
        }
        return false;
    }

    @Override
    boolean isSameNodeKind(ValueNode o) {
        return super.isSameNodeKind(o) && ((UnaryOperatorNode)o).kind == this.kind;
    }
}

