/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public abstract class EncryptionKeyTest
extends BaseJDBCTestCase {
    protected static final int CORRECT_KEY = 0;
    protected static final int WRONG_KEY = 1;
    protected static final int ODD_LENGTH_KEY = 2;
    protected static final int INVALID_CHAR_KEY = 3;
    private static final String TABLE = "encryptionkeytestdata";
    private static final int[] DATA = new int[]{9, 4, 2, 34, 6543, 3, 123, 434, 5436, -123, 0, 123};
    private final String algorithm;
    private final String keyCorrect;
    private final String keyWrong;
    private final String keyOddLength;
    private final String keyInvalidChar;
    private Connection con = null;

    public EncryptionKeyTest(String string, String string2, String string3, String string4, String string5, String string6) {
        super(string);
        this.algorithm = string2;
        this.keyCorrect = string3;
        this.keyWrong = string4;
        this.keyOddLength = string5;
        this.keyInvalidChar = string6;
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.con != null && !this.con.isClosed()) {
            this.con.rollback();
            this.con.close();
        }
        this.con = null;
        super.tearDown();
    }

    public void testConnectionSequence1() throws SQLException {
        String string = "encryptedDB_ConnectionSequence1";
        this.con = this.createAndPopulateDB(string);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(string);
        this.con = this.getConnection(string, 0);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(string);
        try {
            this.getConnection(string, 1);
            EncryptionKeyTest.fail((String)"Booting with an incorrect encryption key should fail.");
        }
        catch (SQLException sQLException) {
            EncryptionKeyTest.assertSQLState("XJ040", sQLException);
            EncryptionKeyTest.assertSQLState("XBCXK", this.getLastSQLException(sQLException));
        }
        this.con = this.getConnection(string, 0);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(string);
    }

    public void testConnectionSequence2() throws SQLException {
        String string;
        block4: {
            string = "encryptedDB_ConnectionSequence2";
            this.con = this.createAndPopulateDB(string);
            this.validateDBContents(this.con);
            this.con.close();
            this.shutdown(string);
            try {
                this.con = this.getConnection(string, 2);
                EncryptionKeyTest.fail((String)"Connected with an odd length key.");
            }
            catch (SQLException sQLException) {
                EncryptionKeyTest.assertSQLState("XJ040", sQLException);
                SQLException sQLException2 = this.getLastSQLException(sQLException);
                String string2 = sQLException2.getSQLState();
                if (string2.equals("XBCX0") || string2.equals("XBCXM")) break block4;
                throw sQLException2;
            }
        }
        this.confirmNonBootedDB(string);
        try {
            this.getConnection(string, 1);
            EncryptionKeyTest.fail((String)"Booting with an incorrect encryption key should fail.");
        }
        catch (SQLException sQLException) {
            EncryptionKeyTest.assertSQLState("XJ040", sQLException);
            EncryptionKeyTest.assertSQLState("XBCXK", this.getLastSQLException(sQLException));
        }
        this.con = this.getConnection(string, 0);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(string);
    }

    public void testBackupEncryptedDatabase() throws SQLException {
        String string = "encryptionKeyDBToBackup";
        this.con = this.createAndPopulateDB(string);
        this.validateDBContents(this.con);
        CallableStatement callableStatement = this.con.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        callableStatement.setString(1, new File("extinout", "backups").getPath());
        callableStatement.execute();
        callableStatement.close();
        this.con.close();
        this.shutdown(string);
        this.con = this.getConnection(string, 0);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(string);
    }

    public void testCreateDbFromBackup() throws SQLException {
        String string;
        String string2;
        block6: {
            string2 = SupportFilesSetup.getReadWrite(new File("backups", "encryptionKeyDBToCreateFrom").getPath()).getPath();
            this.con = this.createAndPopulateDB("encryptionKeyDBToCreateFrom");
            this.validateDBContents(this.con);
            CallableStatement callableStatement = this.con.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
            callableStatement.setString(1, new File("extinout", "backups").getPath());
            callableStatement.execute();
            callableStatement.close();
            this.con.close();
            this.shutdown("encryptionKeyDBToCreateFrom");
            string = "encryptionKeyDBToCreateFromRestored";
            this.con = this.getConnection(string, 0, "createFrom=" + string2);
            this.validateDBContents(this.con);
            this.con.close();
            this.shutdown(string, "restored");
            string = "encryptionKeyDBToCreateFromRestoreAttemptedWrongKey";
            try {
                this.con = this.getConnection(string, 1, "createFrom=" + string2);
                EncryptionKeyTest.fail((String)"Created database from encrypted backup with wrong key.");
            }
            catch (SQLException sQLException) {
                EncryptionKeyTest.assertSQLState("XJ040", sQLException);
                EncryptionKeyTest.assertSQLState("XBCXK", this.getLastSQLException(sQLException));
            }
            EncryptionKeyTest.assertTrue((boolean)this.con.isClosed());
            string = "encryptionKeyDBToCreateFromRestoreAttemptedInvalidKey";
            try {
                this.con = this.getConnection(string, 3, "createFrom=" + string2);
                EncryptionKeyTest.fail((String)"Created database from encrypted backup with an invalid key.");
            }
            catch (SQLException sQLException) {
                EncryptionKeyTest.assertSQLState("XJ040", sQLException);
                EncryptionKeyTest.assertSQLState("XBCXN", this.getLastSQLException(sQLException));
            }
            EncryptionKeyTest.assertTrue((boolean)this.con.isClosed());
            string = "encryptionKeyDBToCreateFromRestoreAttemptedOddLengthKey";
            try {
                this.con = this.getConnection(string, 2, "createFrom=" + string2);
                EncryptionKeyTest.fail((String)"Created db from encrypted backup with an odd length key.");
            }
            catch (SQLException sQLException) {
                EncryptionKeyTest.assertSQLState("XJ040", sQLException);
                SQLException sQLException2 = this.getLastSQLException(sQLException);
                String string3 = sQLException2.getSQLState();
                if (string3.equals("XBCX0") || string3.equals("XBCXM")) break block6;
                throw sQLException2;
            }
        }
        EncryptionKeyTest.assertTrue((boolean)this.con.isClosed());
        string = "encryptionKeyDBToCreateFromRestoredOnceMore";
        this.con = this.getConnection(string, 0, "createFrom=" + string2);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(string, "restored");
    }

    public void testRestoreFrom() throws SQLException {
        String string = "encryptionKeyDBToRestoreFrom";
        String string2 = string + "Restored";
        this.createBackupRestore(string, string2);
        this.shutdown(string2, "restored");
    }

    public void testInvalidRestoreFrom() throws SQLException {
        String string = "encryptionKeyDBToInvalidRestoreFrom";
        String string2 = string + "Restored";
        this.createBackupRestore(string, string2);
        this.shutdown(string2, "restored");
        this.confirmNonBootedDB("restored/" + string2);
        this.con = this.getConnection("restored/" + string2, 0);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(string2, "restored");
        try {
            this.con = this.getConnection(string2, 3, ";restoreFrom=" + this.obtainDbName(string, null));
            EncryptionKeyTest.fail((String)"Restored database with an invalid key.");
        }
        catch (SQLException sQLException) {
            EncryptionKeyTest.assertSQLState("XBCXN", sQLException);
        }
        try {
            this.con = this.getConnection("restored/" + string2, 0, "");
            EncryptionKeyTest.fail((String)"Expected connection to fail due to non-existent database.");
        }
        catch (SQLException sQLException) {
            EncryptionKeyTest.assertSQLState("XJ004", sQLException);
        }
    }

    public void testCreateWithOddEncryptionKeyLength() throws SQLException {
        block2: {
            try {
                this.getConnection("encryptedDB_oddKeyLength", 2);
                EncryptionKeyTest.fail((String)"Database creation with odd key length should fail.");
            }
            catch (SQLException sQLException) {
                EncryptionKeyTest.assertSQLState("XJ041", sQLException);
                SQLException sQLException2 = this.getLastSQLException(sQLException);
                String string = sQLException2.getSQLState();
                if (string.equals("XBCXM") || string.equals("XJ001")) break block2;
                throw sQLException2;
            }
        }
    }

    public void testCreateWithInvalidEncryptionKey() {
        try {
            this.getConnection("encryptedDB_invkeyChar", 3);
            EncryptionKeyTest.fail((String)"Database creation with invalid key should fail.");
        }
        catch (SQLException sQLException) {
            EncryptionKeyTest.assertSQLState("XJ041", sQLException);
            EncryptionKeyTest.assertSQLState("XBCXN", this.getLastSQLException(sQLException));
        }
    }

    String obtainDbName(String string, String string2) {
        File file = new File(string);
        if (string2 != null) {
            file = new File(string2, string);
        }
        return PrivilegedFileOpsForTests.getAbsolutePath(new File("extinout", file.getPath()));
    }

    private void createBackupRestore(String string, String string2) throws SQLException {
        this.con = this.createAndPopulateDB(string);
        this.validateDBContents(this.con);
        CallableStatement callableStatement = this.con.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        callableStatement.setString(1, new File("extinout", "backups").getPath());
        callableStatement.execute();
        this.con.close();
        this.shutdown(string);
        this.confirmNonBootedDB(string);
        this.con = this.getConnection(string2, 0, ";restoreFrom=" + this.obtainDbName(string, "backups"));
        this.validateDBContents(this.con);
        this.con.close();
    }

    private void confirmNonBootedDB(String string) {
        DataSource dataSource = JDBCDataSource.getDataSource(this.obtainDbName(string, null));
        try {
            dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            EncryptionKeyTest.assertSQLState("Database booted? <state:" + sQLException.getSQLState() + ", msg:" + sQLException.getMessage() + ">", "XJ040", sQLException);
        }
    }

    private Connection getConnection(String string, int n) throws SQLException {
        return this.getConnection(string, n, null);
    }

    private Connection getConnection(String string, int n, String string2) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(this.obtainDbName(string, string2 == null ? null : "restored"));
        StringBuffer stringBuffer = new StringBuffer(75);
        if (string2 == null) {
            JDBCDataSource.setBeanProperty(dataSource, "CreateDatabase", "create");
            stringBuffer.append("dataEncryption=true;");
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(";");
        }
        stringBuffer.append("encryptionAlgorithm=");
        stringBuffer.append(this.algorithm);
        stringBuffer.append(";");
        stringBuffer.append("encryptionKey=");
        switch (n) {
            case 0: {
                stringBuffer.append(this.keyCorrect);
                break;
            }
            case 1: {
                stringBuffer.append(this.keyWrong);
                break;
            }
            case 2: {
                stringBuffer.append(this.keyOddLength);
                break;
            }
            case 3: {
                stringBuffer.append(this.keyInvalidChar);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid key mode specified: " + n);
            }
        }
        stringBuffer.append(";");
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", stringBuffer.toString());
        return dataSource.getConnection();
    }

    protected void shutdown(String string) throws SQLException {
        this.shutdown(string, null);
    }

    protected void shutdown(String string, String string2) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(this.obtainDbName(string, string2));
        JDBCDataSource.shutdownDatabase(dataSource);
    }

    protected Connection createAndPopulateDB(String string) throws SQLException {
        Connection connection = this.getConnection(string, 0);
        SQLWarning sQLWarning = connection.getWarnings();
        if (sQLWarning != null && "01J01".equals(sQLWarning.getSQLState())) {
            EncryptionKeyTest.fail((String)("Refusing to continue, database already exists <" + sQLWarning.getMessage() + ">"));
        }
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE encryptionkeytestdata (id int NOT NULL, val int NOT NULL, PRIMARY KEY(id))");
        statement.close();
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO encryptionkeytestdata (id, val) VALUES (?,?)");
        for (int i = 0; i < DATA.length; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, DATA[i]);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        return connection;
    }

    protected void validateDBContents(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT id, val FROM encryptionkeytestdata ORDER BY id");
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            int n2 = resultSet.getInt(2);
            if (n >= DATA.length) {
                EncryptionKeyTest.fail((String)("Id in database out of bounds for data model; " + n + " >= " + DATA.length));
            }
            if (n2 == DATA[n]) continue;
            EncryptionKeyTest.fail((String)("Mismatch between db and model for id " + n + ";" + n2 + " != " + DATA[n]));
        }
        resultSet.close();
        statement.close();
    }
}

