/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.security.AccessControlException;
import java.security.AccessController;
import org.apache.derby.impl.services.cache.ConcurrentCache;
import org.apache.derby.mbeans.CacheManagerMBean;
import org.apache.derby.shared.common.security.SystemPermission;

final class ConcurrentCacheMBeanImpl
implements CacheManagerMBean {
    private final ConcurrentCache cache;

    ConcurrentCacheMBeanImpl(ConcurrentCache cache) {
        this.cache = cache;
    }

    @Override
    public void setCollectAccessCounts(boolean collect) {
        ConcurrentCacheMBeanImpl.checkPermission();
        this.cache.setCollectAccessCounts(collect);
    }

    @Override
    public boolean getCollectAccessCounts() {
        ConcurrentCacheMBeanImpl.checkPermission();
        return this.cache.getCollectAccessCounts();
    }

    @Override
    public long getHitCount() {
        ConcurrentCacheMBeanImpl.checkPermission();
        return this.cache.getHitCount();
    }

    @Override
    public long getMissCount() {
        ConcurrentCacheMBeanImpl.checkPermission();
        return this.cache.getMissCount();
    }

    @Override
    public long getEvictionCount() {
        ConcurrentCacheMBeanImpl.checkPermission();
        return this.cache.getEvictionCount();
    }

    @Override
    public long getMaxEntries() {
        ConcurrentCacheMBeanImpl.checkPermission();
        return this.cache.getMaxEntries();
    }

    @Override
    public long getAllocatedEntries() {
        ConcurrentCacheMBeanImpl.checkPermission();
        return this.cache.getAllocatedEntries();
    }

    @Override
    public long getUsedEntries() {
        ConcurrentCacheMBeanImpl.checkPermission();
        return this.cache.getUsedEntries();
    }

    private static void checkPermission() {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.checkPermission(SystemPermission.ENGINE_MONITOR);
            }
            catch (AccessControlException ace) {
                throw new SecurityException(ace.getMessage());
            }
        }
    }
}

