/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.tester;

import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.tester.TesterObject;

public class Tester1
extends TesterObject {
    public Tester1(String name) {
        super(name);
    }

    @Override
    public void startTesting() {
        this.connex = this.getConnection();
        if (this.connex == null) {
            NsTest.logger.println("FAIL: " + this.getThread_id() + " could not get the database connection");
            return;
        }
        try {
            this.connex.setAutoCommit(false);
        }
        catch (Exception e) {
            NsTest.logger.println("FAIL: " + this.getThread_id() + "'s setAutoCommit() failed:");
            this.printException("setting AutoCommit", e);
            return;
        }
        this.setIsolationLevel(1);
        for (int i = 0; i < NsTest.MAX_ITERATIONS; ++i) {
            int rnum = (int)(Math.random() * 100.0) % 4;
            switch (rnum) {
                case 0: {
                    try {
                        int numSelected = this.doSelectOperation(NsTest.MAX_LOW_STRESS_ROWS);
                        NsTest.logger.println(this.getThread_id() + " selected " + numSelected + " rows");
                        break;
                    }
                    catch (Exception e) {
                        NsTest.logger.println("--> Isolation Level is TRANSACTION_READ_UNCOMMITTED, hence SHOULD NOT FAIL ********* doSelect in thread " + this.getThread_id() + " threw " + e);
                        this.printException("doSelectOperation()", e);
                        if (NsTest.justCountErrors()) {
                            NsTest.printException(Tester1.class.getName(), e);
                        } else {
                            e.printStackTrace(NsTest.logger);
                        }
                        if (!NsTest.deadConnection(e)) break;
                        return;
                    }
                }
                case 1: 
                case 2: 
                case 3: {
                    for (int j = 0; j < NsTest.MAX_LOW_STRESS_ROWS; ++j) {
                        this.doIUDOperation();
                        if (!this.deadConnection()) continue;
                        return;
                    }
                    break;
                }
            }
            try {
                this.connex.commit();
                continue;
            }
            catch (Exception e) {
                NsTest.logger.println("FAIL: " + this.getThread_id() + "'s commit() failed:");
                this.printException("committing Xn in Tester1", e);
                return;
            }
        }
        this.closeConnection();
        NsTest.logger.println("Thread " + this.getThread_id() + " is now terminating");
    }
}

