/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Properties;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherFactoryBuilder;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.UndoHandler;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.iapi.store.replication.slave.SlaveFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.services.monitor.UpdateServiceProperties;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class RawStore
implements RawStoreFactory,
ModuleControl,
ModuleSupportable,
PrivilegedExceptionAction<Object> {
    private static final String BACKUP_HISTORY = "BACKUP.HISTORY";
    protected TransactionFactory xactFactory;
    protected DataFactory dataFactory;
    protected LogFactory logFactory;
    private SlaveFactory slaveFactory;
    private StorageFactory storageFactory;
    private SecureRandom random;
    private boolean isEncryptedDatabase;
    private CipherProvider encryptionEngine;
    private CipherProvider decryptionEngine;
    private CipherProvider newEncryptionEngine;
    private CipherProvider newDecryptionEngine;
    private CipherFactory currentCipherFactory;
    private CipherFactory newCipherFactory = null;
    private int counter_encrypt;
    private int counter_decrypt;
    private int encryptionBlockSize = 8;
    protected DaemonService rawStoreDaemon;
    private int actionCode;
    private static final int FILE_WRITER_ACTION = 1;
    private StorageFile actionStorageFile;
    private StorageFile actionToStorageFile;
    private boolean actionAppend;
    private static final int REGULAR_FILE_EXISTS_ACTION = 2;
    private File actionRegularFile;
    private static final int STORAGE_FILE_EXISTS_ACTION = 3;
    private static final int REGULAR_FILE_DELETE_ACTION = 4;
    private static final int REGULAR_FILE_MKDIRS_ACTION = 5;
    private static final int REGULAR_FILE_IS_DIRECTORY_ACTION = 6;
    private static final int REGULAR_FILE_REMOVE_DIRECTORY_ACTION = 7;
    private static final int REGULAR_FILE_RENAME_TO_ACTION = 8;
    private File actionRegularFile2;
    private static final int COPY_STORAGE_DIRECTORY_TO_REGULAR_ACTION = 9;
    private byte[] actionBuffer;
    private String[] actionFilter;
    private boolean actionCopySubDirs;
    private static final int COPY_REGULAR_DIRECTORY_TO_STORAGE_ACTION = 10;
    private static final int COPY_REGULAR_FILE_TO_STORAGE_ACTION = 11;
    private static final int REGULAR_FILE_LIST_DIRECTORY_ACTION = 12;
    private static final int STORAGE_FILE_LIST_DIRECTORY_ACTION = 13;
    private static final int COPY_STORAGE_FILE_TO_REGULAR_ACTION = 14;
    private static final int REGULAR_FILE_GET_CANONICALPATH_ACTION = 15;
    private static final int STORAGE_FILE_GET_CANONICALPATH_ACTION = 16;
    private static final int COPY_STORAGE_FILE_TO_STORAGE_ACTION = 17;
    private static final int STORAGE_FILE_DELETE_ACTION = 18;
    private static final int README_FILE_OUTPUTSTREAM_WRITER_ACTION = 19;
    public static final String TEST_REENCRYPT_CRASH_BEFORE_COMMT = "TEST_REENCRYPT_CRASH_BEFORE_COMMT";
    public static final String TEST_REENCRYPT_CRASH_AFTER_COMMT = "TEST_REENCRYPT_CRASH_AFTER_COMMT";
    public static final String TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY = "TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY";
    public static final String TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT = "TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT";
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE = "TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE";
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY = "TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY";
    public static final String TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP = "TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP";

    @Override
    public boolean canSupport(Properties startParams) {
        return true;
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        String logDevice;
        boolean transformExistingData = false;
        boolean inReplicationSlaveMode = false;
        String slave = properties.getProperty("replication.slave.mode");
        if (slave != null && slave.equals("slavemode")) {
            inReplicationSlaveMode = true;
        }
        DaemonFactory daemonFactory = (DaemonFactory)RawStore.startSystemModule("org.apache.derby.iapi.services.daemon.DaemonFactory");
        this.rawStoreDaemon = daemonFactory.createNewDaemon("rawStoreDaemon");
        this.xactFactory = (TransactionFactory)RawStore.bootServiceModule(create, this, this.getTransactionFactoryModule(), properties);
        this.dataFactory = (DataFactory)RawStore.bootServiceModule(create, this, this.getDataFactoryModule(), properties);
        this.storageFactory = this.dataFactory.getStorageFactory();
        String restoreFromBackup = null;
        if (properties != null) {
            restoreFromBackup = properties.getProperty("createFrom");
            if (restoreFromBackup == null) {
                restoreFromBackup = properties.getProperty("restoreFrom");
            }
            if (restoreFromBackup == null) {
                restoreFromBackup = properties.getProperty("rollForwardRecoveryFrom");
            }
        }
        if (create) {
            transformExistingData = this.setupEncryptionEngines(create, properties);
            SanityManager.ASSERT(!transformExistingData, "no crypto data transformation for a new db");
        }
        this.dataFactory.setRawStoreFactory(this, create, properties);
        this.xactFactory.setRawStoreFactory(this);
        if (properties instanceof UpdateServiceProperties && this.storageFactory instanceof WritableStorageFactory) {
            ((UpdateServiceProperties)properties).setStorageFactory((WritableStorageFactory)this.storageFactory);
        }
        this.logFactory = (LogFactory)RawStore.findServiceModule(this, this.getLogFactoryModule());
        if (restoreFromBackup != null) {
            this.restoreRemainingFromBackup(restoreFromBackup);
        }
        if ((logDevice = properties.getProperty("logDevice")) != null) {
            if (!(this.isReadOnly() || !create && logDevice.equals(this.logFactory.getCanonicalLogPath()) && restoreFromBackup == null)) {
                properties.put("logDevice", this.logFactory.getCanonicalLogPath());
                properties.put("derby.storage.logDeviceWhenBackedUp", this.logFactory.getCanonicalLogPath());
            }
        } else if (restoreFromBackup != null && this.logFactory.getCanonicalLogPath() != null) {
            properties.put("logDevice", this.logFactory.getCanonicalLogPath());
        } else {
            properties.remove("derby.storage.logDeviceWhenBackedUp");
        }
        if (restoreFromBackup != null) {
            ((UpdateServiceProperties)properties).saveServiceProperties();
        }
        if (!create) {
            if (properties.getProperty("derby.storage.databaseEncryptionStatus") != null) {
                this.handleIncompleteDbCryptoOperation(properties);
            }
            transformExistingData = this.setupEncryptionEngines(create, properties);
        }
        if (this.isEncryptedDatabase) {
            this.logFactory.setDatabaseEncrypted(true, false);
            this.dataFactory.setDatabaseEncrypted(true);
        }
        this.logFactory.setRawStoreFactory(this);
        if (inReplicationSlaveMode) {
            this.slaveFactory = (SlaveFactory)RawStore.bootServiceModule(create, this, this.getSlaveFactoryModule(), properties);
            this.slaveFactory.startSlave(this, this.logFactory);
        }
        this.logFactory.recover(this.dataFactory, this.xactFactory);
        if (transformExistingData) {
            this.applyBulkCryptoOperation(properties, this.newCipherFactory);
        }
    }

    @Override
    public void stop() {
        if (this.isEncryptedDatabase) {
            SanityManager.DEBUG_PRINT("encryption statistics", "Encryption called " + this.counter_encrypt + " times, decryption called " + this.counter_decrypt + " times");
        }
        if (this.rawStoreDaemon != null) {
            this.rawStoreDaemon.stop();
        }
        if (this.logFactory == null) {
            return;
        }
        try {
            if (this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, false) && this.dataFactory != null) {
                this.dataFactory.removeStubsOK();
            }
        }
        catch (StandardException se) {
            this.markCorrupt(se);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.dataFactory.isReadOnly();
    }

    @Override
    public LockFactory getLockFactory() {
        return this.xactFactory.getLockFactory();
    }

    @Override
    public TransactionFactory getXactFactory() {
        return this.xactFactory;
    }

    @Override
    public void setUndoInsertEventHandler(UndoHandler input_undo_handle) throws StandardException {
        this.dataFactory.setUndoInsertEventHandler(input_undo_handle);
    }

    @Override
    public Object getXAResourceManager() throws StandardException {
        return this.xactFactory.getXAResourceManager();
    }

    @Override
    public Transaction startGlobalTransaction(ContextManager contextMgr, int format_id, byte[] global_id, byte[] branch_id) throws StandardException {
        return this.xactFactory.startGlobalTransaction(this, contextMgr, format_id, global_id, branch_id);
    }

    @Override
    public Transaction startTransaction(ContextManager contextMgr, String transName) throws StandardException {
        return this.xactFactory.startTransaction(this, contextMgr, transName);
    }

    @Override
    public Transaction startNestedReadOnlyUserTransaction(Transaction parentTransaction, CompatibilitySpace compatibilitySpace, ContextManager contextMgr, String transName) throws StandardException {
        return this.xactFactory.startNestedReadOnlyUserTransaction(this, (RawTransaction)parentTransaction, compatibilitySpace, contextMgr, transName);
    }

    @Override
    public Transaction startNestedUpdateUserTransaction(Transaction parentTransaction, ContextManager contextMgr, String transName, boolean flush_log_on_xact_end) throws StandardException {
        return this.xactFactory.startNestedUpdateUserTransaction(this, (RawTransaction)parentTransaction, contextMgr, transName, flush_log_on_xact_end);
    }

    @Override
    public Transaction findUserTransaction(ContextManager contextMgr, String transName) throws StandardException {
        return this.xactFactory.findUserTransaction(this, contextMgr, transName);
    }

    @Override
    public Transaction startInternalTransaction(ContextManager contextMgr) throws StandardException {
        return this.xactFactory.startInternalTransaction(this, contextMgr);
    }

    @Override
    public void checkpoint() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
    }

    @Override
    public void startReplicationMaster(String dbmaster, String host, int port, String replicationMode) throws StandardException {
        if (this.isReadOnly()) {
            throw StandardException.newException("XRE00", new Object[0]);
        }
        RawTransaction t = this.xactFactory.findUserTransaction(this, RawStore.getContextService().getCurrentContextManager(), "UserTransaction");
        if (t.isBlockingBackup()) {
            throw StandardException.newException("XRE23", new Object[0]);
        }
        Properties replicationProps = new Properties();
        replicationProps.setProperty("derby.__rt.replication.master.mode", replicationMode);
        MasterFactory masterFactory = (MasterFactory)RawStore.bootServiceModule(true, this, this.getMasterFactoryModule(), replicationProps);
        masterFactory.startMaster(this, this.dataFactory, this.logFactory, host, port, dbmaster);
    }

    @Override
    public void stopReplicationMaster() throws StandardException {
        MasterFactory masterFactory = null;
        if (this.isReadOnly()) {
            throw StandardException.newException("XRE00", new Object[0]);
        }
        try {
            masterFactory = (MasterFactory)RawStore.findServiceModule(this, this.getMasterFactoryModule());
        }
        catch (StandardException se) {
            throw StandardException.newException("XRE07", new Object[0]);
        }
        masterFactory.stopMaster();
    }

    @Override
    public void failover(String dbname) throws StandardException {
        MasterFactory masterFactory = null;
        if (this.isReadOnly()) {
            throw StandardException.newException("XRE00", new Object[0]);
        }
        try {
            masterFactory = (MasterFactory)RawStore.findServiceModule(this, this.getMasterFactoryModule());
        }
        catch (StandardException se) {
            throw StandardException.newException("XRE07", new Object[0]);
        }
        masterFactory.startFailover();
    }

    @Override
    public void freeze() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.dataFactory.freezePersistentStore();
        this.logFactory.freezePersistentStore();
    }

    @Override
    public void unfreeze() throws StandardException {
        this.logFactory.unfreezePersistentStore();
        this.dataFactory.unfreezePersistentStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backup(String backupDir, boolean wait) throws StandardException {
        if (backupDir == null || backupDir.equals("")) {
            throw StandardException.newException("XSRS6.S", new Object[]{null});
        }
        String backupDirURL = null;
        try {
            URL url = new URL(backupDir);
            backupDirURL = url.getFile();
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        if (backupDirURL != null) {
            backupDir = backupDirURL;
        }
        RawTransaction t = this.xactFactory.findUserTransaction(this, RawStore.getContextService().getCurrentContextManager(), "UserTransaction");
        try {
            if (t.isBlockingBackup()) {
                throw StandardException.newException("XSRSB.S", new Object[0]);
            }
            if (!this.xactFactory.blockBackupBlockingOperations(wait)) {
                throw StandardException.newException("XSRSA.S", new Object[0]);
            }
            this.backup(t, new File(backupDir));
        }
        finally {
            this.xactFactory.unblockBackupBlockingOperations();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void backup(Transaction t, File backupDir) throws StandardException {
        StorageFile logdir;
        if (!this.privExists(backupDir)) {
            this.createBackupDirectory(backupDir);
        } else {
            if (!this.privIsDirectory(backupDir)) {
                throw StandardException.newException("XSRS1.S", backupDir);
            }
            if (this.privExists(new File(backupDir, "service.properties"))) {
                throw StandardException.newException("XSRSC.S", backupDir);
            }
        }
        boolean error = true;
        boolean renamed = false;
        boolean renameFailed = false;
        File oldbackup = null;
        File backupcopy = null;
        OutputStreamWriter historyFile = null;
        StorageFile dbHistoryFile = null;
        File backupHistoryFile = null;
        LogInstant backupInstant = this.logFactory.getFirstUnflushedInstant();
        try {
            StorageFile dbase = this.storageFactory.newStorageFile(null);
            String canonicalDbName = this.storageFactory.getCanonicalName();
            String dbname = StringUtil.shortDBName(canonicalDbName, this.storageFactory.getSeparator());
            historyFile = this.privFileWriter(this.storageFactory.newStorageFile(BACKUP_HISTORY), true);
            backupcopy = new File(backupDir, dbname);
            this.logHistory(historyFile, MessageService.getTextMessage("D004", canonicalDbName, this.getFilePath(backupcopy)));
            if (this.privExists(backupcopy)) {
                oldbackup = new File(backupDir, dbname + ".OLD");
                if (this.privExists(oldbackup)) {
                    if (this.privIsDirectory(oldbackup)) {
                        this.privRemoveDirectory(oldbackup);
                    } else {
                        this.privDelete(oldbackup);
                    }
                }
                if (!this.privRenameTo(backupcopy, oldbackup)) {
                    renameFailed = true;
                    throw StandardException.newException("XSRS4.S", backupcopy, oldbackup);
                }
                this.logHistory(historyFile, MessageService.getTextMessage("D005", this.getFilePath(backupcopy), this.getFilePath(oldbackup)));
                renamed = true;
            }
            this.createBackupDirectory(backupcopy);
            dbHistoryFile = this.storageFactory.newStorageFile(BACKUP_HISTORY);
            backupHistoryFile = new File(backupcopy, BACKUP_HISTORY);
            if (!this.privCopyFile(dbHistoryFile, backupHistoryFile)) {
                throw StandardException.newException("XSRS5.S", dbHistoryFile, backupHistoryFile);
            }
            StorageFile jarDir = this.storageFactory.newStorageFile("jar");
            if (this.privExists(jarDir)) {
                int i;
                String[] jarDirContents = this.privList(jarDir);
                File backupJarDir = new File(backupcopy, "jar");
                this.createBackupDirectory(backupJarDir);
                LanguageConnectionContext lcc = (LanguageConnectionContext)RawStore.getContextOrNull("LanguageConnectionContext");
                boolean uuidSupported = lcc.getDataDictionary().checkVersion(210, null);
                if (uuidSupported) {
                    for (i = 0; i < jarDirContents.length; ++i) {
                        StorageFile jar = this.storageFactory.newStorageFile(jarDir, jarDirContents[i]);
                        File backupJar = new File(backupJarDir, jarDirContents[i]);
                        if (this.privIsDirectory(new File(jar.getPath())) || this.privCopyFile(jar, backupJar)) continue;
                        throw StandardException.newException("XSRS5.S", jar, backupJar);
                    }
                } else {
                    for (i = 0; i < jarDirContents.length; ++i) {
                        File backupJarSchemaDir;
                        StorageFile jarSchemaDir = this.storageFactory.newStorageFile(jarDir, jarDirContents[i]);
                        if (this.privCopyDirectory(jarSchemaDir, backupJarSchemaDir = new File(backupJarDir, jarDirContents[i]), null, null, false)) continue;
                        throw StandardException.newException("XSRS5.S", jarSchemaDir, backupJarSchemaDir);
                    }
                }
            }
            logdir = this.logFactory.getLogDirectory();
            try {
                String name = RawStore.getServiceName(this);
                PersistentService ps = RawStore.getMonitor().getServiceType(this);
                String fullName = ps.getCanonicalServiceName(name);
                Properties prop = ps.getServiceProperties(fullName, null);
                StorageFile defaultLogDir = this.storageFactory.newStorageFile("log");
                if (!logdir.equals(defaultLogDir)) {
                    prop.remove("logDevice");
                    SanityManager.ASSERT(prop.getProperty("logDevice") == null, "cannot get rid of logDevice property");
                    this.logHistory(historyFile, MessageService.getTextMessage("D007", new Object[0]));
                }
                ps.saveServiceProperties(backupcopy.getPath(), prop);
            }
            catch (StandardException se) {
                this.logHistory(historyFile, MessageService.getTextMessage("D008", new Object[0]) + se);
                try {
                    if (error) {
                        this.logFactory.abortLogBackup();
                        if (!renameFailed) {
                            this.privRemoveDirectory(backupcopy);
                        }
                        if (renamed) {
                            this.privRenameTo(oldbackup, backupcopy);
                        }
                        this.logHistory(historyFile, MessageService.getTextMessage("D010", new Object[0]));
                    } else {
                        if (renamed && this.privExists(oldbackup)) {
                            this.privRemoveDirectory(oldbackup);
                            this.logHistory(historyFile, MessageService.getTextMessage("D011", this.getFilePath(oldbackup)));
                        }
                        this.logHistory(historyFile, MessageService.getTextMessage("D012", backupInstant));
                        if (!this.privCopyFile(dbHistoryFile, backupHistoryFile)) {
                            throw StandardException.newException("XSRS5.S", dbHistoryFile, backupHistoryFile);
                        }
                    }
                    historyFile.close();
                    return;
                }
                catch (IOException ioe) {
                    try {
                        historyFile.close();
                        throw StandardException.newException("XSRS7.S", ioe, new Object[0]);
                    }
                    catch (IOException fullName) {
                        // empty catch block
                    }
                    throw StandardException.newException("XSRS7.S", ioe, new Object[0]);
                }
            }
        }
        catch (IOException ioe) {
            try {
                throw StandardException.newException("XSRS7.S", ioe, new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (error) {
                        this.logFactory.abortLogBackup();
                        if (!renameFailed) {
                            this.privRemoveDirectory(backupcopy);
                        }
                        if (renamed) {
                            this.privRenameTo(oldbackup, backupcopy);
                        }
                        this.logHistory(historyFile, MessageService.getTextMessage("D010", new Object[0]));
                    } else {
                        if (renamed && this.privExists(oldbackup)) {
                            this.privRemoveDirectory(oldbackup);
                            this.logHistory(historyFile, MessageService.getTextMessage("D011", this.getFilePath(oldbackup)));
                        }
                        this.logHistory(historyFile, MessageService.getTextMessage("D012", backupInstant));
                        if (!this.privCopyFile(dbHistoryFile, backupHistoryFile)) {
                            throw StandardException.newException("XSRS5.S", dbHistoryFile, backupHistoryFile);
                        }
                    }
                    historyFile.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    try {
                        historyFile.close();
                        throw StandardException.newException("XSRS7.S", ioe2, new Object[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw StandardException.newException("XSRS7.S", ioe2, new Object[0]);
                }
            }
        }
        {
            File backupVerifyKeyFile;
            StorageFile verifyKeyFile = this.storageFactory.newStorageFile("verifyKey.dat");
            if (this.privExists(verifyKeyFile) && !this.privCopyFile(verifyKeyFile, backupVerifyKeyFile = new File(backupcopy, "verifyKey.dat"))) {
                throw StandardException.newException("XSRS5.S", verifyKeyFile, backupVerifyKeyFile);
            }
            File logBackup = new File(backupcopy, "log");
            if (this.privExists(logBackup)) {
                this.privRemoveDirectory(logBackup);
            }
            this.createBackupDirectory(logBackup);
            this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
            this.logFactory.startLogBackup(logBackup);
            File segBackup = new File(backupcopy, "seg0");
            this.createBackupDirectory(segBackup);
            this.dataFactory.backupDataFiles(t, segBackup);
            this.logHistory(historyFile, MessageService.getTextMessage("D006", this.getFilePath(segBackup)));
            this.logFactory.endLogBackup(logBackup);
            this.logHistory(historyFile, MessageService.getTextMessage("D009", this.getFilePath(logdir), this.getFilePath(logBackup)));
            error = false;
        }
        try {
            if (error) {
                this.logFactory.abortLogBackup();
                if (!renameFailed) {
                    this.privRemoveDirectory(backupcopy);
                }
                if (renamed) {
                    this.privRenameTo(oldbackup, backupcopy);
                }
                this.logHistory(historyFile, MessageService.getTextMessage("D010", new Object[0]));
            } else {
                if (renamed && this.privExists(oldbackup)) {
                    this.privRemoveDirectory(oldbackup);
                    this.logHistory(historyFile, MessageService.getTextMessage("D011", this.getFilePath(oldbackup)));
                }
                this.logHistory(historyFile, MessageService.getTextMessage("D012", backupInstant));
                if (!this.privCopyFile(dbHistoryFile, backupHistoryFile)) {
                    throw StandardException.newException("XSRS5.S", dbHistoryFile, backupHistoryFile);
                }
            }
            historyFile.close();
            return;
        }
        catch (IOException ioe) {
            try {
                historyFile.close();
                throw StandardException.newException("XSRS7.S", ioe, new Object[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw StandardException.newException("XSRS7.S", ioe, new Object[0]);
        }
    }

    private void createBackupDirectory(File dir) throws StandardException {
        boolean created = false;
        IOException ex = null;
        try {
            created = this.privMkdirs(dir);
        }
        catch (IOException ioe) {
            ex = ioe;
        }
        if (!created) {
            throw StandardException.newException("XSRS6.S", ex, dir);
        }
    }

    @Override
    public void backupAndEnableLogArchiveMode(String backupDir, boolean deleteOnlineArchivedLogFiles, boolean wait) throws StandardException {
        boolean enabledLogArchive = false;
        try {
            if (!this.logFactory.logArchived()) {
                this.logFactory.enableLogArchiveMode();
                enabledLogArchive = true;
            }
            this.backup(backupDir, wait);
            if (deleteOnlineArchivedLogFiles) {
                this.logFactory.deleteOnlineArchivedLogFiles();
            }
        }
        catch (Throwable error) {
            if (enabledLogArchive) {
                this.logFactory.disableLogArchiveMode();
            }
            throw StandardException.plainWrapException(error);
        }
    }

    @Override
    public void disableLogArchiveMode(boolean deleteOnlineArchivedLogFiles) throws StandardException {
        this.logFactory.disableLogArchiveMode();
        if (deleteOnlineArchivedLogFiles) {
            this.logFactory.deleteOnlineArchivedLogFiles();
        }
    }

    private void restoreRemainingFromBackup(String backupPath) throws StandardException {
        File backupJarDir = new File(backupPath, "jar");
        StorageFile dbJarDir = this.storageFactory.newStorageFile("jar");
        if (!this.privExists(dbJarDir) && this.privExists(backupJarDir) && !this.privCopyDirectory(backupJarDir, dbJarDir)) {
            throw StandardException.newException("XBM0Z.D", backupJarDir, dbJarDir);
        }
        StorageFile dbHistoryFile = this.storageFactory.newStorageFile(BACKUP_HISTORY);
        File backupHistoryFile = new File(backupPath, BACKUP_HISTORY);
        if (this.privExists(backupHistoryFile) && !this.privExists(dbHistoryFile) && !this.privCopyFile(backupHistoryFile, dbHistoryFile)) {
            throw StandardException.newException("XSRS5.S", backupHistoryFile, dbHistoryFile);
        }
    }

    @Override
    public void idle() throws StandardException {
        this.dataFactory.idle();
    }

    @Override
    public TransactionInfo[] getTransactionInfo() {
        return this.xactFactory.getTransactionInfo();
    }

    @Override
    public ScanHandle openFlushedScan(DatabaseInstant start, int groupsIWant) throws StandardException {
        return this.logFactory.openFlushedScan(start, groupsIWant);
    }

    @Override
    public DaemonService getDaemon() {
        return this.rawStoreDaemon;
    }

    @Override
    public void createFinished() throws StandardException {
        this.xactFactory.createFinished();
        this.dataFactory.createFinished();
    }

    @Override
    public void getRawStoreProperties(PersistentSet set) throws StandardException {
        this.logFactory.getLogFactoryProperties(set);
    }

    @Override
    public void freezePersistentStore() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.logFactory.freezePersistentStore();
    }

    @Override
    public void unfreezePersistentStore() throws StandardException {
        this.logFactory.unfreezePersistentStore();
    }

    private boolean setupEncryptionEngines(boolean create, Properties properties) throws StandardException {
        boolean decryptDatabase = RawStore.isTrue(properties, "decryptDatabase");
        boolean encryptDatabase = RawStore.isTrue(properties, "dataEncryption");
        boolean reEncrypt = false;
        if (!create) {
            String name = RawStore.getServiceName(this);
            PersistentService ps = RawStore.getMonitor().getServiceType(this);
            String canonicalName = ps.getCanonicalServiceName(name);
            Properties serviceprops = ps.getServiceProperties(canonicalName, null);
            this.isEncryptedDatabase = RawStore.isTrue(serviceprops, "dataEncryption");
            if (this.isEncryptedDatabase) {
                encryptDatabase = reEncrypt = RawStore.isSet(properties, "newBootPassword") || RawStore.isSet(properties, "newEncryptionKey");
            } else if (encryptDatabase && decryptDatabase) {
                throw StandardException.newException("XJ048.C", "decryptDatabase, dataEncryption");
            }
            if ((encryptDatabase || decryptDatabase) && this.isReadOnly()) {
                throw StandardException.newException("XBCXQ.S", new Object[0]);
            }
        }
        if (this.isEncryptedDatabase || encryptDatabase) {
            boolean setupEncryption = create || encryptDatabase && !reEncrypt;
            CipherFactoryBuilder cb = (CipherFactoryBuilder)RawStore.startSystemModule("org.apache.derby.iapi.services.crypto.CipherFactoryBuilder");
            this.currentCipherFactory = cb.createCipherFactory(setupEncryption, properties, false);
            this.currentCipherFactory.verifyKey(setupEncryption, this.storageFactory, properties);
            this.encryptionEngine = this.currentCipherFactory.createNewCipher(1);
            if (setupEncryption) {
                this.encryptionBlockSize = this.encryptionEngine.getEncryptionBlockSize();
                if (create) {
                    properties.put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
                }
            } else {
                this.encryptionBlockSize = RawStore.isSet(properties, "derby.encryptionBlockSize") ? Integer.parseInt(properties.getProperty("derby.encryptionBlockSize")) : this.encryptionEngine.getEncryptionBlockSize();
            }
            this.decryptionEngine = this.currentCipherFactory.createNewCipher(2);
            this.random = this.currentCipherFactory.getSecureRandom();
            if (encryptDatabase) {
                if (reEncrypt) {
                    this.newCipherFactory = cb.createCipherFactory(setupEncryption, properties, true);
                    this.newDecryptionEngine = this.newCipherFactory.createNewCipher(2);
                    this.newEncryptionEngine = this.newCipherFactory.createNewCipher(1);
                } else {
                    this.newDecryptionEngine = this.decryptionEngine;
                    this.newEncryptionEngine = this.encryptionEngine;
                }
            }
            if (create) {
                this.currentCipherFactory.saveProperties(properties);
                this.isEncryptedDatabase = true;
            }
        }
        return !create && (encryptDatabase || this.isEncryptedDatabase && decryptDatabase);
    }

    @Override
    public int encrypt(byte[] cleartext, int offset, int length, byte[] ciphertext, int outputOffset, boolean newEngine) throws StandardException {
        if (this.encryptionEngine == null && this.newEncryptionEngine == null) {
            throw StandardException.newException("XSAI3.S", new Object[0]);
        }
        ++this.counter_encrypt;
        if (newEngine) {
            return this.newEncryptionEngine.encrypt(cleartext, offset, length, ciphertext, outputOffset);
        }
        return this.encryptionEngine.encrypt(cleartext, offset, length, ciphertext, outputOffset);
    }

    @Override
    public int decrypt(byte[] ciphertext, int offset, int length, byte[] cleartext, int outputOffset) throws StandardException {
        if (!this.isEncryptedDatabase || this.decryptionEngine == null) {
            throw StandardException.newException("XSAI3.S", new Object[0]);
        }
        ++this.counter_decrypt;
        return this.decryptionEngine.decrypt(ciphertext, offset, length, cleartext, outputOffset);
    }

    @Override
    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }

    @Override
    public int random() {
        return this.isEncryptedDatabase ? this.random.nextInt() : 0;
    }

    @Override
    public Serializable changeBootPassword(Properties properties, Serializable changePassword) throws StandardException {
        if (this.isReadOnly()) {
            throw StandardException.newException("XBCX9.S", new Object[0]);
        }
        if (!this.isEncryptedDatabase) {
            throw StandardException.newException("XBCX8.S", new Object[0]);
        }
        if (changePassword == null) {
            throw StandardException.newException("XBCX5.S", new Object[0]);
        }
        if (!(changePassword instanceof String)) {
            throw StandardException.newException("XBCX6.S", new Object[0]);
        }
        String changeString = (String)((Object)changePassword);
        return this.currentCipherFactory.changeBootPassword((String)((Object)changePassword), properties, this.encryptionEngine);
    }

    private void crashOnDebugFlag(String debugFlag, boolean reEncrypt) throws StandardException {
        if (SanityManager.DEBUG_ON(debugFlag)) {
            StandardException se = StandardException.newException("XBCXU.S", debugFlag);
            this.markCorrupt(se);
            throw se;
        }
    }

    private void applyBulkCryptoOperation(Properties properties, CipherFactory newCipherFactory) throws StandardException {
        boolean decryptDatabase = this.isEncryptedDatabase && RawStore.isTrue(properties, "decryptDatabase");
        boolean reEncrypt = this.isEncryptedDatabase && (RawStore.isSet(properties, "newBootPassword") || RawStore.isSet(properties, "newEncryptionKey"));
        SanityManager.ASSERT(decryptDatabase || reEncrypt || !this.isEncryptedDatabase && RawStore.isSet(properties, "dataEncryption"));
        this.cryptoOperationAllowed(reEncrypt, decryptDatabase);
        boolean externalKeyEncryption = RawStore.isSet(properties, "encryptionKey");
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        RawTransaction transaction = this.xactFactory.startTransaction(this, RawStore.getContextService().getCurrentContextManager(), "UserTransaction");
        try {
            if (decryptDatabase) {
                this.dataFactory.decryptAllContainers(transaction);
            } else {
                this.dataFactory.encryptAllContainers(transaction);
            }
            this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_BEFORE_COMMT, reEncrypt);
            if (!this.logFactory.isCheckpointInLastLogFile()) {
                this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
            }
            if (decryptDatabase) {
                this.isEncryptedDatabase = false;
                this.logFactory.setDatabaseEncrypted(false, true);
                this.dataFactory.setDatabaseEncrypted(false);
            } else {
                this.logFactory.setDatabaseEncrypted(true, true);
                if (reEncrypt) {
                    this.decryptionEngine = this.newDecryptionEngine;
                    this.encryptionEngine = this.newEncryptionEngine;
                    this.currentCipherFactory = newCipherFactory;
                } else {
                    this.isEncryptedDatabase = true;
                    this.dataFactory.setDatabaseEncrypted(true);
                }
            }
            this.logFactory.startNewLogFile();
            properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(1));
            if (reEncrypt) {
                if (externalKeyEncryption) {
                    StorageFile oldVerifyKeyFile;
                    StorageFile verifyKeyFile = this.storageFactory.newStorageFile("verifyKey.dat");
                    if (!this.privCopyFile(verifyKeyFile, oldVerifyKeyFile = this.storageFactory.newStorageFile("verifyOldKey.dat"))) {
                        throw StandardException.newException("XSRS5.S", verifyKeyFile, oldVerifyKeyFile);
                    }
                    this.currentCipherFactory.verifyKey(reEncrypt, this.storageFactory, properties);
                } else {
                    String keyString = properties.getProperty("encryptedBootPassword");
                    if (keyString != null) {
                        properties.put("OldEncryptedBootPassword", keyString);
                    }
                }
            } else if (decryptDatabase) {
                properties.put("dataEncryption", "false");
            } else {
                properties.put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
            }
            this.currentCipherFactory.saveProperties(properties);
            this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY, reEncrypt);
            transaction.commit();
            this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_AFTER_COMMT, reEncrypt);
            this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
            this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT, reEncrypt);
            properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(3));
            this.dataFactory.removeOldVersionOfContainers();
            if (decryptDatabase) {
                this.removeCryptoProperties(properties);
            } else if (reEncrypt) {
                if (externalKeyEncryption) {
                    StorageFile oldVerifyKeyFile = this.storageFactory.newStorageFile("verifyOldKey.dat");
                    if (!this.privDelete(oldVerifyKeyFile)) {
                        throw StandardException.newException("XBM0R.D", oldVerifyKeyFile);
                    }
                } else {
                    properties.remove("OldEncryptedBootPassword");
                }
            }
            properties.remove("derby.storage.databaseEncryptionStatus");
            transaction.close();
        }
        catch (StandardException se) {
            throw StandardException.newException("XBCXU.S", se, se.getMessage());
        }
        finally {
            this.newDecryptionEngine = null;
            this.newEncryptionEngine = null;
        }
    }

    public void handleIncompleteDbCryptoOperation(Properties properties) throws StandardException {
        boolean decryptionFailed;
        int dbEncryptionStatus = 0;
        String dbEncryptionStatusStr = properties.getProperty("derby.storage.databaseEncryptionStatus");
        if (dbEncryptionStatusStr != null) {
            dbEncryptionStatus = Integer.parseInt(dbEncryptionStatusStr);
        }
        boolean reEncryption = false;
        boolean bl = decryptionFailed = RawStore.isSet(properties, "dataEncryption") && !RawStore.isTrue(properties, "dataEncryption");
        if (dbEncryptionStatus == 1) {
            if (this.logFactory.isCheckpointInLastLogFile()) {
                dbEncryptionStatus = 3;
            } else {
                dbEncryptionStatus = 2;
                properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(dbEncryptionStatus));
            }
        }
        if (dbEncryptionStatus == 2) {
            this.logFactory.deleteLogFileAfterCheckpointLogFile();
            this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE, reEncryption);
            StorageFile verifyKeyFile = this.storageFactory.newStorageFile("verifyKey.dat");
            if (this.privExists(verifyKeyFile)) {
                StorageFile oldVerifyKeyFile = this.storageFactory.newStorageFile("verifyOldKey.dat");
                if (this.privExists(oldVerifyKeyFile)) {
                    if (!this.privCopyFile(oldVerifyKeyFile, verifyKeyFile)) {
                        throw StandardException.newException("XSRS5.S", oldVerifyKeyFile, verifyKeyFile);
                    }
                    reEncryption = true;
                } else if (!decryptionFailed && !this.privDelete(verifyKeyFile)) {
                    throw StandardException.newException("XBM0R.D", verifyKeyFile);
                }
            } else {
                String OldKeyString = properties.getProperty("OldEncryptedBootPassword");
                if (OldKeyString != null) {
                    properties.put("encryptedBootPassword", OldKeyString);
                    reEncryption = true;
                }
            }
            SanityManager.ASSERT(!decryptionFailed || !reEncryption);
            this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY, reEncryption);
            if (!decryptionFailed && !reEncryption) {
                this.removeCryptoProperties(properties);
            }
        }
        if (dbEncryptionStatus == 3) {
            this.dataFactory.removeOldVersionOfContainers();
        }
        this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP, reEncryption);
        StorageFile oldVerifyKeyFile = this.storageFactory.newStorageFile("verifyOldKey.dat");
        if (this.privExists(oldVerifyKeyFile)) {
            if (!this.privDelete(oldVerifyKeyFile)) {
                throw StandardException.newException("XBM0R.D", oldVerifyKeyFile);
            }
        } else {
            properties.remove("OldEncryptedBootPassword");
        }
        if (decryptionFailed) {
            if (dbEncryptionStatus == 2) {
                properties.setProperty("dataEncryption", "true");
            } else {
                this.removeCryptoProperties(properties);
            }
        }
        properties.remove("derby.storage.databaseEncryptionStatus");
    }

    private void cryptoOperationAllowed(boolean reEncrypt, boolean decrypt) throws StandardException {
        String feature = decrypt ? "decryptDatabase attribute" : (reEncrypt ? "newBootPassword/newEncryptionKey attribute" : "dataEncryption attribute on an existing database");
        int requiredMinorVersion = decrypt ? 10 : 2;
        this.logFactory.checkVersion(10, requiredMinorVersion, feature);
        if (this.xactFactory.hasPreparedXact()) {
            throw StandardException.newException("XBCXO.S", new Object[0]);
        }
        if (this.logFactory.logArchived()) {
            throw StandardException.newException("XBCXS.S", new Object[0]);
        }
    }

    @Override
    public StandardException markCorrupt(StandardException originalError) {
        this.logFactory.markCorrupt(originalError);
        this.dataFactory.markCorrupt(originalError);
        this.xactFactory.markCorrupt(originalError);
        return originalError;
    }

    @Override
    public String getTransactionFactoryModule() {
        return "org.apache.derby.iapi.store.raw.xact.TransactionFactory";
    }

    public String getSlaveFactoryModule() {
        return "org.apache.derby.iapi.store.replication.slave.SlaveFactory";
    }

    public String getMasterFactoryModule() {
        return "org.apache.derby.iapi.store.replication.master.MasterFactory";
    }

    @Override
    public String getDataFactoryModule() {
        return "org.apache.derby.iapi.store.raw.data.DataFactory";
    }

    @Override
    public String getLogFactoryModule() {
        return "org.apache.derby.iapi.store.raw.log.LogFactory";
    }

    private void logHistory(OutputStreamWriter historyFile, String msg) throws IOException {
        Date d = new Date();
        historyFile.write(d.toString() + ":" + msg + "\n");
        historyFile.flush();
    }

    private String getFilePath(StorageFile file) {
        String path = this.privGetCanonicalPath(file);
        if (path != null) {
            return path;
        }
        return file.getPath();
    }

    private String getFilePath(File file) {
        String path = this.privGetCanonicalPath(file);
        if (path != null) {
            return path;
        }
        return file.getPath();
    }

    protected boolean privCopyDirectory(StorageFile from, File to) throws StandardException {
        return this.privCopyDirectory(from, to, null, null, true);
    }

    protected boolean privCopyDirectory(File from, StorageFile to) {
        return this.privCopyDirectory(from, to, null, null);
    }

    @Override
    public long getMaxContainerId() throws StandardException {
        return this.dataFactory.getMaxContainerId();
    }

    @Override
    public boolean checkVersion(int requiredMajorVersion, int requiredMinorVersion, String feature) throws StandardException {
        return this.logFactory.checkVersion(requiredMajorVersion, requiredMinorVersion, feature);
    }

    private void removeCryptoProperties(Properties properties) {
        properties.remove("dataEncryption");
        properties.remove("log_encrypt_algorithm_version");
        properties.remove("data_encrypt_algorithm_version");
        properties.remove("derby.encryptionBlockSize");
        properties.remove("encryptionKeyLength");
        properties.remove("encryptionProvider");
        properties.remove("encryptionAlgorithm");
        properties.remove("encryptedBootPassword");
    }

    private synchronized OutputStreamWriter privFileWriter(StorageFile fileName, boolean append) throws IOException {
        this.actionCode = 1;
        this.actionStorageFile = fileName;
        this.actionAppend = append;
        try {
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)AccessController.doPrivileged(this);
            return outputStreamWriter;
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(File file) {
        this.actionCode = 2;
        this.actionRegularFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(StorageFile file) {
        this.actionCode = 3;
        this.actionStorageFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized OutputStreamWriter privGetOutputStreamWriter(StorageFile file) throws IOException {
        this.actionCode = 19;
        this.actionStorageFile = file;
        try {
            return (OutputStreamWriter)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(File file) {
        this.actionCode = 4;
        this.actionRegularFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(StorageFile file) {
        this.actionCode = 18;
        this.actionStorageFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized boolean privMkdirs(File file) throws IOException {
        this.actionCode = 5;
        this.actionRegularFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privIsDirectory(File file) {
        this.actionCode = 6;
        this.actionRegularFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privRemoveDirectory(File file) {
        this.actionCode = 7;
        this.actionRegularFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privRenameTo(File file1, File file2) {
        this.actionCode = 8;
        this.actionRegularFile = file1;
        this.actionRegularFile2 = file2;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
            this.actionRegularFile2 = null;
        }
    }

    private synchronized boolean privCopyDirectory(StorageFile from, File to, byte[] buffer, String[] filter, boolean copySubdirs) throws StandardException {
        this.actionCode = 9;
        this.actionStorageFile = from;
        this.actionRegularFile = to;
        this.actionBuffer = buffer;
        this.actionFilter = filter;
        this.actionCopySubDirs = copySubdirs;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getCause();
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyDirectory(File from, StorageFile to, byte[] buffer, String[] filter) {
        this.actionCode = 10;
        this.actionStorageFile = to;
        this.actionRegularFile = from;
        this.actionBuffer = buffer;
        this.actionFilter = filter;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(File from, StorageFile to) {
        this.actionCode = 11;
        this.actionStorageFile = to;
        this.actionRegularFile = from;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
        }
    }

    private synchronized boolean privCopyFile(StorageFile from, File to) throws StandardException {
        this.actionCode = 14;
        this.actionStorageFile = from;
        this.actionRegularFile = to;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getCause();
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(StorageFile from, StorageFile to) {
        this.actionCode = 17;
        this.actionStorageFile = from;
        this.actionToStorageFile = to;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
            this.actionToStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] privList(StorageFile file) {
        this.actionCode = 13;
        this.actionStorageFile = file;
        try {
            String[] stringArray = (String[])AccessController.doPrivileged(this);
            return stringArray;
        }
        catch (PrivilegedActionException pae) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String privGetCanonicalPath(StorageFile file) {
        this.actionCode = 16;
        this.actionStorageFile = file;
        try {
            String string = (String)AccessController.doPrivileged(this);
            return string;
        }
        catch (PrivilegedActionException pae) {
            String string = null;
            return string;
        }
        catch (SecurityException se) {
            String string = null;
            return string;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String privGetCanonicalPath(File file) {
        this.actionCode = 15;
        this.actionRegularFile = file;
        try {
            String string = (String)AccessController.doPrivileged(this);
            return string;
        }
        catch (PrivilegedActionException pae) {
            String string = null;
            return string;
        }
        catch (SecurityException se) {
            String string = null;
            return string;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    @Override
    public final Object run() throws IOException, StandardException {
        switch (this.actionCode) {
            case 1: {
                return new OutputStreamWriter(this.actionStorageFile.getOutputStream(this.actionAppend));
            }
            case 2: {
                return this.actionRegularFile.exists();
            }
            case 3: {
                return this.actionStorageFile.exists();
            }
            case 4: {
                return this.actionRegularFile.delete();
            }
            case 18: {
                return this.actionStorageFile.delete();
            }
            case 5: {
                boolean created = this.actionRegularFile.mkdirs();
                FileUtil.limitAccessToOwner(this.actionRegularFile);
                return created;
            }
            case 6: {
                return this.actionRegularFile.isDirectory();
            }
            case 7: {
                return FileUtil.removeDirectory(this.actionRegularFile);
            }
            case 8: {
                return this.actionRegularFile.renameTo(this.actionRegularFile2);
            }
            case 9: {
                return FileUtil.copyDirectory(this.storageFactory, this.actionStorageFile, this.actionRegularFile, this.actionBuffer, this.actionFilter, this.actionCopySubDirs);
            }
            case 10: {
                return FileUtil.copyDirectory((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile, this.actionBuffer, this.actionFilter);
            }
            case 11: {
                return FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile);
            }
            case 12: {
                return this.actionRegularFile.list();
            }
            case 13: {
                return this.actionStorageFile.list();
            }
            case 14: {
                return FileUtil.copyFile((StorageFactory)((WritableStorageFactory)this.storageFactory), this.actionStorageFile, this.actionRegularFile);
            }
            case 17: {
                return FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionStorageFile, this.actionToStorageFile);
            }
            case 15: {
                return this.actionRegularFile.getCanonicalPath();
            }
            case 16: {
                return this.actionStorageFile.getCanonicalPath();
            }
            case 19: {
                return new OutputStreamWriter(this.actionStorageFile.getOutputStream(), "UTF8");
            }
        }
        return null;
    }

    private static boolean isSet(Properties p, String attribute) {
        return p.getProperty(attribute) != null;
    }

    private static boolean isTrue(Properties p, String attribute) {
        return Boolean.valueOf(p.getProperty(attribute));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDataWarningFile() throws StandardException {
        StorageFile fileReadMe = this.storageFactory.newStorageFile("seg0", "README_DO_NOT_TOUCH_FILES.txt");
        OutputStreamWriter osw = null;
        if (!this.privExists(fileReadMe)) {
            try {
                osw = this.privGetOutputStreamWriter(fileReadMe);
                osw.write(MessageService.getTextMessage("M007", new Object[0]));
            }
            catch (IOException iOException) {
            }
            finally {
                if (osw != null) {
                    try {
                        osw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static ContextService getContextService() {
        if (System.getSecurityManager() == null) {
            return ContextService.getFactory();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Context getContextOrNull(final String contextID) {
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(contextID);
            }
        });
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static String getServiceName(final Object serviceModule) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Monitor.getServiceName(serviceModule);
            }
        });
    }

    private static Object startSystemModule(final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.startSystemModule(factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }

    private static Object bootServiceModule(final boolean create, final Object serviceModule, final String factoryInterface, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.bootServiceModule(create, serviceModule, factoryInterface, properties);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }

    private static Object findServiceModule(final Object serviceModule, final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(serviceModule, factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }
}

