/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.xact.ContainerLocking2;
import org.apache.derby.impl.store.raw.xact.ContainerLocking3;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.InternalXact;
import org.apache.derby.impl.store.raw.xact.NoLocking;
import org.apache.derby.impl.store.raw.xact.RowLocking1;
import org.apache.derby.impl.store.raw.xact.RowLocking2;
import org.apache.derby.impl.store.raw.xact.RowLocking2nohold;
import org.apache.derby.impl.store.raw.xact.RowLocking3;
import org.apache.derby.impl.store.raw.xact.RowLockingRR;
import org.apache.derby.impl.store.raw.xact.TransactionTable;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.impl.store.raw.xact.XactContext;
import org.apache.derby.impl.store.raw.xact.XactId;
import org.apache.derby.impl.store.raw.xact.XactXAResourceManager;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class XactFactory
implements TransactionFactory,
ModuleControl,
ModuleSupportable {
    protected static final String USER_CONTEXT_ID = "UserTransaction";
    protected static final String NESTED_READONLY_USER_CONTEXT_ID = "NestedRawReadOnlyUserTransaction";
    protected static final String NESTED_UPDATE_USER_CONTEXT_ID = "NestedRawUpdateUserTransaction";
    protected static final String INTERNAL_CONTEXT_ID = "InternalTransaction";
    protected static final String NTT_CONTEXT_ID = "NestedTransaction";
    protected DaemonService rawStoreDaemon;
    private UUIDFactory uuidFactory;
    protected ContextService contextFactory;
    protected LockFactory lockFactory;
    protected LogFactory logFactory;
    protected DataFactory dataFactory;
    protected DataValueFactory dataValueFactory;
    protected RawStoreFactory rawStoreFactory;
    public TransactionTable ttab;
    private final AtomicLong tranId = new AtomicLong();
    private LockingPolicy[][] lockingPolicies = new LockingPolicy[3][6];
    private boolean inCreateNoLog = false;
    private Object xa_resource;
    private Object backupSemaphore = new Object();
    private long backupBlockingOperations = 0L;
    private boolean inBackup = false;

    @Override
    public boolean canSupport(Properties startParams) {
        return true;
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        this.uuidFactory = XactFactory.getMonitor().getUUIDFactory();
        this.dataValueFactory = (DataValueFactory)XactFactory.bootServiceModule(create, this, "org.apache.derby.iapi.types.DataValueFactory", properties);
        this.contextFactory = XactFactory.getContextService();
        this.lockFactory = (LockFactory)XactFactory.bootServiceModule(false, this, "org.apache.derby.iapi.services.locks.LockFactory", properties);
        this.lockingPolicies[0][0] = new NoLocking();
        this.lockingPolicies[1][0] = new NoLocking();
        this.lockingPolicies[1][1] = new RowLocking1(this.lockFactory);
        this.lockingPolicies[1][2] = new RowLocking2(this.lockFactory);
        this.lockingPolicies[1][3] = new RowLocking2nohold(this.lockFactory);
        this.lockingPolicies[1][4] = new RowLockingRR(this.lockFactory);
        this.lockingPolicies[1][5] = new RowLocking3(this.lockFactory);
        this.lockingPolicies[2][0] = new NoLocking();
        this.lockingPolicies[2][1] = new ContainerLocking2(this.lockFactory);
        this.lockingPolicies[2][2] = new ContainerLocking2(this.lockFactory);
        this.lockingPolicies[2][3] = new ContainerLocking2(this.lockFactory);
        this.lockingPolicies[2][4] = new ContainerLocking3(this.lockFactory);
        this.lockingPolicies[2][5] = new ContainerLocking3(this.lockFactory);
        if (create) {
            this.ttab = new TransactionTable();
            String noLog = properties.getProperty("derby.__rt.storage.createWithNoLog");
            this.inCreateNoLog = noLog != null && Boolean.valueOf(noLog) != false;
        }
    }

    @Override
    public void stop() {
        if (this.rawStoreDaemon != null) {
            this.rawStoreDaemon.stop();
        }
    }

    @Override
    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    @Override
    public void createFinished() throws StandardException {
        if (!this.inCreateNoLog) {
            throw StandardException.newException("XSTB5.M", new Object[0]);
        }
        if (this.ttab.hasActiveUpdateTransaction()) {
            throw StandardException.newException("XSTB5.M", new Object[0]);
        }
        this.inCreateNoLog = false;
    }

    private Xact startCommonTransaction(RawStoreFactory rsf, Xact parentTransaction, ContextManager cm, boolean readOnly, CompatibilitySpace compatibilitySpace, String xact_context_id, String transName, boolean excludeMe, boolean flush_log_on_xact_end) throws StandardException {
        if (this.rawStoreFactory != null) {
            SanityManager.ASSERT(this.rawStoreFactory == rsf, "raw store factory different");
        }
        SanityManager.ASSERT(cm == this.contextFactory.getCurrentContextManager());
        Xact xact = new Xact(this, parentTransaction, this.logFactory, this.dataFactory, this.dataValueFactory, readOnly, compatibilitySpace, flush_log_on_xact_end);
        xact.setTransName(transName);
        this.pushTransactionContext(cm, xact_context_id, xact, false, rsf, excludeMe);
        return xact;
    }

    @Override
    public RawTransaction startTransaction(RawStoreFactory rsf, ContextManager cm, String transName) throws StandardException {
        return this.startCommonTransaction(rsf, null, cm, false, null, USER_CONTEXT_ID, transName, true, true);
    }

    @Override
    public RawTransaction startNestedReadOnlyUserTransaction(RawStoreFactory rsf, RawTransaction parentTransaction, CompatibilitySpace compatibilitySpace, ContextManager cm, String transName) throws StandardException {
        return this.startCommonTransaction(rsf, (Xact)parentTransaction, cm, true, compatibilitySpace, NESTED_READONLY_USER_CONTEXT_ID, transName, false, true);
    }

    @Override
    public RawTransaction startNestedUpdateUserTransaction(RawStoreFactory rsf, RawTransaction parentTransaction, ContextManager cm, String transName, boolean flush_log_on_xact_end) throws StandardException {
        return this.startCommonTransaction(rsf, (Xact)parentTransaction, cm, false, null, NESTED_UPDATE_USER_CONTEXT_ID, transName, true, flush_log_on_xact_end);
    }

    @Override
    public RawTransaction startGlobalTransaction(RawStoreFactory rsf, ContextManager cm, int format_id, byte[] global_id, byte[] branch_id) throws StandardException {
        GlobalXactId gid = new GlobalXactId(format_id, global_id, branch_id);
        if (this.ttab.findTransactionContextByGlobalId(gid) != null) {
            throw StandardException.newException("XSAX1.S", new Object[0]);
        }
        Xact xact = this.startCommonTransaction(rsf, null, cm, false, null, USER_CONTEXT_ID, USER_CONTEXT_ID, true, true);
        xact.setTransactionId(gid, xact.getId());
        return xact;
    }

    @Override
    public RawTransaction findUserTransaction(RawStoreFactory rsf, ContextManager contextMgr, String transName) throws StandardException {
        XactContext xc;
        SanityManager.ASSERT(contextMgr == this.contextFactory.getCurrentContextManager(), "passed in context mgr not the same as current context mgr");
        if (this.rawStoreFactory != null) {
            SanityManager.ASSERT(this.rawStoreFactory == rsf, "raw store factory different");
        }
        if ((xc = (XactContext)contextMgr.getContext(USER_CONTEXT_ID)) == null) {
            return this.startTransaction(rsf, contextMgr, transName);
        }
        return xc.getTransaction();
    }

    @Override
    public RawTransaction startNestedTopTransaction(RawStoreFactory rsf, ContextManager cm) throws StandardException {
        if (this.rawStoreFactory != null) {
            SanityManager.ASSERT(this.rawStoreFactory == rsf, "raw store factory different");
        }
        Xact xact = new Xact(this, null, this.logFactory, this.dataFactory, this.dataValueFactory, false, null, false);
        xact.setPostComplete();
        this.pushTransactionContext(cm, NTT_CONTEXT_ID, xact, true, rsf, true);
        return xact;
    }

    @Override
    public RawTransaction startInternalTransaction(RawStoreFactory rsf, ContextManager cm) throws StandardException {
        if (this.rawStoreFactory != null) {
            SanityManager.ASSERT(this.rawStoreFactory == rsf, "raw store factory different");
        }
        InternalXact xact = new InternalXact(this, this.logFactory, this.dataFactory, this.dataValueFactory);
        this.pushTransactionContext(cm, INTERNAL_CONTEXT_ID, xact, true, rsf, true);
        return xact;
    }

    @Override
    public boolean findTransaction(TransactionId id, RawTransaction tran) {
        return this.ttab.findAndAssumeTransaction(id, tran);
    }

    @Override
    public void rollbackAllTransactions(RawTransaction recoveryTransaction, RawStoreFactory rsf) throws StandardException {
        if (this.rawStoreFactory != null) {
            SanityManager.ASSERT(this.rawStoreFactory == rsf, "raw store factory different");
        }
        SanityManager.ASSERT(recoveryTransaction != null, "recovery transaction null");
        int irbcount = 0;
        if (this.ttab.hasRollbackFirstTransaction()) {
            RawTransaction internalTransaction = this.startInternalTransaction(rsf, recoveryTransaction.getContextManager());
            internalTransaction.recoveryTransaction();
            SanityManager.ASSERT(!internalTransaction.handlesPostTerminationWork(), "internal recovery xact handles post termination work");
            while (this.ttab.getMostRecentRollbackFirstTransaction(internalTransaction)) {
                ++irbcount;
                internalTransaction.abort();
            }
            internalTransaction.close();
        }
        SanityManager.ASSERT(!this.ttab.hasRollbackFirstTransaction(), "cant rollback user xacts with existing active internal xacts");
        int rbcount = 0;
        while (this.ttab.getMostRecentTransactionForRollback(recoveryTransaction)) {
            SanityManager.ASSERT(!recoveryTransaction.handlesPostTerminationWork(), "recovery transaction handles post termination work");
            ++rbcount;
            recoveryTransaction.abort();
        }
        if (rbcount > 0 || irbcount > 0) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePreparedXacts(RawStoreFactory rsf) throws StandardException {
        if (this.rawStoreFactory != null) {
            SanityManager.ASSERT(this.rawStoreFactory == rsf, "raw store factory different");
        }
        int prepared_count = 0;
        if (this.ttab.hasPreparedRecoveredXact()) {
            while (true) {
                ContextManager cm = this.contextFactory.newContextManager();
                this.contextFactory.setCurrentContextManager(cm);
                try {
                    RawTransaction rawtran = this.startTransaction(this.rawStoreFactory, cm, USER_CONTEXT_ID);
                    if (this.ttab.getMostRecentPreparedRecoveredXact(rawtran)) {
                        rawtran.reprepare();
                        ++prepared_count;
                        continue;
                    }
                    rawtran.destroy();
                }
                finally {
                    this.contextFactory.resetCurrentContextManager(cm);
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public LogInstant firstUpdateInstant() {
        return this.ttab.getFirstLogInstant();
    }

    @Override
    public StandardException markCorrupt(StandardException originalError) {
        this.logFactory.markCorrupt(originalError);
        return originalError;
    }

    public void setNewTransactionId(TransactionId oldxid, Xact t) {
        boolean excludeMe = true;
        if (oldxid != null) {
            excludeMe = this.remove(oldxid);
        }
        XactId xid = new XactId(this.tranId.getAndIncrement());
        t.setTransactionId(t.getGlobalId(), (TransactionId)xid);
        if (oldxid != null) {
            this.add(t, excludeMe);
        }
    }

    @Override
    public void resetTranId() {
        XactId xid = (XactId)this.ttab.largestUpdateXactId();
        long highestId = xid == null ? 0L : xid.getId();
        this.tranId.set(highestId + 1L);
    }

    protected void pushTransactionContext(ContextManager cm, String contextName, Xact xact, boolean abortAll, RawStoreFactory rsf, boolean excludeMe) throws StandardException {
        if (cm.getContext(contextName) != null) {
            throw StandardException.newException("XSTA2.S", new Object[0]);
        }
        XactContext xc = new XactContext(cm, contextName, xact, abortAll, rsf);
        this.add(xact, excludeMe);
    }

    protected void addUpdateTransaction(TransactionId id, RawTransaction t, int transactionStatus) {
        SanityManager.ASSERT(id != null, "addding update transaction with null id");
        this.ttab.addUpdateTransaction(id, t, transactionStatus);
    }

    protected void removeUpdateTransaction(TransactionId id) {
        SanityManager.ASSERT(id != null, "remove update transaction with null id");
        this.ttab.removeUpdateTransaction(id);
    }

    protected void prepareTransaction(TransactionId id) {
        SanityManager.ASSERT(id != null, "prepare transaction with null id");
        this.ttab.prepareTransaction(id);
    }

    @Override
    public boolean submitPostCommitWork(Serviceable work) {
        if (this.rawStoreDaemon != null) {
            return this.rawStoreDaemon.enqueue(work, work.serviceASAP());
        }
        return false;
    }

    @Override
    public void setRawStoreFactory(RawStoreFactory rsf) throws StandardException {
        SanityManager.ASSERT(rsf != null, "rawStoreFactory == null");
        this.rawStoreFactory = rsf;
        this.rawStoreDaemon = rsf.getDaemon();
        this.logFactory = (LogFactory)XactFactory.findServiceModule(this, rsf.getLogFactoryModule());
        this.dataFactory = (DataFactory)XactFactory.findServiceModule(this, rsf.getDataFactoryModule());
    }

    @Override
    public boolean noActiveUpdateTransaction() {
        return !this.ttab.hasActiveUpdateTransaction();
    }

    @Override
    public boolean hasPreparedXact() {
        return this.ttab.hasPreparedXact();
    }

    protected boolean remove(TransactionId xactId) {
        return this.ttab.remove(xactId);
    }

    protected void add(Xact xact, boolean excludeMe) {
        this.ttab.add(xact, excludeMe);
    }

    public UUID makeNewUUID() {
        return this.uuidFactory.createUUID();
    }

    final LockingPolicy getLockingPolicy(int mode, int isolation, boolean stricterOk) {
        LockingPolicy policy;
        if (mode == 0) {
            isolation = 0;
        }
        if ((policy = this.lockingPolicies[mode][isolation]) != null || !stricterOk) {
            return policy;
        }
        ++mode;
        while (mode <= 2) {
            for (int i = isolation; i <= 5; ++i) {
                policy = this.lockingPolicies[mode][i];
                if (policy == null) continue;
                return policy;
            }
            ++mode;
        }
        return null;
    }

    @Override
    public Formatable getTransactionTable() {
        return this.ttab;
    }

    @Override
    public void useTransactionTable(Formatable transactionTable) throws StandardException {
        if (this.ttab != null && transactionTable != null) {
            throw StandardException.newException("XSTB6.M", new Object[0]);
        }
        if (this.ttab == null) {
            if (transactionTable == null) {
                this.ttab = new TransactionTable();
            } else {
                if (!(transactionTable instanceof TransactionTable)) {
                    SanityManager.THROWASSERT("using transaction table which is of class " + transactionTable.getClass().getName());
                }
                this.ttab = (TransactionTable)transactionTable;
            }
        }
    }

    @Override
    public TransactionInfo[] getTransactionInfo() {
        SanityManager.ASSERT(this.ttab != null, "transaction table is null");
        return this.ttab.getTransactionInfo();
    }

    public boolean inDatabaseCreation() {
        return this.inCreateNoLog;
    }

    @Override
    public Object getXAResourceManager() throws StandardException {
        if (this.xa_resource == null) {
            this.xa_resource = new XactXAResourceManager(this.rawStoreFactory, this.ttab);
        }
        return this.xa_resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean blockBackup(boolean wait) {
        Object object = this.backupSemaphore;
        synchronized (object) {
            if (this.inBackup) {
                if (wait) {
                    while (this.inBackup) {
                        try {
                            this.backupSemaphore.wait();
                        }
                        catch (InterruptedException ie) {
                            InterruptStatus.setInterrupted();
                        }
                    }
                } else {
                    return false;
                }
            }
            ++this.backupBlockingOperations;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unblockBackup() {
        Object object = this.backupSemaphore;
        synchronized (object) {
            SanityManager.ASSERT(this.backupBlockingOperations > 0L, "no backup blocking opeations in progress");
            --this.backupBlockingOperations;
            if (this.inBackup) {
                this.backupSemaphore.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean blockBackupBlockingOperations(boolean wait) {
        Object object = this.backupSemaphore;
        synchronized (object) {
            if (wait) {
                this.inBackup = true;
                try {
                    while (this.backupBlockingOperations > 0L) {
                        try {
                            this.backupSemaphore.wait();
                        }
                        catch (InterruptedException ie) {
                            InterruptStatus.setInterrupted();
                        }
                    }
                }
                catch (RuntimeException rte) {
                    this.inBackup = false;
                    this.backupSemaphore.notifyAll();
                    throw rte;
                }
            } else if (this.backupBlockingOperations == 0L) {
                this.inBackup = true;
            }
        }
        if (this.inBackup) {
            SanityManager.ASSERT(this.backupBlockingOperations == 0L, "store is not in correct state for backup");
        }
        return this.inBackup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unblockBackupBlockingOperations() {
        Object object = this.backupSemaphore;
        synchronized (object) {
            this.inBackup = false;
            this.backupSemaphore.notifyAll();
        }
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static Object bootServiceModule(final boolean create, final Object serviceModule, final String factoryInterface, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.bootServiceModule(create, serviceModule, factoryInterface, properties);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }

    private static Object findServiceModule(final Object serviceModule, final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(serviceModule, factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }
}

