/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.StringTokenizer;
import junit.framework.Assert;
import org.apache.derby.tools.sysinfo;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;

public class Utilities {
    public static final String NL = BaseTestCase.getSystemProperty("line.separator");

    private Utilities() {
    }

    public static String stringToHexLiteral(String string) {
        String string2 = null;
        try {
            byte[] byArray = string.getBytes("UTF-16BE");
            string2 = Utilities.convertToHexString(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.fail((String)("Encoding UTF-16BE unavailable: " + unsupportedEncodingException.getMessage()));
        }
        return string2;
    }

    private static String convertToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X'");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString() + "'";
    }

    public static String repeatChar(String string, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, string.charAt(0));
        return String.valueOf(cArray);
    }

    public static void showResultSet(ResultSet resultSet) throws SQLException {
        System.out.print("{");
        int n = 0;
        boolean bl = resultSet.next();
        while (bl) {
            ++n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            System.out.print("{");
            for (int i = 0; i < n2; ++i) {
                String string = resultSet.getString(i + 1);
                if (string == null) {
                    System.out.print("null");
                } else {
                    System.out.print("\"" + resultSet.getString(i + 1) + "\"");
                }
                if (i == n2 - 1) {
                    System.out.print("}");
                    continue;
                }
                System.out.print(",");
            }
            bl = resultSet.next();
            if (!bl) continue;
            System.out.println(",");
        }
        System.out.println("};\n");
    }

    public static BufferedReader getSysinfoLocally() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(20480);
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        sysinfo.getInfo((PrintWriter)printWriter);
        printWriter.flush();
        printWriter.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
        return bufferedReader;
    }

    public static BufferedReader getSysinfoFromServer() throws Exception {
        return new BufferedReader(new StringReader(NetworkServerTestSetup.getNetworkServerControl().getSysinfo()));
    }

    public static String[] split(String string, char c) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(c));
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static void sleep(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        while (l3 < l) {
            try {
                Thread.sleep(l - l3);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            l3 = System.currentTimeMillis() - l2;
        }
    }

    public static String formatTestClassNames(String string) {
        if (string.startsWith("org.apache.derbyTesting.functionTests.tests.")) {
            return string.substring("org.apache.derbyTesting.functionTests.tests.".length());
        }
        if (string.startsWith("org.apache.derbyTesting.")) {
            return string.substring("org.apache.derbyTesting.".length());
        }
        return string;
    }
}

