/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.harness.BackgroundStreamDrainer;
import org.apache.derbyTesting.functionTests.harness.CurrentTime;
import org.apache.derbyTesting.functionTests.harness.HandleResult;
import org.apache.derbyTesting.functionTests.harness.JavaVersionHolder;
import org.apache.derbyTesting.functionTests.harness.ManageSysProps;
import org.apache.derbyTesting.functionTests.harness.RunTest;
import org.apache.derbyTesting.functionTests.harness.SpecialFlags;
import org.apache.derbyTesting.functionTests.harness.UnJar;
import org.apache.derbyTesting.functionTests.harness.jvm;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class RunList {
    public static final String SPEC_VERSION = "java.specification.version";
    static String jvmName = "currentjvm";
    static String javaCmd = "java";
    static String javaArgs;
    static jvm jvm;
    static String javaVersion;
    static String majorVersion;
    static String minorVersion;
    static String jversion;
    static int iminor;
    static int imajor;
    static boolean skip;
    static boolean driverNotFound;
    static boolean needSync;
    static boolean needJdk12;
    static boolean needJdk12ext;
    static boolean excludedFromJCC;
    static String clientExclusionMessage;
    static Boolean needIBMjvm;
    static boolean needEncryption;
    static String jvmflags;
    static String testJavaFlags;
    static String classpath;
    static String classpathServer;
    static String framework;
    static String usesystem;
    static String upgradetest;
    static String jarfile;
    static String useoutput;
    static String keepfiles;
    static String encryption;
    static String testEncryptionProvider;
    static String testEncryptionAlgorithm;
    static String jdk12test;
    static String jdk12exttest;
    static String runwithibmjvm;
    static String runwithj9;
    static String runwithjvm;
    static String excludeJCC;
    static boolean useprocess;
    static String skipsed;
    static boolean fw_set;
    static String systemdiff;
    static String suiteName;
    static String fullsuiteName;
    static String topSuiteName;
    static String topParentSuite;
    static String topSpecialProps;
    static String otherSpecialProps;
    static String ijdefaultResourcePackage;
    static String outcopy;
    static String userdir;
    static String mtestdir;
    static boolean verbose;
    static String reportstderr;
    static String timeout;
    static String shutdownurl;
    static PrintWriter pwOut;
    static String outputdir;
    static String topsuitedir;
    static String topreportdir;
    static String canondir;
    static String bootcp;
    static String serverJvm;
    static String serverJvmName;
    static File outDir;
    static File outFile;
    static File runDir;
    static File runFile;
    static Properties suiteProperties;
    static Properties specialProperties;
    static BufferedReader runlistFile;
    static String hostName;
    static String testEncoding;
    static String upgradejarpath;
    static String derbyTestingXaSingle;
    static String[] clientExclusionKeywords;

    public RunList() {
    }

    public RunList(Vector vector, File file, File file2, PrintWriter printWriter, Properties properties, Properties properties2, String string) throws ClassNotFoundException, IOException, Exception {
        runDir = file;
        outDir = file2;
        pwOut = printWriter;
        suiteProperties = properties;
        specialProperties = properties2;
        topSuiteName = properties.getProperty("suitename");
        topParentSuite = string;
        RunList.runSuites(vector);
    }

    private static void runSuites(Vector vector) throws ClassNotFoundException, FileNotFoundException, IOException, Exception {
        String string = "";
        userdir = System.getProperty("user.dir");
        Properties properties = null;
        RunList.setTopSuiteProperties();
        Properties properties2 = RunList.locateSuiteProperties(topParentSuite, suiteProperties, true, true);
        RunList.setSuiteProperties(properties2, topParentSuite, suiteProperties, true, true);
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Object object2;
            Properties properties3 = null;
            fullsuiteName = (String)vector.elementAt(i);
            String string2 = fullsuiteName.substring(0, fullsuiteName.lastIndexOf(":"));
            properties3 = !string2.equals(topParentSuite) ? RunList.locateSuiteProperties(string2, properties2, true, false) : properties2;
            RunList.setSuiteProperties(properties3, string2, properties2, true, false);
            string = fullsuiteName.substring(fullsuiteName.lastIndexOf(":") + 1);
            properties = RunList.locateSuiteProperties(string, properties3, false, false);
            RunList.setSuiteProperties(properties, string, properties3, false, false);
            String string3 = "suites/" + string + ".runall";
            InputStream inputStream = RunTest.loadTestResource(string3);
            if (inputStream == null) {
                inputStream = RunTest.loadTestResource(userdir + "/" + string + ".runall");
            }
            if (inputStream == null) {
                System.out.println("Suite runall file not found for " + string);
                continue;
            }
            runlistFile = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            if (runlistFile == null) {
                System.out.println("The suite runall file could not be read.");
                continue;
            }
            String string4 = CurrentTime.getTime();
            pwOut.println("**** Start SubSuite: " + fullsuiteName + " jdk" + javaVersion + " " + string4 + " ****");
            if (framework != null && framework.length() > 0) {
                pwOut.println("Framework: " + framework);
            } else {
                pwOut.println("Framework: No special framework.");
            }
            File file = new File(outDir, topSuiteName);
            File file2 = new File(file, topSuiteName + ".skip");
            PrintStream printStream = null;
            try {
                printStream = new PrintStream(new FileOutputStream(file2.getCanonicalPath(), true));
            }
            catch (IOException iOException) {
                object2 = new FileWriter(file2);
                ((OutputStreamWriter)object2).close();
                printStream = new PrintStream(new FileOutputStream(file2.getCanonicalPath(), true));
            }
            if (!useprocess) {
                RunList.unloadEmbeddedDriver();
            }
            System.out.println("Now run the suite's tests");
            if (skip) {
                RunList.addToSkipFile(topSuiteName + ":" + fullsuiteName, printStream);
                if (driverNotFound) {
                    pwOut.println("Cannot run the suite, framework driver not found");
                } else if (needSync) {
                    pwOut.println("Cannot run the suite, sync product not found");
                } else if (needJdk12ext) {
                    pwOut.println("Cannot run the suite, requires jdk12 or higher with extensions");
                } else if (needJdk12) {
                    pwOut.println("Cannot run the suite, requires jdk12 or higher, have jdk" + javaVersion);
                } else if (excludedFromJCC) {
                    pwOut.println(clientExclusionMessage);
                } else if (needIBMjvm == null || !needIBMjvm.booleanValue()) {
                    pwOut.println("Cannot run the suite, requires IBM jvm, jvm vendor is " + System.getProperty("java.vendor"));
                } else {
                    pwOut.println("Cannot run the suite, have jdk" + javaVersion);
                }
            } else {
                System.out.println("Run the tests...");
                if (jarfile != null) {
                    object = new UnJar();
                    UnJar.unjar(jarfile, outDir.getCanonicalPath(), true);
                    if (upgradetest.equals("true") && string.startsWith("convert")) {
                        object2 = jarfile.substring(0, jarfile.indexOf("JAR"));
                        File file3 = new File(outDir, (String)object2);
                        File file4 = new File(outDir, usesystem);
                        boolean bl = file3.renameTo(file4);
                    }
                }
                RunList.runTests(properties, fullsuiteName);
            }
            object = CurrentTime.getTime();
            pwOut.println("**** End SubSuite: " + fullsuiteName + " jdk" + javaVersion + " " + (String)object + " ****");
            printStream.close();
        }
    }

    private static void runTests(Properties properties, String string) throws IOException, Exception {
        Object object;
        String[] stringArray;
        String string2;
        boolean bl = JVMInfo.isModuleAware();
        ManageSysProps.saveSysProps();
        StringBuffer stringBuffer = new StringBuffer();
        jvm = org.apache.derbyTesting.functionTests.harness.jvm.getJvm(jvmName);
        Vector<String> vector = new Vector<String>();
        if (javaCmd.length() > 0) {
            jvm.setJavaCmd(javaCmd);
            vector.addElement("javaCmd=" + javaCmd);
        }
        if (testJavaFlags != null && testJavaFlags.length() > 0) {
            vector.addElement("testJavaFlags=" + testJavaFlags);
        }
        if (classpath != null && !bl) {
            vector.addElement("classpath=" + classpath);
        }
        if (classpathServer != null) {
            vector.addElement("classpathServer=" + classpathServer);
        }
        if (jversion != null) {
            vector.addElement("jvm=" + jversion);
        }
        if (framework != null) {
            vector.addElement("framework=" + framework);
        }
        if (usesystem != null) {
            vector.addElement("usesystem=" + usesystem);
        }
        if (shutdownurl != null) {
            vector.addElement("shutdownurl=" + shutdownurl);
        }
        if (upgradetest != null) {
            vector.addElement("upgradetest=" + upgradetest);
        }
        if (outcopy != null) {
            vector.addElement("outcopy=" + outcopy);
        }
        if (useoutput != null) {
            vector.addElement("useoutput=" + useoutput);
        }
        if (verbose) {
            vector.addElement("verbose=true");
        }
        if (reportstderr != null && reportstderr.length() > 0) {
            vector.addElement("reportstderr=" + reportstderr);
        }
        if (jvmflags != null && jvmflags.length() > 0) {
            vector.addElement("jvmflags=" + jvmflags);
        }
        if (timeout != null && timeout.length() > 0) {
            if (useprocess) {
                vector.addElement("timeout=" + timeout);
            } else {
                RunTest.timeoutStr = timeout;
            }
        }
        if (Boolean.getBoolean("listOnly")) {
            vector.addElement("listOnly=true");
        }
        if (encryption != null) {
            vector.addElement("encryption=" + encryption);
        }
        if (testEncryptionProvider != null) {
            vector.addElement("testEncryptionProvider=" + testEncryptionProvider);
        }
        if (testEncryptionAlgorithm != null) {
            vector.addElement("testEncryptionAlgorithm=" + testEncryptionAlgorithm);
        }
        if (jdk12test != null) {
            vector.addElement("jdk12test=" + jdk12test);
        }
        if (jdk12exttest != null) {
            vector.addElement("jdk12exttest=" + jdk12exttest);
        }
        if (keepfiles != null) {
            vector.addElement("keepfiles=" + keepfiles);
        }
        if (outputdir != null && outputdir.length() > 0) {
            vector.addElement("outputdir=" + outputdir);
        }
        if (topsuitedir != null && topsuitedir.length() > 0) {
            vector.addElement("topsuitedir=" + topsuitedir);
        } else {
            vector.addElement("topsuitedir=" + outputdir);
        }
        if (topreportdir != null) {
            vector.addElement("topreportdir=" + topreportdir);
        } else {
            vector.addElement("topreprtdir=" + topsuitedir);
        }
        if (runDir != null && runDir.exists()) {
            vector.addElement("rundir=" + runDir.getCanonicalPath());
        }
        if (bootcp != null && bootcp.length() > 0) {
            vector.addElement("bootcp=" + bootcp);
        }
        if (serverJvm != null && serverJvm.length() > 0) {
            vector.addElement("serverJvm=" + serverJvm);
        }
        if (serverJvmName != null && serverJvmName.length() > 0) {
            vector.addElement("serverJvmName=" + serverJvmName);
        }
        if (testEncoding != null) {
            vector.addElement("derbyTesting.encoding=" + testEncoding);
        }
        if (upgradejarpath != null) {
            vector.addElement("derbyTesting.jar.path=" + upgradejarpath);
        }
        if (hostName != null && hostName.length() > 0) {
            vector.addElement("hostName=" + hostName);
        }
        if (!useprocess) {
            vector.addElement("useprocess=false");
        }
        if (skipsed.equals("true")) {
            vector.addElement("skipsed=true");
        }
        if (systemdiff != null) {
            vector.addElement("systemdiff=" + systemdiff);
        }
        if (ijdefaultResourcePackage != null) {
            vector.addElement("ij.defaultResourcePackage=" + ijdefaultResourcePackage);
        }
        if (mtestdir != null) {
            vector.addElement("mtestdir=" + mtestdir);
        }
        if (topSpecialProps.length() > 0) {
            vector.addElement("testSpecialProps=" + topSpecialProps + (String)(otherSpecialProps.length() > 0 ? "^" + otherSpecialProps : ""));
        } else if (otherSpecialProps.length() > 0) {
            vector.addElement("testSpecialProps=" + otherSpecialProps);
        }
        if (derbyTestingXaSingle != null) {
            vector.addElement("derbyTesting.xa.single=" + derbyTestingXaSingle);
        }
        Properties properties2 = System.getProperties();
        Object object2 = properties2.keys();
        while (object2.hasMoreElements()) {
            string2 = (String)object2.nextElement();
            if (!string2.startsWith("ij.dataSource")) continue;
            vector.addElement(string2 + "=" + properties2.getProperty(string2));
        }
        vector.addElement("suitename=" + string);
        if (topSuiteName != null && topSuiteName.length() > 0) {
            vector.addElement("topsuitename=" + topSuiteName);
        }
        if (classpath != null) {
            jvm.setClasspath(classpath);
        }
        jvm.setD(vector);
        object2 = jvm.getCommandLine();
        string2 = "org.apache.derbyTesting.functionTests.harness.RunTest";
        if (bl) {
            ((Vector)object2).addElement("--add-modules");
            ((Vector)object2).addElement("org.apache.derby.tests,junit");
            ((Vector)object2).add("-m");
            ((Vector)object2).add("org.apache.derby.tests/" + string2);
        } else {
            ((Vector)object2).addElement(string2);
        }
        String string3 = "";
        String string4 = null;
        String string5 = System.getProperties().getProperty("skipToFile");
        String string6 = System.getProperties().getProperty("stopAfterFile");
        while ((string3 = runlistFile.readLine()) != null) {
            block62: {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                if (string5 != null && !string3.equals(string5)) continue;
                string5 = null;
                if (string6 != null && string4 != null && string4.equals(string6)) break;
                stringArray = new String[((Vector)object2).size() + 1];
                object = new StringBuffer();
                int n = 0;
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    stringArray[n] = (String)((Vector)object2).elementAt(n);
                    ((StringBuffer)object).append(stringArray[n] + " ");
                }
                stringArray[n++] = string3;
                ((StringBuffer)object).append(string3 + " ");
                String string7 = System.getProperties().getProperty("useCommonDB");
                if (string7 == null) {
                    string7 = "false";
                }
                if (useprocess && !string7.equals("true")) {
                    System.out.println("Execute command: " + ((StringBuffer)object).toString());
                    object6 = null;
                    try {
                        object6 = Runtime.getRuntime().exec(stringArray);
                        object5 = new BackgroundStreamDrainer(((Process)object6).getInputStream(), null);
                        object4 = new BackgroundStreamDrainer(((Process)object6).getErrorStream(), null);
                        ((Process)object6).waitFor();
                        object3 = HandleResult.handleResult(((Process)object6).exitValue(), ((BackgroundStreamDrainer)object5).getData(), ((BackgroundStreamDrainer)object4).getData(), pwOut, testEncoding);
                        ((Process)object6).destroy();
                    }
                    catch (Throwable throwable) {
                        System.out.println("Process exception: " + throwable.getMessage());
                        if (object6 == null) break block62;
                        ((Process)object6).destroy();
                        object6 = null;
                    }
                } else {
                    object6 = new String[]{string3, ijdefaultResourcePackage != null ? ijdefaultResourcePackage : "/org/apache/derbyTesting/functionTests/", usesystem != null ? usesystem : "", "noprocess", shutdownurl != null ? shutdownurl : "", string, framework};
                    RunTest.main((String[])object6);
                    object5 = string3.substring(string3.indexOf("/") + 1, string3.lastIndexOf("."));
                    object4 = (String)object5 + ".diff";
                    object3 = new File(outDir, (String)object4);
                    if (object3 != null && ((File)object3).exists()) {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader((File)object3));
                        String string8 = "";
                        while ((string8 = bufferedReader.readLine()) != null) {
                            pwOut.println(string8);
                        }
                    }
                }
            }
            ManageSysProps.resetSysProps();
            string4 = string3;
        }
        if (!useprocess && framework != null && framework.startsWith("DerbyNet")) {
            try {
                stringArray = javaCmd + " org.apache.derby.drda.NetworkServerControl shutdown";
                object = Runtime.getRuntime().exec((String)stringArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Properties locateSuiteProperties(String string, Properties properties, boolean bl, boolean bl2) throws ClassNotFoundException, IOException, Exception {
        String string2 = "suites/" + string + ".properties";
        InputStream inputStream = RunTest.loadTestResource(string2);
        if (inputStream == null) {
            string2 = userdir + "/" + string + ".properties";
            inputStream = RunTest.loadTestResource(string2);
        }
        Properties properties2 = new Properties();
        if (bl) {
            usesystem = null;
            upgradetest = null;
            jarfile = null;
            outcopy = null;
            useoutput = null;
            mtestdir = null;
            skipsed = "false";
        }
        if (inputStream != null) {
            properties2.load(inputStream);
            inputStream = null;
        } else {
            testEncoding = properties.getProperty("derbyTesting.encoding");
            upgradejarpath = properties.getProperty("derbyTesting.jar.path");
            framework = properties.getProperty("framework");
            serverJvm = properties.getProperty("serverJvm");
            serverJvmName = properties.getProperty("serverJvmName");
            ijdefaultResourcePackage = properties.getProperty("ij.defaultResourcePackage");
            encryption = properties.getProperty("encryption");
            testEncryptionProvider = properties.getProperty("testEncryptionProvider");
            testEncryptionAlgorithm = properties.getProperty("testEncryptionAlgorithm");
            jdk12test = properties.getProperty("jdk12test");
            jdk12exttest = properties.getProperty("jdk12exttest");
            runwithj9 = properties.getProperty("runwithj9");
            runwithibmjvm = properties.getProperty("runwithibmjvm");
            String string3 = jvmName;
            if (jvmName.startsWith("j9") && !jvmName.startsWith("j9dee")) {
                string3 = jvmName.startsWith("j9_foundation") ? "foundation" : "j9";
            }
            runwithjvm = properties.getProperty("runwith" + string3);
            excludeJCC = properties.getProperty("excludeJCC");
        }
        return properties2;
    }

    private static void setTopSuiteProperties() throws ClassNotFoundException, IOException {
        framework = suiteProperties.getProperty("framework");
        jversion = suiteProperties.getProperty("jversion");
        jvmName = suiteProperties.getProperty("jvm");
        String string = System.getProperty("com.ibm.oti.configuration");
        if (string != null) {
            if (string.equals("foun10")) {
                jvmName = "j9_foundation";
            } else if (string.equals("foun11")) {
                jvmName = "j9_foundation11";
            } else if (string.equals("max")) {
                jvmName = "j9_13";
            } else if (string.equals("dee")) {
                jvmName = "j9dee15";
            }
        }
        javaVersion = System.getProperty(SPEC_VERSION);
        javaCmd = suiteProperties.getProperty("javaCmd");
        if (javaCmd == null) {
            javaCmd = "java";
        } else if (javaCmd.equals("jview")) {
            jvmName = "jview";
        }
        String string2 = javaVersion;
        JavaVersionHolder javaVersionHolder = new JavaVersionHolder(string2);
        majorVersion = javaVersionHolder.getMajorVersion();
        minorVersion = javaVersionHolder.getMinorVersion();
        iminor = javaVersionHolder.getMinorNumber();
        imajor = javaVersionHolder.getMajorNumber();
        if (jvmName == null || jvmName.equals("jview")) {
            jvmName = iminor < 2 && imajor < 2 ? "currentjvm" : "jdk" + majorVersion + minorVersion;
        }
        if (jvmName.equals("j9_13")) {
            javaVersion = javaVersion + " - " + majorVersion + "." + minorVersion;
            System.out.println("javaVersion now: " + javaVersion);
            if (imajor <= 2 && iminor < 2) {
                majorVersion = "1";
                minorVersion = "3";
                imajor = 1;
                iminor = 3;
            } else {
                jvmName = "j9_" + majorVersion + minorVersion;
            }
        }
        jvmflags = suiteProperties.getProperty("jvmflags");
        testJavaFlags = suiteProperties.getProperty("testJavaFlags");
        classpath = suiteProperties.getProperty("classpath");
        classpathServer = suiteProperties.getProperty("classpathServer");
        usesystem = suiteProperties.getProperty("usesystem");
        upgradetest = suiteProperties.getProperty("upgradetest");
        outcopy = suiteProperties.getProperty("outcopy");
        useoutput = suiteProperties.getProperty("useoutput");
        encryption = suiteProperties.getProperty("encryption");
        testEncryptionProvider = suiteProperties.getProperty("testEncryptionProvider");
        testEncryptionAlgorithm = suiteProperties.getProperty("testEncryptionAlgorithm");
        jdk12test = suiteProperties.getProperty("jdk12test");
        jdk12exttest = suiteProperties.getProperty("jdk12exttest");
        runwithibmjvm = suiteProperties.getProperty("runwithibmjvm");
        runwithj9 = suiteProperties.getProperty("runwithj9");
        derbyTestingXaSingle = suiteProperties.getProperty("derbyTesting.xa.single");
        String string3 = jvmName;
        if (jvmName.startsWith("j9") && !jvmName.startsWith("j9dee")) {
            string3 = jvmName.startsWith("j9_foundation") ? "foundation" : "j9";
        }
        runwithjvm = suiteProperties.getProperty("runwith" + string3);
        excludeJCC = suiteProperties.getProperty("excludeJCC");
        keepfiles = suiteProperties.getProperty("keepfiles");
        systemdiff = suiteProperties.getProperty("systemdiff");
        outputdir = suiteProperties.getProperty("outputdir");
        if (outputdir == null) {
            outputdir = userdir;
        }
        if ((topsuitedir = suiteProperties.getProperty("topsuitedir")) == null) {
            topsuitedir = outputdir;
        }
        bootcp = suiteProperties.getProperty("bootcp");
        serverJvm = suiteProperties.getProperty("serverJvm");
        serverJvmName = suiteProperties.getProperty("serverJvmName");
        hostName = suiteProperties.getProperty("hostName");
        testEncoding = suiteProperties.getProperty("derbyTesting.encoding");
        upgradejarpath = suiteProperties.getProperty("derbyTesting.jar.path");
        canondir = suiteProperties.getProperty("canondir");
        mtestdir = suiteProperties.getProperty("mtestdir");
        String string4 = suiteProperties.getProperty("useprocess");
        if (string4 != null && string4.equals("false")) {
            useprocess = false;
        }
        skipsed = suiteProperties.getProperty("skipsed");
        String string5 = suiteProperties.getProperty("verbose");
        if (string5 != null && string5.equals("true")) {
            verbose = true;
        }
        reportstderr = suiteProperties.getProperty("reportstderr");
        timeout = suiteProperties.getProperty("timeout");
        shutdownurl = suiteProperties.getProperty("shutdownurl");
        topSuiteName = suiteProperties.getProperty("suitename");
        ijdefaultResourcePackage = suiteProperties.getProperty("ij.defaultResourcePackage");
        if (specialProperties != null && !specialProperties.isEmpty()) {
            RunList.setSpecialProps(specialProperties, true);
        }
    }

    private static void setSuiteProperties(Properties properties, String string, Properties properties2, boolean bl, boolean bl2) throws ClassNotFoundException, IOException {
        if (jversion != null) {
            properties.put("jvm", jversion);
        }
        if (jvmName == null) {
            jvmName = "currentjvm";
        } else {
            properties.put("jvm", jvmName);
        }
        if (javaCmd == null) {
            javaCmd = "java";
        } else {
            properties.put("javaCmd", javaCmd);
        }
        Object object = jvmflags;
        String string2 = properties.getProperty("jvmflags");
        String string3 = properties2.getProperty("jvmflags");
        if (string2 != null && string3 != null && !string2.equals(string3) && string2 != null && string2.length() > 0) {
            object = string2 + "^" + (String)object;
        }
        if (object != null) {
            jvmflags = object;
        }
        if (classpath != null) {
            properties.put("classpath", classpath);
        }
        if (classpathServer != null) {
            properties.put("classpathServer", classpathServer);
        }
        if (systemdiff != null) {
            properties.put("systemdiff", systemdiff);
        }
        if (verbose) {
            properties.put("verbose", "true");
        }
        if (bootcp != null) {
            properties.put("bootcp", "bootcp");
        }
        if (canondir != null) {
            properties.put("canondir", canondir);
        }
        if ((outputdir == null || outputdir.length() == 0) && (outputdir = properties.getProperty("outputdir")) == null) {
            outputdir = userdir;
        }
        if (properties2.getProperty("framework") != null) {
            properties.put("framework", framework);
        } else {
            framework = properties.getProperty("framework");
        }
        if (properties2.getProperty("serverJvm") != null) {
            properties.put("serverJvm", serverJvm);
        } else {
            serverJvm = properties.getProperty("serverJvm");
        }
        if (properties2.getProperty("serverJvmName") != null) {
            properties.put("serverJvmName", serverJvmName);
        } else {
            serverJvmName = properties.getProperty("serverJvmName");
        }
        if (properties2.getProperty("derbyTesting.encoding") != null) {
            properties.put("derbyTesting.encoding", testEncoding);
        } else {
            testEncoding = properties.getProperty("derbyTesting.encoding");
        }
        if (properties2.getProperty("derbyTesting.jar.path") != null) {
            properties.put("derbyTesting.jar.path", upgradejarpath);
        } else {
            upgradejarpath = properties.getProperty("derbyTesting.jar.path");
        }
        if (hostName != null) {
            properties.put("hostName", hostName);
        } else {
            properties.put("hostName", "localhost");
        }
        if (properties2.getProperty("encryption") != null) {
            properties.put("encryption", encryption);
        } else {
            encryption = properties.getProperty("encryption");
        }
        if (properties2.getProperty("testEncryptionProvider") != null) {
            properties.put("testEncryptionProvider", testEncryptionProvider);
        } else {
            testEncryptionProvider = properties.getProperty("testEncryptionProvider");
        }
        if (properties2.getProperty("testEncryptionAlgorithm") != null) {
            properties.put("testEncryptionAlgorithm", testEncryptionAlgorithm);
        } else {
            testEncryptionAlgorithm = properties.getProperty("testEncryptionAlgorithm");
        }
        if (properties2.getProperty("jdk12test") != null) {
            properties.put("jdk12test", jdk12test);
        } else {
            jdk12test = properties.getProperty("jdk12test");
        }
        if (properties2.getProperty("jdk12exttest") != null) {
            properties.put("jdk12exttest", jdk12exttest);
        } else {
            jdk12exttest = properties.getProperty("jdk12exttest");
        }
        if (properties2.getProperty("runwithibmjvm") != null) {
            properties.put("runwithibmjvm", runwithibmjvm);
        } else {
            runwithibmjvm = properties.getProperty("runwithibmjvm");
        }
        String string4 = jvmName;
        if (jvmName.startsWith("j9") && !jvmName.startsWith("j9dee")) {
            String string5 = string4 = jvmName.startsWith("j9_foundation") ? "foundation" : "j9";
        }
        if (properties2.getProperty("runwith" + string4) != null) {
            properties.put("runwith" + string4, runwithjvm);
        } else {
            runwithjvm = properties.getProperty("runwith" + string4);
        }
        if (properties2.getProperty("runwithj9") != null) {
            properties.put("runwithj9", runwithj9);
        } else {
            runwithj9 = properties.getProperty("runwithj9");
        }
        if (properties2.getProperty("excludeJCC") != null) {
            properties.put("excludeJCC", excludeJCC);
        } else {
            excludeJCC = properties.getProperty("excludeJCC");
        }
        String string6 = properties2.getProperty("useprocess");
        if (string6 != null) {
            properties.put("useprocess", string6);
        } else {
            string6 = properties.getProperty("useprocess");
            useprocess = string6 == null ? true : !string6.equals("false");
        }
        usesystem = properties.getProperty("usesystem");
        shutdownurl = properties.getProperty("shutdownurl");
        upgradetest = properties.getProperty("upgradetest");
        jarfile = properties.getProperty("jarfile");
        skipsed = properties.getProperty("skipsed");
        if (skipsed == null) {
            skipsed = "false";
        }
        if ("true".equals(keepfiles)) {
            properties.put("keepfiles", keepfiles);
        }
        String string7 = properties.getProperty("testJavaFlags");
        if (properties2.getProperty("testJavaFlags") != null) {
            if (string7 != null && !string7.equals(testJavaFlags)) {
                testJavaFlags = testJavaFlags + "^" + string7;
            }
            properties.put("testJavaFlags", testJavaFlags);
        } else {
            testJavaFlags = properties.getProperty("testJavaFlags");
        }
        if (properties2.getProperty("reportstderr") != null) {
            properties.put("reportstderr", reportstderr);
        } else {
            reportstderr = properties.getProperty("reportstderr");
        }
        if (properties2.getProperty("timeout") != null) {
            properties.put("timeout", timeout);
        } else {
            timeout = properties.getProperty("timeout");
        }
        outcopy = properties.getProperty("outcopy");
        useoutput = properties.getProperty("useoutput");
        mtestdir = properties.getProperty("mtestdir");
        ijdefaultResourcePackage = properties.getProperty("ij.defaultResourcePackage");
        if (topSuiteName == null) {
            topSuiteName = properties.getProperty("suitename");
        } else {
            properties.put("suitename", topSuiteName);
        }
        skip = RunList.shouldSkipTest();
        RunList.setSuiteDir(string, bl, bl2);
        otherSpecialProps = "";
        Properties properties3 = SpecialFlags.getSpecialProperties(properties);
        if (properties3 != null && !properties3.isEmpty()) {
            RunList.setSpecialProps(properties3, false);
        }
    }

    private static boolean shouldSkipTest() {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        driverNotFound = false;
        needSync = false;
        needJdk12 = false;
        needJdk12ext = false;
        excludedFromJCC = false;
        needIBMjvm = null;
        if (iminor >= 2) {
            bl2 = true;
        }
        if (runwithibmjvm != null) {
            needIBMjvm = runwithibmjvm.equals("") ? null : Boolean.valueOf(runwithibmjvm);
        }
        if (runwithibmjvm == null) {
            needIBMjvm = null;
        }
        if (needIBMjvm != null) {
            boolean bl11 = needIBMjvm;
            boolean bl12 = false;
            string = System.getProperty("java.vendor");
            if (string.startsWith("IBM")) {
                bl12 = true;
            }
            if (!bl11 && bl12) {
                return true;
            }
            if (bl11 && !bl12) {
                return true;
            }
        }
        if (runwithjvm != null && runwithjvm.equals("false")) {
            return true;
        }
        if (framework != null && framework.length() > 0 && framework.equals("DerbyNet")) {
            try {
                Class.forName("org.apache.derby.drda.NetworkServerControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                driverNotFound = true;
                bl = true;
            }
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                driverNotFound = true;
                bl = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                driverNotFound = true;
                bl = true;
            }
        }
        if (bl) {
            return true;
        }
        if (encryption != null && encryption.length() > 0 && "true".equalsIgnoreCase(encryption)) {
            bl5 = true;
        }
        if (jdk12test != null && jdk12test.length() > 0 && "true".equalsIgnoreCase(jdk12test)) {
            bl6 = true;
        }
        if (jdk12exttest != null && jdk12exttest.length() > 0 && "true".equalsIgnoreCase(jdk12exttest)) {
            bl7 = true;
        }
        if (!bl2) {
            if (bl5 || bl6 || bl7) {
                needJdk12 = true;
                bl = true;
            }
            if (bl) {
                return true;
            }
        }
        if (bl5 || bl7) {
            needJdk12ext = true;
            try {
                Class<?> clazz = Class.forName("javax.transaction.xa.Xid");
                Class<?> clazz2 = Class.forName("javax.sql.RowSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = true;
            }
            if (bl) {
                return true;
            }
        }
        if (bl5) {
            needEncryption = true;
            try {
                Class<?> clazz = Class.forName("javax.crypto.Cipher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = true;
            }
            if (bl) {
                return true;
            }
        }
        if (excludeJCC != null) {
            int n;
            int n2;
            block34: {
                Class<?> clazz = null;
                Method method = null;
                string = null;
                Integer n3 = null;
                n2 = 0;
                n = 0;
                try {
                    clazz = Class.forName("com.ibm.db2.jcc.DB2Driver");
                    string = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    method = clazz.getMethod("getMajorVersion", null);
                    n3 = (Integer)method.invoke((Object)string, null);
                    n2 = n3;
                    method = clazz.getMethod("getMinorVersion", null);
                    n3 = (Integer)method.invoke((Object)string, null);
                    n = n3;
                }
                catch (Exception exception) {
                    if (!verbose) break block34;
                    System.out.println("Exception in shouldSkipTest: " + exception);
                }
            }
            try {
                RunList.checkClientExclusion(excludeJCC, "JCC", n2, n, javaVersion);
            }
            catch (Exception exception) {
                excludedFromJCC = true;
                clientExclusionMessage = exception.getMessage();
                return true;
            }
        }
        return bl;
    }

    public static void setSuiteDir(String string, boolean bl, boolean bl2) throws IOException {
        if (bl2) {
            File file;
            outputdir = topsuitedir == null || topsuitedir.length() == 0 ? (topsuitedir = userdir) : topsuitedir;
            File file2 = new File(outputdir, topSuiteName);
            file2.mkdir();
            if (!topParentSuite.equals(topSuiteName)) {
                file = new File(file2, topParentSuite);
                file.mkdir();
                outputdir = file.getCanonicalPath();
            } else {
                outputdir = file2.getCanonicalPath();
            }
            topreportdir = outputdir;
            if (framework != null && framework.length() > 0) {
                file = new File(outputdir, framework);
                file.mkdir();
                outputdir = file.getCanonicalPath();
                fw_set = true;
            }
            topsuitedir = outputdir;
        } else if (bl) {
            File file;
            outputdir = topsuitedir;
            if (!string.equals(topParentSuite)) {
                file = new File(outputdir, string);
                file.mkdir();
                outputdir = file.getCanonicalPath();
            }
            if (!fw_set && framework != null && framework.length() > 0) {
                file = new File(outputdir, framework);
                file.mkdir();
                outputdir = file.getCanonicalPath();
            }
        } else if (upgradetest == null) {
            File file = new File(outputdir, string);
            file.mkdir();
            outputdir = file.getCanonicalPath();
        }
    }

    private static void setSpecialProps(Properties properties, boolean bl) {
        Object object = "";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object = (String)object + string + "=" + properties.getProperty(string) + "^";
        }
        if (((String)object).length() > 0) {
            if (bl) {
                topSpecialProps = ((String)object).substring(0, ((String)object).lastIndexOf(94));
            } else {
                otherSpecialProps = ((String)object).substring(0, ((String)object).lastIndexOf(94));
            }
        }
    }

    static void addToSkipFile(String string, PrintStream printStream) throws IOException {
        printStream.println(string);
        printStream.flush();
    }

    public static void checkClientExclusion(String string, String string2, int n, int n2, String string3) throws Exception {
        Object object;
        boolean bl;
        if (string == null) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        string = string.toLowerCase();
        String string4 = null;
        int n5 = string.indexOf(",");
        string4 = n5 != -1 ? string.substring(0, n5) : string;
        try {
            n3 = RunList.getVersionCompareType(string4);
        }
        catch (Exception exception) {
            System.out.println("exclusion property poorly formatted: " + string);
            return;
        }
        if (n5 == -1) {
            bl = false;
        } else {
            bl = true;
            object = string.substring(n5 + 6);
            try {
                n4 = RunList.getVersionCompareType((String)object);
            }
            catch (Exception exception) {
                System.out.println("exclusion property poorly formatted: " + string);
                return;
            }
        }
        object = null;
        try {
            object = RunList.getVersionArray(string, 5);
        }
        catch (Exception exception) {
            System.out.println("Unexpected text in exclusion property: " + exception.getMessage());
            return;
        }
        if (RunList.versionExcluded(new int[]{n, n2}, 0, (int[])object, 0, 2, n3)) {
            if (!bl) {
                throw new Exception("This test/suite is excluded from running with " + string2 + " versions at or " + (n3 == -1 ? "before " : "after ") + (int)object[0] + "." + (int)object[1] + ".");
            }
            int[] nArray = null;
            try {
                nArray = RunList.getVersionArray(string3, 3);
            }
            catch (Exception exception) {
                System.out.println("Unexpected text in exclusion property: " + exception.getMessage());
                return;
            }
            if (RunList.versionExcluded(nArray, 0, (int[])object, 2, 3, n4)) {
                throw new Exception("This test/suite is excluded from running with " + string2 + " versions at or " + (n3 == -1 ? "before " : "after ") + (int)object[0] + "." + (int)object[1] + " when JVM versions at or " + (n4 == -1 ? "before " : "after ") + (int)object[2] + "." + (int)object[3] + "." + (int)object[4] + " are being used.");
            }
        }
    }

    private static int[] getVersionArray(String string, int n) throws Exception {
        if (string == null) {
            string = "";
        }
        int[] nArray = new int[n];
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".,_");
        for (int i = 0; i < n; ++i) {
            if (!stringTokenizer.hasMoreTokens()) {
                nArray[i] = -1;
                continue;
            }
            string2 = stringTokenizer.nextToken();
            int n2 = 0;
            while (!Character.isDigit(string2.charAt(n2))) {
                ++n2;
            }
            string3 = string2.substring(0, n2);
            if (string3.length() > 0 && !RunList.isClientExclusionKeyword(string3)) {
                throw new Exception(string3);
            }
            if ((string2 = string2.substring(n2)).length() == 0) {
                --i;
                continue;
            }
            nArray[i] = Integer.parseInt(string2);
        }
        return nArray;
    }

    private static int getVersionCompareType(String string) throws Exception {
        if (string == null) {
            return -1;
        }
        int n = string.indexOf(":");
        if (n != -1) {
            if (string.startsWith("at-or-before")) {
                return -1;
            }
            if (string.startsWith("at-or-after")) {
                return 1;
            }
            throw new Exception("bad exclusion property format");
        }
        return -1;
    }

    private static boolean versionExcluded(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4) {
        int n5 = nArray.length >= nArray2.length ? nArray2.length : nArray.length;
        n5 = n5 <= n3 ? n5 : n3;
        for (int i = 0; i < n5; ++i) {
            if (n4 * nArray[n] > n4 * nArray2[n2]) {
                return true;
            }
            if (n4 * nArray[n] < n4 * nArray2[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        if (n5 == n3) {
            return true;
        }
        return n4 * nArray.length > n4 * nArray2.length;
    }

    private static boolean isClientExclusionKeyword(String string) {
        for (int i = 0; i < clientExclusionKeywords.length; ++i) {
            if (!clientExclusionKeywords[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private static void unloadEmbeddedDriver() {
        if (TestUtil.HAVE_DRIVER_CLASS) {
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        System.gc();
    }

    static {
        skip = false;
        driverNotFound = false;
        needSync = false;
        needJdk12 = false;
        needJdk12ext = false;
        excludedFromJCC = false;
        needIBMjvm = null;
        needEncryption = false;
        keepfiles = "false";
        runwithibmjvm = null;
        useprocess = true;
        skipsed = "false";
        fw_set = false;
        systemdiff = "false";
        suiteName = "";
        fullsuiteName = "";
        topSuiteName = "";
        topParentSuite = "";
        topSpecialProps = "";
        otherSpecialProps = "";
        verbose = false;
        clientExclusionKeywords = new String[]{"at-or-before:", "at-or-after:", "when-at-or-before:jdk", "when-at-or-after:jdk", "when:jdk"};
    }
}

