/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby2017LayerATest
extends BaseJDBCTestCase {
    public static final String UTF8 = "UTF-8";

    public Derby2017LayerATest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        baseTestSuite.addTest(TestConfiguration.defaultSuite(Derby2017LayerATest.class));
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("Client only tests");
        baseTestSuite2.addTest((Test)new Derby2017LayerATest("cs_FailedStreamInsertCharBufferBoundaries"));
        baseTestSuite2.addTest((Test)new Derby2017LayerATest("cs_StreamInsertCharBufferBoundary"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)baseTestSuite2));
        return baseTestSuite;
    }

    public void cs_StreamInsertCharBufferBoundary() throws IOException, SQLException {
        int n;
        this.rollback();
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("create table t2017_len (len int, c clob)");
        }
        catch (SQLException sQLException) {
            Derby2017LayerATest.assertSQLState("X0Y32", sQLException);
            statement.executeUpdate("delete from t2017_len");
        }
        this.commit();
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into t2017_len values (?,?)");
        for (n = 0; n < 512; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n), n);
            preparedStatement.executeUpdate();
        }
        this.commit();
        for (n = 16000; n < 18000; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n), n);
            preparedStatement.executeUpdate();
            if (n % 1000 != 0) continue;
            this.commit();
        }
        this.commit();
        for (n = 32500; n < 33000; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n), n);
            preparedStatement.executeUpdate();
        }
        this.commit();
        ResultSet resultSet = statement.executeQuery("select len, c from t2017_len");
        int n2 = 0;
        while (resultSet.next()) {
            ++n2;
            Derby2017LayerATest.assertEquals(new LoopingAlphabetReader(resultSet.getInt(1)), resultSet.getCharacterStream(2));
        }
    }

    public void cs_FailedStreamInsertCharBufferBoundaries() throws IOException, SQLException {
        for (int i = 0; i < 1024; ++i) {
            int[] nArray = new int[]{8000 + i, 16000 + i, 32000 + i, 16000 + i, 32000 + i, 48000 + i, 0 + i};
            this.doInsertTest(nArray, false, false);
        }
    }

    public void testFailedStreamInsertCharLong() throws IOException, SQLException {
        int[] nArray = new int[]{10241, 91139, 32768, 65536, 101376, 1, 201728};
        this.doInsertTest(nArray, false, false);
        this.doInsertTest(nArray, false, true);
        this.doInsertTest(nArray, true, false);
        this.doInsertTest(nArray, true, true);
    }

    public void testFailedStreamInsertCharIOException() throws IOException, SQLException {
        String[] stringArray = new String[]{"row 1", "row 2", "row 3", "IGNORE", "IGNORE", "row 6", "row 7"};
        String[][] stringArray2 = new String[][]{{"row 1"}, {"row 2"}, {"row 3"}, {"row 6"}, {"row 7"}};
        this.rollback();
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("create table t2017 (c clob)");
        }
        catch (SQLException sQLException) {
            Derby2017LayerATest.assertSQLState("X0Y32", sQLException);
            statement.executeUpdate("delete from t2017");
        }
        this.commit();
        this.setAutoCommit(true);
        PreparedStatement preparedStatement = this.prepareStatement("insert into t2017 values (?)");
        for (int i = 0; i < 3; ++i) {
            preparedStatement.setString(1, stringArray[i]);
            Derby2017LayerATest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        }
        FailingReader failingReader = new FailingReader(518L, 500L);
        preparedStatement.setCharacterStream(1, (Reader)failingReader, 518);
        try {
            preparedStatement.executeUpdate();
            Derby2017LayerATest.fail((String)"Insert should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        FailingReader failingReader2 = new FailingReader(68608L, 43008L);
        preparedStatement.setCharacterStream(1, (Reader)failingReader2, 68608);
        try {
            preparedStatement.executeUpdate();
            Derby2017LayerATest.fail((String)"Insert should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (int i = 5; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i]);
            Derby2017LayerATest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        }
        ResultSet resultSet = statement.executeQuery("select * from t2017");
        JDBC.assertFullResultSet(resultSet, stringArray2);
    }

    public void testFailedStreamInsertChar() throws IOException, SQLException {
        String[] stringArray = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] stringArray2 = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(stringArray, stringArray2, false, false);
    }

    public void testFailedStreamInsertCharAutoCommit() throws IOException, SQLException {
        String[] stringArray = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] stringArray2 = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(stringArray, stringArray2, true, false);
    }

    public void testFailedStreamInsertCharRollbackOnError() throws IOException, SQLException {
        String[] stringArray = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] stringArray2 = new String[][]{{"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(stringArray, stringArray2, false, true);
    }

    public void testFailedStreamInsertCharAutoCommitRollbackOnError() throws IOException, SQLException {
        String[] stringArray = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] stringArray2 = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(stringArray, stringArray2, true, true);
    }

    public void testFailedStreamInsertBinary() throws IOException, SQLException {
        byte[][] byArray = Derby2017LayerATest.generateDefaultInsert();
        String[][] stringArray = Derby2017LayerATest.generateMaster(byArray, new int[]{3, 4});
        this.doInsertTest(byArray, stringArray, false, false);
    }

    public void testFailedStreamInsertBinaryAutoCommit() throws IOException, SQLException {
        byte[][] byArray = Derby2017LayerATest.generateDefaultInsert();
        String[][] stringArray = Derby2017LayerATest.generateMaster(byArray, new int[]{3, 4});
        this.doInsertTest(byArray, stringArray, true, false);
    }

    public void testFailedStreamInsertBinaryRollbackOnError() throws IOException, SQLException {
        byte[][] byArray = Derby2017LayerATest.generateDefaultInsert();
        String[][] stringArray = Derby2017LayerATest.generateMaster(byArray, new int[]{0, 1, 2, 3, 4});
        this.doInsertTest(byArray, stringArray, false, true);
    }

    public void testFailedStreamInsertBinaryAutoCommitRollbackOnError() throws IOException, SQLException {
        byte[][] byArray = Derby2017LayerATest.generateDefaultInsert();
        String[][] stringArray = Derby2017LayerATest.generateMaster(byArray, new int[]{3, 4});
        this.doInsertTest(byArray, stringArray, true, true);
    }

    private void doInsertTest(String[] stringArray, String[][] stringArray2, boolean bl, boolean bl2) throws IOException, SQLException {
        PreparedStatement preparedStatement;
        Statement statement;
        block10: {
            block9: {
                Derby2017LayerATest.assertEquals((String)"Expects 7 rows", (int)7, (int)stringArray.length);
                Derby2017LayerATest.assertTrue((stringArray2.length < stringArray.length ? 1 : 0) != 0);
                this.rollback();
                statement = this.createStatement();
                try {
                    statement.executeUpdate("create table t2017 (c clob)");
                }
                catch (SQLException sQLException) {
                    Derby2017LayerATest.assertSQLState("X0Y32", sQLException);
                    statement.executeUpdate("delete from t2017");
                }
                this.commit();
                this.setAutoCommit(bl);
                preparedStatement = this.prepareStatement("insert into t2017 values (?)");
                for (int i = 0; i < 3; ++i) {
                    preparedStatement.setString(1, stringArray[i]);
                    Derby2017LayerATest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
                }
                StringReader stringReader = new StringReader(stringArray[3]);
                preparedStatement.setCharacterStream(1, (Reader)stringReader, stringArray[3].length() - 5);
                try {
                    preparedStatement.executeUpdate();
                    Derby2017LayerATest.fail((String)"Insert should have failed, stream too long");
                }
                catch (SQLException sQLException) {
                    Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN015", sQLException);
                    if (!bl2) break block9;
                    this.rollback();
                }
            }
            StringReader stringReader = new StringReader(stringArray[4]);
            preparedStatement.setCharacterStream(1, (Reader)stringReader, stringArray[4].length() + 5);
            try {
                preparedStatement.executeUpdate();
                Derby2017LayerATest.fail((String)"Insert should have failed, stream too short");
            }
            catch (SQLException sQLException) {
                Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN017", sQLException);
                if (!bl2) break block10;
                this.rollback();
            }
        }
        for (int i = 5; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i]);
            Derby2017LayerATest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        }
        if (!bl) {
            this.commit();
        }
        ResultSet resultSet = statement.executeQuery("select * from t2017");
        JDBC.assertFullResultSet(resultSet, stringArray2);
    }

    private void doInsertTest(int[] nArray, boolean bl, boolean bl2) throws IOException, SQLException {
        int n;
        int n2;
        PreparedStatement preparedStatement;
        Statement statement;
        block13: {
            block12: {
                Derby2017LayerATest.assertEquals((String)"Expects 7 rows", (int)7, (int)nArray.length);
                this.rollback();
                statement = this.createStatement();
                try {
                    statement.executeUpdate("create table t2017_id (id int unique, c clob)");
                }
                catch (SQLException sQLException) {
                    Derby2017LayerATest.assertSQLState("X0Y32", sQLException);
                    statement.executeUpdate("delete from t2017_id");
                }
                this.commit();
                this.setAutoCommit(bl);
                preparedStatement = this.prepareStatement("insert into t2017_id values (?, ?)");
                for (int i = 0; i < 3; ++i) {
                    preparedStatement.setInt(1, i + 1);
                    int n3 = nArray[i];
                    preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n3), n3);
                    Derby2017LayerATest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
                }
                LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(nArray[3]);
                preparedStatement.setInt(1, 4);
                preparedStatement.setCharacterStream(2, (Reader)loopingAlphabetReader, nArray[3] - 5);
                try {
                    preparedStatement.executeUpdate();
                    Derby2017LayerATest.fail((String)"Insert should have failed, stream too long");
                }
                catch (SQLException sQLException) {
                    Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN015", sQLException);
                    if (!bl2) break block12;
                    this.rollback();
                }
            }
            LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(nArray[4]);
            preparedStatement.setInt(1, 5);
            preparedStatement.setCharacterStream(2, (Reader)loopingAlphabetReader, nArray[4] + 5);
            try {
                preparedStatement.executeUpdate();
                Derby2017LayerATest.fail((String)"Insert should have failed, stream too short");
            }
            catch (SQLException sQLException) {
                Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN017", sQLException);
                if (!bl2) break block13;
                this.rollback();
            }
        }
        for (int i = 5; i < nArray.length; ++i) {
            preparedStatement.setInt(1, i + 1);
            n2 = nArray[i];
            preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n2), n2);
            Derby2017LayerATest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        }
        if (!bl) {
            this.commit();
        }
        ResultSet resultSet = statement.executeQuery("select count(*) from t2017_id");
        resultSet.next();
        Derby2017LayerATest.assertEquals((int)(bl2 && !bl ? 2 : 5), (int)resultSet.getInt(1));
        resultSet = statement.executeQuery("select * from t2017_id order by id asc");
        if (bl || !bl2) {
            for (n2 = 0; n2 < 3; ++n2) {
                resultSet.next();
                n = resultSet.getInt(1);
                Derby2017LayerATest.assertTrue((n - 1 == n2 ? 1 : 0) != 0);
                Derby2017LayerATest.assertEquals(new LoopingAlphabetReader(nArray[n2]), resultSet.getCharacterStream(2));
            }
        }
        for (n2 = 5; n2 < 7; ++n2) {
            resultSet.next();
            n = resultSet.getInt(1);
            Derby2017LayerATest.assertTrue((n - 1 == n2 ? 1 : 0) != 0);
            Derby2017LayerATest.assertEquals(new LoopingAlphabetReader(nArray[n2]), resultSet.getCharacterStream(2));
        }
        Derby2017LayerATest.assertFalse((boolean)resultSet.next());
        resultSet.close();
    }

    private void doInsertTest(byte[][] byArray, String[][] stringArray, boolean bl, boolean bl2) throws IOException, SQLException {
        PreparedStatement preparedStatement;
        Statement statement;
        block10: {
            block9: {
                Derby2017LayerATest.assertEquals((String)"Expects 7 rows", (int)7, (int)byArray.length);
                Derby2017LayerATest.assertTrue((stringArray.length < byArray.length ? 1 : 0) != 0);
                this.rollback();
                statement = this.createStatement();
                try {
                    statement.executeUpdate("create table t2017_binary (b blob)");
                }
                catch (SQLException sQLException) {
                    Derby2017LayerATest.assertSQLState("X0Y32", sQLException);
                    statement.executeUpdate("delete from t2017_binary");
                }
                this.commit();
                this.setAutoCommit(bl);
                preparedStatement = this.prepareStatement("insert into t2017_binary values (?)");
                for (int i = 0; i < 3; ++i) {
                    preparedStatement.setBytes(1, byArray[i]);
                    Derby2017LayerATest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[3]);
                preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray[3].length - 5);
                try {
                    preparedStatement.executeUpdate();
                    Derby2017LayerATest.fail((String)"Insert should have failed, stream too long");
                }
                catch (SQLException sQLException) {
                    Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN015", sQLException);
                    if (!bl2) break block9;
                    this.rollback();
                }
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[4]);
            preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray[4].length + 5);
            try {
                preparedStatement.executeUpdate();
                Derby2017LayerATest.fail((String)"Insert should have failed, stream too short");
            }
            catch (SQLException sQLException) {
                Derby2017LayerATest.assertSQLState(Derby2017LayerATest.usingEmbedded() ? "XSDA4" : "XN017", sQLException);
                if (!bl2) break block10;
                this.rollback();
            }
        }
        for (int i = 5; i < byArray.length; ++i) {
            preparedStatement.setBytes(1, byArray[i]);
            Derby2017LayerATest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        }
        if (!bl) {
            this.commit();
        }
        ResultSet resultSet = statement.executeQuery("select * from t2017_binary");
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public static byte[][] generateDefaultInsert() {
        try {
            byte[][] byArrayArray = new byte[][]{"This is row 1".getBytes(UTF8), "This is row 2".getBytes(UTF8), "This is row 3".getBytes(UTF8), "This is row 4, a bit too long".getBytes(UTF8), "This is row 5, a bit too short".getBytes(UTF8), "This is row 6".getBytes(UTF8), "This is row 7".getBytes(UTF8)};
            return byArrayArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String[][] generateMaster(byte[][] byArray, int[] nArray) {
        Arrays.sort(nArray);
        int n = 0;
        String[][] stringArray = new String[byArray.length - nArray.length][];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (i == nArray[n]) {
                if (n >= nArray.length - 1) continue;
                ++n;
                continue;
            }
            Object object = new BigInteger(1, byArray[i]).toString(16);
            while (((String)object).length() < byArray[i].length * 2) {
                object = "0" + (String)object;
            }
            stringArray[n2++] = new String[]{object};
        }
        return stringArray;
    }

    public static class FailingReader
    extends Reader {
        private final LoopingAlphabetReader in;
        private final long failAtPos;
        private long pos;

        public FailingReader(long l, long l2) {
            this.failAtPos = l2;
            this.in = new LoopingAlphabetReader(l);
        }

        @Override
        public int read() throws IOException {
            ++this.pos;
            int n = this.in.read();
            if (this.pos >= this.failAtPos) {
                throw new IOException("forced exception");
            }
            return n;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            if (this.pos == 0L && this.failAtPos > 1L) {
                n2 = (int)Math.min(this.failAtPos - 1L, (long)n2);
            }
            if ((n3 = this.in.read(cArray, n, n2)) != -1) {
                this.pos += (long)n3;
            }
            if (this.pos >= this.failAtPos) {
                throw new IOException("forced exception");
            }
            return n3;
        }

        @Override
        public void close() {
            this.in.close();
        }
    }
}

