/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OrderByAndOffsetFetchInSubqueries
extends BaseJDBCTestCase {
    static final String SYNTAX_ERROR = "42X01";
    static final String COLUMN_NOT_FOUND = "42X04";
    static final String COLUMN_OUT_OF_RANGE = "42X77";
    static final String ORDER_BY_COLUMN_NOT_FOUND = "42X78";

    public OrderByAndOffsetFetchInSubqueries(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("OrderByAndOffsetFetchInSubqueries");
        baseTestSuite.addTest(OrderByAndOffsetFetchInSubqueries.makeSuite());
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(OrderByAndOffsetFetchInSubqueries.makeSuite()));
        return baseTestSuite;
    }

    private static Test makeSuite() {
        return new CleanDatabaseTestSetup((Test)new BaseTestSuite(OrderByAndOffsetFetchInSubqueries.class)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                this.getConnection().setAutoCommit(false);
                statement.execute("create table temp1(s varchar(10))");
                statement.execute("create table temp2(i integer not null     generated always as identity,s varchar(10))");
                statement.execute("create table temp2b(i integer not null     generated always as identity,s varchar(10))");
                statement.execute("create table temp3(i integer not null     generated always as identity,s varchar(10),j integer not null     default 66,t varchar(10))");
                statement.execute("create table temp4(i integer not null     generated always as identity,s varchar(10),j integer not null     generated always as (2*i),t varchar(10))");
                statement.execute("create table t01(c1 int)");
                statement.execute("create table t02(c2 int)");
                statement.execute("create table t_source(c1 int, c2 varchar(10))");
                statement.execute("create table t(i int not null,                constraint c unique (i),                j int, k int)");
                this.getConnection().commit();
            }
        };
    }

    public void testInsertSelectOrderBy() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("insert into temp1 values 'x','a','c','b','a'");
        statement.execute("insert into temp2(s) select s from temp1 order by s");
        statement.execute("insert into temp2(s) select s as a1 from temp1 order by a1");
        statement.execute("insert into temp2(s) select * from temp1 order by s");
        ResultSet resultSet = statement.executeQuery("select * from temp2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "a"}, {"2", "a"}, {"3", "b"}, {"4", "c"}, {"5", "x"}, {"6", "a"}, {"7", "a"}, {"8", "b"}, {"9", "c"}, {"10", "x"}, {"11", "a"}, {"12", "a"}, {"13", "b"}, {"14", "c"}, {"15", "x"}});
        resultSet = statement.executeQuery("select * from temp2 order by i");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "a"}, {"2", "a"}, {"3", "b"}, {"4", "c"}, {"5", "x"}, {"6", "a"}, {"7", "a"}, {"8", "b"}, {"9", "c"}, {"10", "x"}, {"11", "a"}, {"12", "a"}, {"13", "b"}, {"14", "c"}, {"15", "x"}});
        statement.execute("insert into temp2(s) select s as a1 from temp1 order by s");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(COLUMN_NOT_FOUND, statement, "insert into temp2(s) select s as a1 from temp1 order by no_such");
        statement.execute("insert into t01 values (50), (10), (1000), (15), (51)");
        resultSet = statement.executeQuery("select * from t01");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"50"}, {"10"}, {"1000"}, {"15"}, {"51"}});
        statement.execute("insert into t02 select * from t01 order by c1");
        statement.execute("insert into t02 select * from t01");
        statement.execute("insert into t02 select * from t01 order by c1");
        resultSet = statement.executeQuery("select * from t02");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"10"}, {"15"}, {"50"}, {"51"}, {"1000"}, {"50"}, {"10"}, {"1000"}, {"15"}, {"51"}, {"10"}, {"15"}, {"50"}, {"51"}, {"1000"}});
        OrderByAndOffsetFetchInSubqueries.assertStatementError(SYNTAX_ERROR, statement, "insert into t02 values 66 order by 1");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(SYNTAX_ERROR, statement, "insert into t02 values (901), (920), (903) order by 1");
        statement.executeUpdate("delete from t02");
        statement.executeUpdate("insert into t02 select 900 from sys.systables                 union values 66 order by 1");
        resultSet = statement.executeQuery("select * from t02");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"66"}, {"900"}});
        statement.executeUpdate("delete from t02");
        statement.executeUpdate("insert into t02 values 66        union select 900 from sys.systables order by 1");
        resultSet = statement.executeQuery("select * from t02");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"66"}, {"900"}});
        statement.executeUpdate("delete from t02");
        statement.executeUpdate("insert into t02 values 66        union values 66 order by 1");
        resultSet = statement.executeQuery("select * from t02");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"66"}});
        statement.execute("delete from t02");
        statement.execute("insert into t02 select * from t01 union all                 select * from t01 order by c1");
        resultSet = statement.executeQuery("select * from t02");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"10"}, {"10"}, {"15"}, {"15"}, {"50"}, {"50"}, {"51"}, {"51"}, {"1000"}, {"1000"}});
        OrderByAndOffsetFetchInSubqueries.assertStatementError(ORDER_BY_COLUMN_NOT_FOUND, statement, "insert into t02 select * from t01 union all                 select * from t02 order by c1");
        statement.execute("delete from t02");
        statement.execute("insert into t_source     values (1, 'one'), (2, 'two'), (8, 'three')");
        statement.execute("insert into t_source(c1)     select c1 from t_source order by c2 desc");
        resultSet = statement.executeQuery("select * from t_source");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "one"}, {"2", "two"}, {"8", "three"}, {"2", null}, {"8", null}, {"1", null}});
        statement.executeUpdate("create table t4496(x varchar(100))");
        statement.execute("insert into t4496(x) select ibmreqd from     (select * from sysibm.sysdummy1         order by length(ibmreqd)) t1");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t4496"), new String[][]{{"Y"}});
        statement.execute("create table t6006(x double)");
        OrderByAndOffsetFetchInSubqueries.assertUpdateCount(statement, 6, "insert into t6006 values 1,2,3,4,5,6");
        OrderByAndOffsetFetchInSubqueries.assertUpdateCount(statement, 6, "insert into t6006 select 1 from t6006 order by x");
        this.rollback();
    }

    public void testInsertSelectOrderByOffsetFetch() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("insert into temp1 values 'x','a','c','b','a'");
        statement.execute("insert into temp2b(s) select s from temp1 order by s     offset 1 rows fetch next 4 rows only");
        JDBC.assertFullResultSet(statement.executeQuery("select * from temp2b"), new String[][]{{"1", "a"}, {"2", "b"}, {"3", "c"}, {"4", "x"}});
        statement.execute("insert into temp2b(s) select s as a1 from temp1 order by a1    offset 1 rows fetch next 4 rows only");
        statement.execute("insert into temp2b(s) select * from temp1 order by s     offset 1 rows fetch next 4 rows only");
        ResultSet resultSet = statement.executeQuery("select * from temp2b");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "a"}, {"2", "b"}, {"3", "c"}, {"4", "x"}, {"5", "a"}, {"6", "b"}, {"7", "c"}, {"8", "x"}, {"9", "a"}, {"10", "b"}, {"11", "c"}, {"12", "x"}});
        resultSet = statement.executeQuery("select * from temp2b order by i");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "a"}, {"2", "b"}, {"3", "c"}, {"4", "x"}, {"5", "a"}, {"6", "b"}, {"7", "c"}, {"8", "x"}, {"9", "a"}, {"10", "b"}, {"11", "c"}, {"12", "x"}});
        statement.execute("insert into t01 values (50), (10), (1000), (15), (51)");
        resultSet = statement.executeQuery("select * from t01");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"50"}, {"10"}, {"1000"}, {"15"}, {"51"}});
        statement.execute("insert into t02 select * from t01 order by c1     fetch first 2 rows only");
        statement.execute("insert into t02 select * from t01");
        statement.execute("insert into t02 select * from t01 order by c1 offset 0 rows");
        resultSet = statement.executeQuery("select * from t02");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"10"}, {"15"}, {"50"}, {"10"}, {"1000"}, {"15"}, {"51"}, {"10"}, {"15"}, {"50"}, {"51"}, {"1000"}});
        OrderByAndOffsetFetchInSubqueries.assertStatementError(SYNTAX_ERROR, statement, "insert into t02 values 66 offset 1 row");
        statement.executeUpdate("delete from t02");
        statement.executeUpdate("insert into t02 select 900 from sys.systables                 union values 66 order by 1 offset 1 row");
        resultSet = statement.executeQuery("select * from t02");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"900"}});
        statement.executeUpdate("delete from t02");
        statement.executeUpdate("insert into t02 values 66        union select 900 from sys.systables fetch next 1 row only");
        resultSet = statement.executeQuery("select * from t02");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"66"}});
        statement.executeUpdate("delete from t02");
        statement.executeUpdate("insert into t02 select * from (values 3,4,5 )v     order by 1 offset 1 row fetch next 2 rows only");
        resultSet = statement.executeQuery("select * from t02");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"4"}, {"5"}});
        statement.execute("delete from t02");
        statement.execute("insert into t02 select * from t01 union all                 select * from t01 order by c1                 fetch next 4 rows only");
        resultSet = statement.executeQuery("select * from t02");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"10"}, {"10"}, {"15"}, {"15"}});
        statement.execute("delete from t01");
        statement.execute("insert into t02 values 6,7");
        statement.execute("insert into t01 select * from t02 except                 values 10 order by 1 offset 1 row");
        resultSet = statement.executeQuery("select * from t01");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"7"}, {"15"}});
        statement.execute("delete from t02");
        statement.execute("insert into t_source     values (1, 'one'), (2, 'two'), (8, 'three')");
        statement.execute("insert into t_source(c1)     select c1 from t_source order by c2 desc     fetch next 2 rows only");
        resultSet = statement.executeQuery("select * from t_source");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "one"}, {"2", "two"}, {"8", "three"}, {"2", null}, {"8", null}});
        this.rollback();
    }

    public void testSelectSubqueriesOrderBy() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("insert into t_source values (1, 'one'), (2, 'two'), (8, 'three')");
        ResultSet resultSet = statement.executeQuery("select * from (select c1 from t_source order by c1 desc) s");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"8"}, {"2"}, {"1"}});
        resultSet = statement.executeQuery("select * from (select c1+1 from t_source order by c1+1 desc) s");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"9"}, {"3"}, {"2"}});
        resultSet = statement.executeQuery("select * from (select c1,c2 from t_source order by c1 desc,2) s");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"8", "three"}, {"2", "two"}, {"1", "one"}});
        resultSet = statement.executeQuery("select * from (select c2 from t_source order by c1 desc) s");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"three"}, {"two"}, {"one"}});
        resultSet = statement.executeQuery("select * from     (select c2 from t_source order by c1 desc) s order by 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"one"}, {"three"}, {"two"}});
        resultSet = statement.executeQuery("select * from (values (1, 'one'), (2, 'two'), (8, 'three')               order by 1 desc) s");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"8", "three"}, {"2", "two"}, {"1", "one"}});
        resultSet = statement.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c1)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"8"}});
        resultSet = statement.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c1 desc)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"8"}});
        resultSet = statement.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c2 desc)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"8"}});
        resultSet = statement.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c2 desc) order by 1 desc");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"8"}, {"2"}, {"1"}});
        resultSet = statement.executeQuery("select c1 from t_source where not exists     (select c1 from t_source order by c2 desc) order by 1 desc");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select c1 from t_source ot where not exists    (select c1 from t_source where ot.c1=(c1/2) order by c2 desc)    order by 1 desc");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"8"}, {"2"}});
        statement.executeUpdate("insert into t values (1,10,1), (2,40,1),         (3,45,1), (4,46,1), (5,90,1)");
        resultSet = statement.executeQuery("select * from t where i in (select i/5 from t order by 1 desc)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "10", "1"}});
        resultSet = statement.executeQuery("select * from t where i in (select i/5 from t order by i/5 desc)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "10", "1"}});
        resultSet = statement.executeQuery("select * from t where i in (select i/5 from t order by j)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "10", "1"}});
        String[][] stringArray = new String[][]{{"1", "10", "1"}, {"2", "40", "1"}};
        resultSet = statement.executeQuery("select * from t t_o where i <= all (    select i+1 from t where i = t_o.k + (        select count(*) from t) - 5)");
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from t t_o where i <= all (    select i+1 from t where i = t_o.k + (        select count(*) from t order by 1) - 5     order by 1 desc)");
        JDBC.assertFullResultSet(resultSet, stringArray);
        this.rollback();
    }

    public void testSelectSubqueriesOrderByAndOffsetFetch() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("insert into t_source values (1, 'one'), (2, 'two'), (8, 'three')");
        ResultSet resultSet = statement.executeQuery("select * from (select c1 from t_source order by c1 desc                offset 1 row) s");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}, {"1"}});
        resultSet = statement.executeQuery("select * from (select c1+1 from t_source order by c1+1 desc                fetch first 2 rows only) s");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"9"}, {"3"}});
        resultSet = statement.executeQuery("select * from (select c1,c2 from t_source order by c1 desc,2                offset 2 rows fetch next 1 row only) s");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "one"}});
        resultSet = statement.executeQuery("select * from (select c2 from t_source order by c1 desc                offset 2 rows) s");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"one"}});
        resultSet = statement.executeQuery("select * from     (select c2 from t_source order by c1 desc      fetch first 2 row only) s order by 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"three"}, {"two"}});
        resultSet = statement.executeQuery("select * from (values (1, 'one'), (2, 'two'), (8, 'three')               order by 1 desc offset 1 row) s");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2", "two"}, {"1", "one"}});
        resultSet = statement.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c1 offset 1 row)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"8"}});
        resultSet = statement.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c1 offset 3 rows)");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c1 desc      fetch first 1 row only)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"8"}});
        resultSet = statement.executeQuery("select c1 from t_source where exists     (select c1 from t_source offset 1 row)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"8"}});
        resultSet = statement.executeQuery("select c1 from t_source where exists     (select c1 from t_source order by c2 desc      offset 1 row fetch first 1 row only)   order by 1 desc offset 1 row fetch first 1 row only");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}});
        resultSet = statement.executeQuery("select c1 from t_source where not exists     (select c1 from t_source order by c2 desc          offset 3 rows)     order by 1 desc");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"8"}, {"2"}, {"1"}});
        resultSet = statement.executeQuery("select c1 from t_source ot where not exists    (select c1 from t_source where ot.c1=(c1/2) order by c2 desc         offset 1 row)   order by 1 desc");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"8"}, {"2"}, {"1"}});
        statement.executeUpdate("insert into t values (1,10,1), (2,40,1),         (3,45,1), (4,46,1), (5,90,1)");
        resultSet = statement.executeQuery("select * from t where i in (select i/5 from t order by 1 desc                             offset 1 row)");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select * from t where i in (select i/5 from t order by 1 asc                             offset 1 row)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "10", "1"}});
        resultSet = statement.executeQuery("select * from t where i in (select i/5 from t order by i/5 desc                             offset 1 row)");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select * from t where i in (select i/5 from t order by i/5 asc                             offset 1 row)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "10", "1"}});
        resultSet = statement.executeQuery("select * from t where i in (select i/5 from t order by j                             offset 1 row)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "10", "1"}});
        resultSet = statement.executeQuery("select * from t where i in (select i/5 from t order by j desc                             offset 1 row)");
        JDBC.assertEmpty(resultSet);
        String[][] stringArray = new String[][]{{"1", "10", "1"}, {"2", "40", "1"}};
        resultSet = statement.executeQuery("select * from t t_o where i <= all (    select i+1 from t where i = t_o.k + (        select count(*) from t) - 5)");
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from t where i = (select count(*) from t order by 1                            offset 1 row)");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select * from t t_o where i <= all (    select i+1 from t where i = t_o.k + cast(null as int) +         - 5     order by 1 desc)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "10", "1"}, {"2", "40", "1"}, {"3", "45", "1"}, {"4", "46", "1"}, {"5", "90", "1"}});
        resultSet = statement.executeQuery("select * from t t_o where i <= all (    select i+1 from t where i = t_o.k + (        select count(*) from t order by 1 offset 1 row) - 5     order by 1 desc)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "10", "1"}, {"2", "40", "1"}, {"3", "45", "1"}, {"4", "46", "1"}, {"5", "90", "1"}});
        this.rollback();
    }

    public void testJoinsWithOffsetFetch() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("insert into temp1 values 'x','a','c','b','a'");
        PreparedStatement preparedStatement = this.prepareStatement("select * from    (select s from temp1 order by s                         fetch first ? rows only) t1 join    (select s from temp1 order by s offset ? row                         fetch first ? row only) t2    on t1.s=t2.s");
        preparedStatement.setInt(1, 2);
        preparedStatement.setInt(2, 1);
        preparedStatement.setInt(3, 1);
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"a", "a"}, {"a", "a"}});
        preparedStatement.setInt(1, 1);
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"a", "a"}});
        this.rollback();
    }

    public void testView() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create view v1 as select i from t order by j desc");
        statement.executeUpdate("create view v2 as select i from t order by i");
        statement.executeUpdate("insert into t values (1,10,1), (2,40,1),         (3,45,1), (4,46,1), (5,90,1)");
        ResultSet resultSet = statement.executeQuery("select i from v1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"5"}, {"4"}, {"3"}, {"2"}, {"1"}});
        resultSet = statement.executeQuery("select i from v2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}});
        this.rollback();
    }

    public void testViewFetchOffset() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create view v1 as select i from t order by j desc                   offset 2 rows fetch first 1 row only");
        statement.executeUpdate("create view v2 as select i from t order by i                   fetch next 2 rows only");
        statement.executeUpdate("insert into t values (1,10,1), (2,40,1),         (3,45,1), (4,46,1), (5,90,1)");
        ResultSet resultSet = statement.executeQuery("select i from v1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"3"}});
        resultSet = statement.executeQuery("select i from v2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}});
        this.rollback();
    }

    public void testSelectSubqueriesOrderByNegative() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("insert into t_source values (1, 'one'), (2, 'two'), (8, 'three')");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(COLUMN_NOT_FOUND, statement, "select * from (select c1 from t_source order by c3 desc) s");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(COLUMN_OUT_OF_RANGE, statement, "select * from (select c1 from t_source order by 3 desc) s");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(COLUMN_OUT_OF_RANGE, statement, "select * from (values (1, 'one'), (2, 'two'), (8, 'three')               order by 3 desc) s");
        OrderByAndOffsetFetchInSubqueries.assertStatementError(COLUMN_NOT_FOUND, statement, "select c1 from t_source where exists     (select c1 from t_source order by c4)");
        this.rollback();
    }

    public void testSelectSubqueriesSortAvoidance() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table ts(i int, j int)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into ts values(?,?)");
        for (int i = 0; i < 100; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i * 2);
            preparedStatement.execute();
        }
        statement.executeUpdate("create unique index t_i on ts(i)");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet resultSet = statement.executeQuery("select * from (select i from ts order by i)tt");
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        OrderByAndOffsetFetchInSubqueries.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("TS", "T_I"));
        OrderByAndOffsetFetchInSubqueries.assertFalse((boolean)runtimeStatisticsParser.whatSortingRequired());
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        this.rollback();
    }

    public void testPushAvoidance() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE COFFEES (COF_NAME VARCHAR(254),PRICE INTEGER)");
        statement.executeUpdate("INSERT INTO COFFEES VALUES ('Colombian', 5)");
        statement.executeUpdate("INSERT INTO COFFEES VALUES ('French_Roast', 5)");
        statement.executeUpdate("INSERT INTO COFFEES VALUES ('Colombian_Decaf', 20)");
        ResultSet resultSet = statement.executeQuery("select * from     (select COF_NAME, PRICE from COFFEES      order by COF_NAME fetch next 2 rows only    ) t where t.PRICE < 10");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Colombian", "5"}});
        resultSet = statement.executeQuery("select * from     (select COF_NAME, PRICE from COFFEES      order by COF_NAME offset 2 row    ) t where t.PRICE < 10");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"French_Roast", "5"}});
        resultSet = statement.executeQuery("select cof_name, price from    (select row_number() over() as rownum, COF_NAME, PRICE from       (select * from COFFEES order by COF_NAME) i   ) t where rownum <= 2 and PRICE < 10");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Colombian", "5"}});
        this.rollback();
    }

    public void testNestingInsideSetOperation() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1(i int, j int )");
        statement.executeUpdate("create table t2(i int, j int)");
        statement.executeUpdate("insert into t1 values (1,1),(4,8),(2,4)");
        statement.executeUpdate("insert into t2 values (10,10),(40,80),(20,40)");
        ResultSet resultSet = statement.executeQuery("(select i from t1 order by j desc offset 1 row) union (select i from t2 order by j desc offset 1 rows fetch next 1 row only)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"20"}});
        this.assertCompileError(SYNTAX_ERROR, "select i from t1 order by j desc offset 1 row union (select i from t2 order by j desc offset 2 rows)");
        resultSet = statement.executeQuery("(values 1 order by 1 fetch first 1 row only) union (select i from t2 order by j desc offset 2 rows)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"10"}});
        resultSet = statement.executeQuery("(values 1 order by 1,1 fetch first 1 row only) union (select i from t2 order by j desc offset 2 rows)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"10"}});
        resultSet = statement.executeQuery("(values 1,2 order by 1 desc offset 1 row                        fetch first 1 row only) union (select i from t2 order by j desc offset 2 rows)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"10"}});
        resultSet = statement.executeQuery("(values 1,2 order by 1,1 offset 1 row fetch first 1 row only) union (select i from t2 order by j desc offset 2 rows)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}, {"10"}});
        statement.executeUpdate("create table countries(name varchar(20),                        population int,                        area int)");
        statement.executeUpdate("insert into countries values('Norway', 5033675, 385252),('Sweden', 9540065, 449964),('Denmark', 5580413, 42894),('Iceland', 320060, 103001),('Liechtenstein', 36281, 160)");
        resultSet = statement.executeQuery("(select name from countries     order by population desc fetch first 2 rows only) intersect (select name from countries     order by area desc fetch first 2 rows only)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Sweden"}});
        resultSet = statement.executeQuery("(values ('Norway', 5033675, 385252),         ('Sweden', 9540065, 449964),        ('Denmark', 5580413, 42894),        ('Iceland', 320060, 103001),        ('Liechtenstein', 36281, 160)    order by 2 desc fetch first 3 rows only) intersect (select * from countries     order by area desc fetch first 3 rows only)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Norway", "5033675", "385252"}, {"Sweden", "9540065", "449964"}});
        resultSet = statement.executeQuery("(values ('Norway', 5033675, 385252)    order by 2 desc fetch first 3 rows only) intersect (values ('Norway', 5033675, 385252))");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Norway", "5033675", "385252"}});
        resultSet = statement.executeQuery("(select name from countries     order by population desc fetch first 2 rows only) except (select name from countries     order by area desc fetch first 2 rows only)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Denmark"}});
        resultSet = statement.executeQuery("(values ('Norway', 5033675, 385252),         ('Sweden', 9540065, 449964),        ('Denmark', 5580413, 42894),        ('Iceland', 320060, 103001),        ('Liechtenstein', 36281, 160)    order by 2 desc fetch first 3 rows only) except (select * from countries     order by area desc fetch first 3 rows only)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Denmark", "5580413", "42894"}});
        this.rollback();
    }

    public void testDerby6378() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1 (a int, b bigint)");
        statement.executeUpdate("delete from t1");
        statement.executeUpdate("insert into t1 values (1,-10), (2,-11), (3,-9), (4,-20), (5,-1)");
        this.queryAndCheck(statement, "(select * from t1 offset 1 row fetch first 1 row only)", new String[][]{{"2", "-11"}});
        this.queryAndCheck(statement, "(select * from t1 order by a desc fetch first 3 rows only)      offset 1 row fetch first 1 row only", new String[][]{{"4", "-20"}});
        this.queryAndCheck(statement, "((select * from t1 order by a desc)      fetch first 3 rows only)", new String[][]{{"5", "-1"}, {"4", "-20"}, {"3", "-9"}});
        this.queryAndCheck(statement, "((((select * from t1 order by a desc)         fetch first 3 rows only))     order by b) fetch first 1 row only", new String[][]{{"4", "-20"}});
        this.queryAndCheck(statement, "(((((values (1,-10), (2,-11), (3,-9), (4,-20), (5,-1))            order by 1 desc)         fetch first 3 rows only))     order by 2) fetch first 1 row only", new String[][]{{"4", "-20"}});
        this.rollback();
        statement.close();
    }

    private void queryAndCheck(Statement statement, String string, String[][] stringArray) throws SQLException {
        ResultSet resultSet = statement.executeQuery(string);
        JDBC.assertFullResultSet(resultSet, stringArray);
    }
}

