/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ReleaseCompileLocksTest
extends BaseJDBCTestCase {
    public ReleaseCompileLocksTest(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    protected void setUp() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create function dmlstatic() returns INT parameter style java language java external name 'org.apache.derbyTesting.functionTests.util.StaticInitializers.DMLInStaticInitializer.getANumber' no sql");
        statement.execute("create function insertstatic() returns INT parameter style java language java external name 'org.apache.derbyTesting.functionTests.util.StaticInitializers.InsertInStaticInitializer.getANumber' no sql");
        statement.execute("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
        statement.close();
        this.commit();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReleasecompileLocksTest");
        baseTestSuite.addTest(ReleaseCompileLocksTest.baseSuite("ReleaseCompileLocksTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ReleaseCompileLocksTest.baseSuite("ReleaseCompileLocksTest:client")));
        return baseTestSuite;
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(ReleaseCompileLocksTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table t1 (s int)");
            }
        };
    }

    public void testReleaseCompileLocks() throws Exception {
        Statement statement = this.createStatement();
        if (JDBC.vmSupportsJDBC3()) {
            JDBC.assertFullResultSet(statement.executeQuery("select (dmlstatic()) from sys.systables where CAST(tablename AS VARCHAR(128))= 'SYSCONGLOMERATES'"), new String[][]{{"1"}});
        } else {
            JDBC.assertFullResultSet(statement.executeQuery("select count(*) from sys.systables where CAST(tablename AS VARCHAR(128)) = 'SYSCONGLOMERATES'"), new String[][]{{"1"}});
        }
        this.assertNoLocks(statement);
        this.commit();
        statement.execute("drop table t1");
        statement.execute("create table t1 (s int)");
        this.commit();
        if (JDBC.vmSupportsJDBC3()) {
            JDBC.assertFullResultSet(statement.executeQuery("select (insertstatic()) from sys.systables where CAST(tablename AS VARCHAR(128)) = 'SYSCONGLOMERATES'"), new String[][]{{"1"}});
        } else {
            JDBC.assertFullResultSet(statement.executeQuery("select count(*) from sys.systables where CAST(tablename AS VARCHAR(128)) = 'SYSCONGLOMERATES'"), new String[][]{{"1"}});
        }
        this.assertNoLocks(statement);
        JDBC.assertEmpty(statement.executeQuery("select * from t1"));
        statement.execute("drop table t1");
        this.commit();
        this.assertNoLocks(statement);
        this.commit();
        statement.execute("create table test_tab (x int)");
        statement.executeUpdate("insert into test_tab values (1)");
        this.commit();
        this.assertNoLocks(statement);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from sys.sysviews"), "0");
        this.assertNoLocks(statement);
        statement.execute("insert into test_tab values (2)");
        this.waitForPostCommit(statement);
        ResultSet resultSet = statement.executeQuery("select TYPE, MODE, TABLENAME, LOCKNAME, STATE from syscs_diag.lock_table order by 1");
        String[][] stringArray = new String[][]{{"ROW", "X", "TEST_TAB", "(1,8)", "GRANT"}, {"TABLE", "IX", "TEST_TAB", "Tablelock", "GRANT"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        try {
            statement.execute("drop table t1");
            ReleaseCompileLocksTest.fail((String)"expected SQLException; table t should not exist");
        }
        catch (SQLException sQLException) {
            ReleaseCompileLocksTest.assertSQLState("42Y55", sQLException);
        }
        statement.execute("create table t1 (x int)");
        this.commit();
        JDBC.assertEmpty(statement.executeQuery("select * from t1"));
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement();
        statement2.execute("create table t2 (x int)");
        statement2.execute("drop table t2");
        statement2.close();
        connection.commit();
        connection.close();
        statement.execute("drop table test_tab");
        statement.execute("create table test_tab (x int)");
        statement.execute("insert into test_tab values (1)");
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("update test_tab set x=2 where x=?");
        preparedStatement.setCursorName("cursor1");
        preparedStatement.setInt(1, 1);
        this.assertNoLocks(statement);
        preparedStatement.executeUpdate();
        this.waitForPostCommit(statement);
        resultSet = statement.executeQuery("select TYPE, MODE, TABLENAME, LOCKNAME, STATE from syscs_diag.lock_table order by 1");
        String[][] stringArray2 = new String[][]{{"ROW", "X", "TEST_TAB", "(1,7)", "GRANT"}, {"TABLE", "IX", "TEST_TAB", "Tablelock", "GRANT"}};
        JDBC.assertFullResultSet(resultSet, stringArray2);
        this.commit();
        statement.execute("create table t (c1 int not null primary key, c2 int references t)");
        statement.executeUpdate("insert into t values (1,1)");
        statement.executeUpdate("insert into t values (2,1)");
        this.commit();
        preparedStatement = this.prepareStatement("select * from t where c1 = ? and c2 = ?");
        preparedStatement.setCursorName("ps");
        this.assertNoLocks(statement);
        statement.execute("create table x(c1 int)");
        statement.execute("drop table x");
        this.commit();
        preparedStatement = this.prepareStatement("insert into t values (3,2)");
        preparedStatement.setCursorName("pi");
        this.assertNoLocks(statement);
        this.commit();
        statement.execute("create table x(c1 int)");
        statement.execute("drop table x");
        this.commit();
        preparedStatement = this.prepareStatement("update t set c2 = c1, c1 = c2");
        preparedStatement.setCursorName("p1");
        this.assertNoLocks(statement);
        this.commit();
        statement.execute("create table x(c1 int)");
        statement.execute("drop table x");
        this.commit();
        preparedStatement = this.prepareStatement("delete from t");
        preparedStatement.setCursorName("p1");
        this.assertNoLocks(statement);
        this.commit();
        statement.execute("create trigger update_of_t after update on t for each row values 2");
        statement.execute("create trigger insert_of_t after insert on t for each row values 3");
        this.commit();
        preparedStatement = this.prepareStatement("update t set c2=2 where c1=2");
        preparedStatement.setCursorName("pu");
        this.assertNoLocks(statement);
        this.commit();
        resultSet.close();
        preparedStatement.close();
        statement.close();
    }

    private void assertNoLocks(Statement statement) throws SQLException {
        this.waitForPostCommit(statement);
        JDBC.assertEmpty(statement.executeQuery("SELECT * FROM SYSCS_DIAG.LOCK_TABLE"));
    }

    private void waitForPostCommit(Statement statement) throws SQLException {
        statement.execute("CALL WAIT_FOR_POST_COMMIT()");
    }
}

