/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.BankAccountFiller;
import org.apache.derbyTesting.perf.clients.Client;

public class BankTransactionClient
implements Client {
    private final Random random = new Random();
    private final int branches;
    private final int tellersPerBranch;
    private final int accountsPerBranch;
    private Connection conn;
    private PreparedStatement updateAccount;
    private PreparedStatement updateHistory;
    private PreparedStatement updateTeller;
    private PreparedStatement updateBranch;
    private PreparedStatement retrieveAccountBalance;

    public BankTransactionClient(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("all arguments must be greater than 0");
        }
        this.branches = n;
        this.tellersPerBranch = n2;
        this.accountsPerBranch = n3;
    }

    public BankTransactionClient(int n) {
        this(n, 10, 100000);
    }

    @Override
    public void init(Connection connection) throws SQLException {
        this.conn = connection;
        connection.setAutoCommit(false);
        this.updateAccount = connection.prepareStatement("UPDATE ACCOUNTS SET ACCOUNT_BALANCE = ACCOUNT_BALANCE + ? WHERE ACCOUNT_ID = ?");
        this.updateHistory = connection.prepareStatement("INSERT INTO HISTORY(ACCOUNT_ID, TELLER_ID, BRANCH_ID, AMOUNT, TIME_STAMP, EXTRA_DATA) VALUES (?, ?, ?, ?, CURRENT_TIMESTAMP, '" + BankAccountFiller.createJunk(18) + "')");
        this.updateTeller = connection.prepareStatement("UPDATE TELLERS SET TELLER_BALANCE = TELLER_BALANCE + ? WHERE TELLER_ID = ?");
        this.updateBranch = connection.prepareStatement("UPDATE BRANCHES SET BRANCH_BALANCE = BRANCH_BALANCE + ? WHERE BRANCH_ID = ?");
        this.retrieveAccountBalance = connection.prepareStatement("SELECT ACCOUNT_BALANCE FROM ACCOUNTS WHERE ACCOUNT_ID = ?");
    }

    @Override
    public void doWork() throws SQLException {
        int n = this.fetchTellerId();
        int n2 = this.fetchBranchId(n);
        int n3 = this.fetchAccountId(n2);
        int n4 = this.fetchDelta();
        this.updateAccount.setInt(1, n4);
        this.updateAccount.setInt(2, n3);
        this.updateAccount.executeUpdate();
        this.updateHistory.setInt(1, n3);
        this.updateHistory.setInt(2, n);
        this.updateHistory.setInt(3, n2);
        this.updateHistory.setInt(4, n4);
        this.updateHistory.executeUpdate();
        this.updateTeller.setInt(1, n4);
        this.updateTeller.setInt(2, n);
        this.updateTeller.executeUpdate();
        this.updateBranch.setInt(1, n4);
        this.updateBranch.setInt(2, n2);
        this.updateBranch.executeUpdate();
        this.retrieveAccountBalance.setInt(1, n3);
        ResultSet resultSet = this.retrieveAccountBalance.executeQuery();
        resultSet.next();
        resultSet.getString(1);
        resultSet.close();
        this.conn.commit();
    }

    @Override
    public void printReport(PrintStream printStream) {
    }

    private int fetchTellerId() {
        return this.random.nextInt(this.tellersPerBranch * this.branches);
    }

    private int fetchBranchId(int n) {
        return n / this.tellersPerBranch;
    }

    private int fetchAccountId(int n) {
        int n2;
        if (this.branches == 1 || this.random.nextFloat() < 0.85f) {
            n2 = n;
        } else {
            n2 = this.random.nextInt(this.branches - 1);
            if (n2 >= n) {
                ++n2;
            }
        }
        return n2 * this.accountsPerBranch + this.random.nextInt(this.accountsPerBranch);
    }

    private int fetchDelta() {
        return this.random.nextInt(199999) - 99999;
    }
}

