/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.TimeZoneTestSetup;

public class DaylightSavingTest
extends BaseJDBCTestCase {
    public DaylightSavingTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TimeZoneTestSetup(TestConfiguration.defaultSuite(DaylightSavingTest.class), "America/Chicago");
    }

    public void testConversionToGMTAroundDSTChange() throws SQLException {
        int n;
        int n2;
        Date date;
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE DERBY4582(ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY, TS TIMESTAMP, T TIME, D DATE, T2 TIME, D2 DATE, TS_STR VARCHAR(100), T_STR VARCHAR(100), D_STR VARCHAR(100))");
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar2.set(1, 2010);
        calendar2.set(2, 2);
        calendar2.set(5, 12);
        calendar2.set(11, 0);
        calendar2.set(12, 1);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        Timestamp[] timestampArray = new Timestamp[96];
        Time[] timeArray = new Time[timestampArray.length];
        java.sql.Date[] dateArray = new java.sql.Date[timestampArray.length];
        for (int i = 0; i < timestampArray.length; ++i) {
            long l = calendar2.getTimeInMillis();
            timestampArray[i] = new Timestamp(l);
            timeArray[i] = new Time(l);
            dateArray[i] = new java.sql.Date(l);
            calendar2.setTimeInMillis(l + 3600000L);
        }
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO DERBY4582 (TS, T, D, T2, D2, TS_STR, T_STR, D_STR) VALUES (?,?,?,?,?,?,?,?)");
        for (int i = 0; i < timestampArray.length; ++i) {
            Timestamp timestamp = timestampArray[i];
            Time time = timeArray[i];
            date = dateArray[i];
            preparedStatement.setTimestamp(1, timestamp, calendar2);
            preparedStatement.setTime(2, time, calendar2);
            preparedStatement.setDate(3, (java.sql.Date)date, calendar2);
            preparedStatement.setTimestamp(4, timestamp, calendar2);
            preparedStatement.setTimestamp(5, timestamp, calendar2);
            preparedStatement.setTimestamp(6, timestamp, calendar2);
            preparedStatement.setTime(7, time, calendar2);
            preparedStatement.setDate(8, (java.sql.Date)date, calendar2);
            preparedStatement.execute();
        }
        ResultSet resultSet = statement.executeQuery("SELECT * FROM DERBY4582 ORDER BY ID");
        for (n2 = 0; n2 < timestampArray.length; ++n2) {
            DaylightSavingTest.assertTrue((String)("found only " + n2 + " rows"), (boolean)resultSet.next());
            DaylightSavingTest.assertEquals((String)"ID", (int)(n2 + 1), (int)resultSet.getInt(1));
            DaylightSavingTest.assertEquals((String)"TS", (Object)timestampArray[n2], (Object)resultSet.getTimestamp(2, calendar2));
            DaylightSavingTest.assertEquals("T", DaylightSavingTest.stripDate(timeArray[n2], calendar2), resultSet.getTime(3, calendar2));
            DaylightSavingTest.assertEquals((String)"D", (Object)DaylightSavingTest.stripTime(dateArray[n2], calendar2), (Object)resultSet.getDate(4, calendar2));
            DaylightSavingTest.assertEquals("T2", DaylightSavingTest.stripDate(timeArray[n2], calendar2), resultSet.getTime(5, calendar2));
            DaylightSavingTest.assertEquals((String)"D2", (Object)DaylightSavingTest.stripTime(dateArray[n2], calendar2), (Object)resultSet.getDate(6, calendar2));
            DaylightSavingTest.assertEquals((String)"TS_STR", (Object)timestampArray[n2], (Object)resultSet.getTimestamp(7, calendar2));
            DaylightSavingTest.assertEquals("T_STR", DaylightSavingTest.stripDate(timeArray[n2], calendar2), resultSet.getTime(8, calendar2));
            DaylightSavingTest.assertEquals((String)"D_STR", (Object)DaylightSavingTest.stripTime(dateArray[n2], calendar2), (Object)resultSet.getDate(9, calendar2));
        }
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("SELECT ID,T,D,TS,TS FROM DERBY4582 ORDER BY ID");
        for (n2 = 0; n2 < timestampArray.length; ++n2) {
            DaylightSavingTest.assertTrue((String)("found only " + n2 + " rows"), (boolean)resultSet.next());
            DaylightSavingTest.assertEquals((String)"ID", (int)(n2 + 1), (int)resultSet.getInt(1));
            DaylightSavingTest.assertEquals((String)"TIME AS TIMESTAMP", (Object)DaylightSavingTest.timeToTimestamp(DaylightSavingTest.stripDate(timeArray[n2], calendar2), calendar2), (Object)resultSet.getTimestamp(2, calendar2));
            DaylightSavingTest.assertEquals((String)"DATE AS TIMESTAMP", (Object)DaylightSavingTest.dateToTimestamp(DaylightSavingTest.stripTime(dateArray[n2], calendar2), calendar2), (Object)resultSet.getTimestamp(3, calendar2));
            DaylightSavingTest.assertEquals("TIMESTAMP AS TIME", DaylightSavingTest.stripDate(timestampArray[n2], calendar2), resultSet.getTime(4, calendar2));
            DaylightSavingTest.assertEquals((String)"TIMESTAMP AS DATE", (Object)DaylightSavingTest.stripTime(timestampArray[n2], calendar2), (Object)resultSet.getDate(5, calendar2));
        }
        JDBC.assertEmpty(resultSet);
        Statement statement2 = this.createStatement(1003, 1008);
        resultSet = statement2.executeQuery("SELECT TS, T, D FROM DERBY4582");
        for (n = 0; n < timestampArray.length; ++n) {
            DaylightSavingTest.assertTrue((String)("found only " + n + " rows"), (boolean)resultSet.next());
            date = timestampArray[n];
            resultSet.updateTimestamp(1, (Timestamp)date);
            DaylightSavingTest.assertEquals((String)"TS (default calendar)", (Object)date, (Object)resultSet.getTimestamp(1));
            Timestamp timestamp = resultSet.getTimestamp(1, calendar2);
            calendar2.clear();
            calendar2.setTime(timestamp);
            calendar.clear();
            calendar.setTime(date);
            DaylightSavingTest.assertEquals((String)"TS.YEAR", (int)calendar.get(1), (int)calendar2.get(1));
            DaylightSavingTest.assertEquals((String)"TS.MONTH", (int)calendar.get(2), (int)calendar2.get(2));
            DaylightSavingTest.assertEquals((String)"TS.DATE", (int)calendar.get(5), (int)calendar2.get(5));
            DaylightSavingTest.assertEquals((String)"TS.HOURS", (int)calendar.get(11), (int)calendar2.get(11));
            DaylightSavingTest.assertEquals((String)"TS.MINUTES", (int)calendar.get(12), (int)calendar2.get(12));
            DaylightSavingTest.assertEquals((String)"TS.SECONDS", (int)calendar.get(13), (int)calendar2.get(13));
            DaylightSavingTest.assertEquals((String)"TS.NANOS", (int)((Timestamp)date).getNanos(), (int)timestamp.getNanos());
            Time time = timeArray[n];
            resultSet.updateTime(2, time);
            DaylightSavingTest.assertEquals("T (default calendar)", DaylightSavingTest.stripDate(time, calendar), resultSet.getTime(2));
            Time time2 = resultSet.getTime(2, calendar2);
            calendar2.clear();
            calendar2.setTime(time2);
            calendar.clear();
            calendar.setTime(time);
            DaylightSavingTest.assertEquals((String)"T.HOURS", (int)calendar.get(11), (int)calendar2.get(11));
            DaylightSavingTest.assertEquals((String)"T.MINUTES", (int)calendar.get(12), (int)calendar2.get(12));
            DaylightSavingTest.assertEquals((String)"T.SECONDS", (int)calendar.get(13), (int)calendar2.get(13));
            java.sql.Date date2 = dateArray[n];
            resultSet.updateDate(3, date2);
            DaylightSavingTest.assertEquals((String)"D (default calendar)", (Object)DaylightSavingTest.stripTime(date2, calendar), (Object)resultSet.getDate(3));
            java.sql.Date date3 = resultSet.getDate(3, calendar2);
            calendar2.clear();
            calendar2.setTime(date3);
            calendar.clear();
            calendar.setTime(date2);
            DaylightSavingTest.assertEquals((String)"D.YEAR", (int)calendar.get(1), (int)calendar2.get(1));
            DaylightSavingTest.assertEquals((String)"D.MONTH", (int)calendar.get(2), (int)calendar2.get(2));
            DaylightSavingTest.assertEquals((String)"D.DATE", (int)calendar.get(5), (int)calendar2.get(5));
            resultSet.updateRow();
        }
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("SELECT TS, T, D FROM DERBY4582 ORDER BY TS");
        for (n = 0; n < timestampArray.length; ++n) {
            DaylightSavingTest.assertTrue((String)("found only " + n + " rows"), (boolean)resultSet.next());
            DaylightSavingTest.assertEquals((String)"TS", (Object)timestampArray[n], (Object)resultSet.getTimestamp(1));
            DaylightSavingTest.assertEquals("T", DaylightSavingTest.stripDate(timeArray[n], calendar), resultSet.getTime(2));
            DaylightSavingTest.assertEquals((String)"D", (Object)DaylightSavingTest.stripTime(dateArray[n], calendar), (Object)resultSet.getDate(3));
        }
        JDBC.assertEmpty(resultSet);
    }

    private static Time stripDate(Date date, Calendar calendar) {
        calendar.clear();
        calendar.setTime(date);
        calendar.set(1970, 0, 1);
        return new Time(calendar.getTimeInMillis());
    }

    private static java.sql.Date stripTime(Date date, Calendar calendar) {
        calendar.clear();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new java.sql.Date(calendar.getTimeInMillis());
    }

    private static Timestamp timeToTimestamp(Time time, Calendar calendar) {
        calendar.clear();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        calendar.clear();
        calendar.setTime(time);
        calendar.set(n, n2, n3);
        return new Timestamp(calendar.getTimeInMillis());
    }

    private static Timestamp dateToTimestamp(java.sql.Date date, Calendar calendar) {
        calendar.clear();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }
}

