/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class ShutdownMaster
extends BaseJDBCTestCase {
    private static ReplicationRun repRun = new ReplicationRun("ShutdownMaster");
    static String jvmVersion = null;
    static String derbyVersion = null;
    static String masterServerHost = null;
    static int masterServerPort = -1;
    static String masterDatabasePath = null;
    static String slaveServerHost = null;
    static int slaveServerPort = -1;
    static String slaveDatabasePath = null;

    public ShutdownMaster(String string) {
        super(string);
    }

    static void setEnv() throws Exception {
        repRun.initEnvironment();
        masterServerHost = ReplicationRun.masterServerHost;
        masterServerPort = ReplicationRun.masterServerPort;
        slaveServerHost = ReplicationRun.slaveServerHost;
        slaveServerPort = ReplicationRun.slaveServerPort;
        jvmVersion = ReplicationRun.masterJvmVersion;
        derbyVersion = ReplicationRun.derbyMasterVersion;
        masterDatabasePath = ReplicationRun.masterDatabasePath;
        slaveDatabasePath = ReplicationRun.slaveDatabasePath;
    }

    void shutdown(String string, boolean bl, boolean bl2) throws SQLException, IOException, InterruptedException {
        System.out.println("**** ShutdownMaster.shutdown() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName() + " url: " + string + " dbOnly: " + bl + " killServer: " + bl2);
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table t (i integer primary key, vc varchar(20))");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values (?,?)");
        boolean bl3 = false;
        for (int i = 0; i < 1000; ++i) {
            String string2;
            String string3;
            int n;
            try {
                preparedStatement.setInt(1, i);
                preparedStatement.setString(2, "i" + i);
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                n = sQLException.getErrorCode();
                string3 = sQLException.getMessage();
                string2 = sQLException.getSQLState();
                System.out.println("execute Got SQLException: " + n + " " + string2 + " " + string3);
                if (bl3 && n == 40000 && string2.equalsIgnoreCase("08006")) {
                    System.out.println("As expected - connection terminated. Quit.");
                    return;
                }
                throw sQLException;
            }
            System.out.println("i: " + i);
            if (i != 500) continue;
            if (bl2) {
                repRun.killMaster(masterServerHost, masterServerPort);
                bl3 = true;
                continue;
            }
            if (string == null) {
                System.out.println("**** stopServer: " + masterServerHost + ":" + masterServerPort);
                repRun.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
                bl3 = true;
                continue;
            }
            System.out.println("**** DriverManager.getConnection(\"" + string + ";shutdown=true\");");
            try {
                DriverManager.getConnection(string + ";shutdown=true");
                continue;
            }
            catch (SQLException sQLException) {
                n = sQLException.getErrorCode();
                string3 = sQLException.getMessage();
                string2 = sQLException.getSQLState();
                String string4 = bl ? "08006" : "XJ015";
                int n2 = bl ? 45000 : 50000;
                System.out.println("shutdown Got SQLException: " + n + " " + string2 + " " + string3);
                if (n == n2 && string2.equalsIgnoreCase(string4)) {
                    System.out.println("As expected.");
                    bl3 = true;
                    continue;
                }
                throw sQLException;
            }
        }
        ShutdownMaster.assertTrue((String)"Should never reach this point in the ShutdownMaster test with PoC V2d!", (boolean)false);
        ResultSet resultSet = statement.executeQuery("select count(*) from t");
        resultSet.next();
        int n = resultSet.getInt(1);
        System.out.println("count: " + n);
    }
}

