/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class LogDeviceTest {
    private static final String TEST_DATABASE_NAME = "wombat";
    private static final String TEST_DATABASE_NAME1 = "wombat1";
    private static final String TEST_TABLE_NAME = "emp";
    private static final String LOG_PATH = "extinout/logDeviceTest_c1";
    private static final String LOG_PATH1 = "extinout/logDeviceTest_c2";

    public static void main(String[] argv) throws Throwable {
        LogDeviceTest test = new LogDeviceTest();
        ij.getPropertyArg((String[])argv);
        try {
            test.runTest();
        }
        catch (SQLException sqle) {
            LogDeviceTest.dumpSQLException(sqle);
        }
    }

    private String getFullPath(String path) throws IOException {
        File f = new File(path);
        return f.getCanonicalPath();
    }

    private boolean createDir(String path) {
        File f = new File(path);
        return f.mkdirs();
    }

    private void runTest() throws Exception {
        this.logMessage("Begin Log Device Test");
        String connAttr = "create=true;logDevice=" + this.getFullPath(LOG_PATH);
        Connection conn = TestUtil.getConnection(TEST_DATABASE_NAME, connAttr);
        conn.setAutoCommit(false);
        this.createTable(conn, TEST_TABLE_NAME);
        conn.commit();
        this.insert(conn, TEST_TABLE_NAME, 100);
        conn.commit();
        this.insert(conn, TEST_TABLE_NAME, 100);
        conn.rollback();
        this.shutdown(TEST_DATABASE_NAME);
        try {
            conn = TestUtil.getConnection(TEST_DATABASE_NAME1, connAttr);
        }
        catch (SQLException se) {
            SQLException nse = se.getNextException();
            if (nse != null) {
                if (nse.getSQLState().equals("XSLAT")) {
                    System.out.println("Failed with Expected error:" + nse.getSQLState());
                } else {
                    LogDeviceTest.dumpSQLException(se);
                }
            }
            LogDeviceTest.dumpSQLException(se);
        }
        this.createDir(this.getFullPath(LOG_PATH1) + File.separator + "log");
        connAttr = "create=true;logDevice=" + this.getFullPath(LOG_PATH1);
        conn = TestUtil.getConnection(TEST_DATABASE_NAME1, connAttr);
        conn.setAutoCommit(false);
        this.createTable(conn, TEST_TABLE_NAME);
        conn.commit();
        this.insert(conn, TEST_TABLE_NAME, 100);
        this.shutdown(TEST_DATABASE_NAME1);
        conn = TestUtil.getConnection(TEST_DATABASE_NAME1, null);
        this.logMessage("End log device Test");
    }

    private void shutdown(String dbName) {
        try {
            TestUtil.getConnection(dbName, "shutdown=true");
        }
        catch (SQLException se) {
            if (se.getSQLState() != null && se.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            }
            LogDeviceTest.dumpSQLException(se);
        }
    }

    private void logMessage(String str) {
        System.out.println(str);
    }

    private static void dumpSQLException(SQLException sqle) {
        JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
        sqle.printStackTrace(System.out);
    }

    private void insert(Connection conn, String tableName, int rowCount) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("INSERT INTO " + tableName + " VALUES(?,?,?)");
        for (int i = 0; i < rowCount; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "skywalker" + i);
            ps.setFloat(3, i * 2000);
            ps.executeUpdate();
        }
        ps.close();
    }

    private void createTable(Connection conn, String tableName) throws SQLException {
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE TABLE " + tableName + "(id INT,name CHAR(200),salary float)");
        s.executeUpdate("create index " + tableName + "_id_idx on " + tableName + "(id)");
        s.close();
    }
}

