/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.derby.vti.StringColumnVTI;

public abstract class EnumeratorTableFunction
extends StringColumnVTI {
    private Enumeration _enumeration;
    protected String[] _row;

    public EnumeratorTableFunction(String[] stringArray, Object object) throws SQLException {
        super(stringArray);
        this.setEnumeration(object);
    }

    protected EnumeratorTableFunction(String[] stringArray) {
        super(stringArray);
    }

    protected void setEnumeration(Object object) throws SQLException {
        if (object == null) {
            throw new SQLException("Bad argument. Null collections not allowed.");
        }
        if (object instanceof Enumeration) {
            this._enumeration = (Enumeration)object;
        } else if (object instanceof Iterator) {
            this._enumeration = new Enumerator((Iterator)object);
        } else if (object instanceof Iterable) {
            this._enumeration = new Enumerator(((Iterable)object).iterator());
        } else if (object.getClass().isArray()) {
            this._enumeration = new ArrayEnumerator(object);
        } else {
            throw new SQLException("Bad argument. Argument must be an Enumeration, Iterator, Iterable, or array.");
        }
        this._row = new String[this.getColumnCount()];
    }

    public abstract String[] makeRow(Object var1) throws SQLException;

    protected String getRawColumn(int n) throws SQLException {
        return this._row[n - 1];
    }

    public boolean next() throws SQLException {
        if (this._enumeration == null) {
            return false;
        }
        if (!this._enumeration.hasMoreElements()) {
            return false;
        }
        Object e = this._enumeration.nextElement();
        this._row = this.makeRow(e);
        return true;
    }

    public void close() {
        this._enumeration = null;
        this._row = null;
    }

    public final class Enumerator
    implements Enumeration {
        private Iterator _iterator;

        public Enumerator(Iterator iterator) {
            this._iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this._iterator.hasNext();
        }

        public Object nextElement() {
            return this._iterator.next();
        }
    }

    public final class ArrayEnumerator
    implements Enumeration {
        Object _array;
        int _length;
        int _idx;
        Object _nextObject;

        public ArrayEnumerator(Object object) {
            this._array = object;
            this._length = Array.getLength(object);
            this._idx = 0;
            this.advance();
        }

        @Override
        public boolean hasMoreElements() {
            return this._nextObject != null;
        }

        public Object nextElement() {
            Object object = this._nextObject;
            this.advance();
            return object;
        }

        private void advance() {
            do {
                if (this._idx >= this._length) {
                    this._nextObject = null;
                    break;
                }
                this._nextObject = Array.get(this._array, this._idx++);
            } while (this._nextObject == null);
        }
    }
}

