/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.TimeZoneTestSetup;

public class Derby5866TriggerOrderTest
extends BaseJDBCTestCase {
    private static final TimeZone TIMEZONE = TimeZone.getTimeZone("Europe/Oslo");
    private static final String OVERRIDE_TIME_PROP = "derby.debug.overrideTriggerCreationTimestamp";

    public Derby5866TriggerOrderTest(String string) {
        super(string);
    }

    public static Test suite() {
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(Derby5866TriggerOrderTest.class));
        return new TimeZoneTestSetup((Test)cleanDatabaseTestSetup, TIMEZONE);
    }

    @Override
    protected void tearDown() throws Exception {
        TimeZoneTestSetup.setDefault(TIMEZONE);
        Derby5866TriggerOrderTest.removeSystemProperty(OVERRIDE_TIME_PROP);
        super.tearDown();
    }

    public void testTimeZoneChange() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t1(x int)");
        statement.execute("create table t2(x int generated always as identity, y varchar(128))");
        statement.execute("create trigger tr1 after insert on t1 insert into t2(y) values 'I won! :)'");
        TimeZoneTestSetup.setDefault(TimeZone.getTimeZone("GMT-8:00"));
        statement.execute("create trigger tr2 after insert on t1 insert into t2(y) values 'I lost... :('");
        statement.execute("insert into t1 values 1");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t2 order by x"), new String[][]{{"1", "I won! :)"}, {"2", "I lost... :("}});
    }

    public void testEqualTimestamps() throws SQLException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.testSpecificTimestamps(timestamp, timestamp, timestamp);
    }

    public void testReversedTimestamps() throws SQLException {
        long l = System.currentTimeMillis();
        this.testSpecificTimestamps(new Timestamp(l), new Timestamp(l - 1L), new Timestamp(l - 2L), new Timestamp(l - 3L));
    }

    public void testCrossDaylightSaving() throws SQLException {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(2014, 2, 30, 0, 45, 0);
        this.testSpecificTimestamps(new Timestamp(calendar.getTimeInMillis()), new Timestamp(calendar.getTimeInMillis() + 1800000L));
        calendar.clear();
        calendar.set(2014, 9, 26, 0, 45, 0);
        this.testSpecificTimestamps(new Timestamp(calendar.getTimeInMillis()), new Timestamp(calendar.getTimeInMillis() + 1800000L));
        calendar.clear();
        calendar.set(2014, 2, 30, 0, 59, 59);
        calendar.set(14, 999);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        this.testSpecificTimestamps(timestamp, timestamp, timestamp);
        calendar.clear();
        calendar.set(2014, 9, 26, 0, 59, 59);
        calendar.set(14, 999);
        timestamp = new Timestamp(calendar.getTimeInMillis());
        this.testSpecificTimestamps(timestamp, timestamp, timestamp);
    }

    public void testPreEpoch() throws SQLException {
        Timestamp timestamp = new Timestamp(-86400000L);
        this.testSpecificTimestamps(timestamp, timestamp, timestamp);
        timestamp.setNanos(123000000);
        this.testSpecificTimestamps(timestamp, timestamp, timestamp);
        timestamp.setNanos(567000000);
        this.testSpecificTimestamps(timestamp, timestamp, timestamp);
        timestamp.setNanos(999000000);
        this.testSpecificTimestamps(timestamp, timestamp, timestamp);
    }

    private void testSpecificTimestamps(Timestamp ... timestampArray) throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t1(x int)");
        statement.execute("create table t2(x int generated always as identity, y int)");
        for (int i = 0; i < timestampArray.length; ++i) {
            this.overrideTriggerCreationTime(timestampArray[i]);
            statement.execute("create trigger tr" + (i + 1) + " after insert on t1 insert into t2(y) values " + (i + 1));
        }
        statement.execute("insert into t1 values 1");
        ResultSet resultSet = statement.executeQuery("select * from t2 order by x");
        for (int i = 1; i <= timestampArray.length; ++i) {
            if (resultSet.next()) {
                Derby5866TriggerOrderTest.assertEquals((String)"X", (int)i, (int)resultSet.getInt("X"));
                Derby5866TriggerOrderTest.assertEquals((String)"Y", (int)i, (int)resultSet.getInt("Y"));
                continue;
            }
            Derby5866TriggerOrderTest.fail((String)("Row " + i + " was missing"));
        }
        JDBC.assertEmpty(resultSet);
        PreparedStatement preparedStatement = this.prepareStatement("select * from sys.sysschemas natural join sys.systriggers where schemaname = ? and triggername like 'TR%' order by creationtimestamp");
        preparedStatement.setString(1, this.getTestConfiguration().getUserName());
        resultSet = preparedStatement.executeQuery();
        Timestamp timestamp = null;
        for (int i = 1; i <= timestampArray.length; ++i) {
            Derby5866TriggerOrderTest.assertTrue((boolean)resultSet.next());
            Derby5866TriggerOrderTest.assertEquals((String)("TR" + i), (String)resultSet.getString("TRIGGERNAME"));
            Timestamp timestamp2 = resultSet.getTimestamp("CREATIONTIMESTAMP");
            Derby5866TriggerOrderTest.assertNotNull((Object)timestamp2);
            if (timestamp != null && !timestamp.before(timestamp2)) {
                Derby5866TriggerOrderTest.fail((String)(String.valueOf(timestamp) + " expected to be before " + String.valueOf(timestamp2)));
            }
            timestamp = timestamp2;
        }
        JDBC.assertEmpty(resultSet);
        this.rollback();
    }

    private void overrideTriggerCreationTime(Timestamp timestamp) {
        Derby5866TriggerOrderTest.setSystemProperty(OVERRIDE_TIME_PROP, String.valueOf(timestamp.getTime()));
    }
}

