/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ParseException;
import org.apache.derby.impl.tools.ij.ijFatalException;
import org.apache.derby.impl.tools.ij.mtGrammar;
import org.apache.derby.impl.tools.ij.mtTestCase;
import org.apache.derby.impl.tools.ij.mtTestSuite;
import org.apache.derby.impl.tools.ij.mtTester;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class MultiTest {
    private static final int MAX_WAIT_FOR_COMPLETION = 180;
    private static mtTestSuite suite;
    private static LocalizedOutput log;
    private static String inputDir;
    private static String outputDir;
    private static String testName;

    public static void syntax() {
        System.out.println("Syntax:\n\t <file>\t- the cmd file\n\t[-o <dir>]\t-the output directory\n\t[-i <dir>]\t-the input directory");
    }

    public static void main(String[] args) throws IOException, ParseException, FileNotFoundException {
        int i;
        BufferedInputStream in;
        String cmdFile = util.getFileArg((String[])args);
        if (cmdFile == null) {
            MultiTest.syntax();
            return;
        }
        LocalizedResource.getInstance();
        testName = MultiTest.getTestName(cmdFile);
        inputDir = util.getArg((String)"-i", (String[])args);
        outputDir = util.getArg((String)"-o", (String[])args);
        String cmdFilePath = inputDir != null && cmdFile.indexOf("/") == -1 ? inputDir + "/" + cmdFile : cmdFile;
        try {
            in = new BufferedInputStream(new FileInputStream(cmdFilePath), 2048);
        }
        catch (FileNotFoundException e) {
            System.out.println("MultiTest ERROR: config file not found: " + cmdFile);
            return;
        }
        mtGrammar parser = new mtGrammar((InputStream)in);
        suite = parser.grammarStatement();
        suite.setRoot(inputDir);
        suite.init();
        log = MultiTest.openFile(outputDir, testName + ".log");
        try {
            MultiTest.seqRunCases(suite.getInitCases(), "initialization", inputDir, outputDir);
        }
        catch (ijFatalException e) {
            System.exit(1);
        }
        int max = suite.getNumThreads();
        System.out.println("...running with " + max + " threads");
        mtTester[] testers = new mtTester[max];
        for (i = 0; i < max; ++i) {
            String tester = "Tester" + (i + 1);
            try {
                LocalizedOutput out = MultiTest.openFile(outputDir, tester + ".out");
                testers[i] = new mtTester(tester, suite, out, log);
                continue;
            }
            catch (IOException e) {
                System.out.println("MultiTest ERROR: unable open output file " + String.valueOf(e));
                return;
            }
        }
        long duration = MultiTest.execTesters(testers);
        log.println("");
        log.println("test ran " + duration + " ms");
        log.println("total memory is " + Runtime.getRuntime().totalMemory());
        log.println("free memory  is " + Runtime.getRuntime().freeMemory());
        for (i = 0; i < max; ++i) {
            if (testers[i].noFailure()) {
                log.println("Deleting Tester" + (i + 1) + ".out(" + outputDir + ")");
                File out = new File(outputDir, "Tester" + (i + 1) + ".out");
                out.delete();
                continue;
            }
            log.println("Tester" + (i + 1) + " failed.");
        }
        System.exit(0);
    }

    private static long execTesters(mtTester[] testers) throws FileNotFoundException, IOException {
        int i;
        boolean interrupted = false;
        boolean allWereAlive = true;
        long duration = 0L;
        int max = testers.length;
        ThreadGroup tg = new ThreadGroup("workers");
        long start = System.currentTimeMillis();
        long runTime = suite.getTimeMillis();
        System.out.println("...running duration " + String.valueOf(suite.getTime()));
        byte[] extraMemory = new byte[4096];
        Thread[] threads = new Thread[max];
        for (i = 0; i < max; ++i) {
            threads[i] = new Thread(tg, (Runnable)testers[i]);
            threads[i].start();
        }
        while ((duration = System.currentTimeMillis() - start) < runTime && (allWereAlive = MultiTest.allAlive(threads)) && !interrupted) {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        System.out.println("...stopping testers");
        extraMemory = null;
        System.gc();
        for (i = 0; i < testers.length; ++i) {
            testers[i].stop();
        }
        System.out.println("...waiting for testers to complete");
        for (i = 0; i < 180; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("...Unexpected InterrupedException: " + String.valueOf(e));
            }
            if (MultiTest.allDead(threads)) break;
        }
        if (i == 180) {
            log.println("WARNING: testers didn't die willingly, so I'm going to kill 'em.");
            log.println("\tThis may result in connection resources that aren't cleaned up");
            log.println("\t(e.g. you may see problems in the final script run with deadlocks).");
        }
        TestUtil.dumpAllStackTracesIfSupported((PrintWriter)log);
        for (i = 0; i < 180 && !tg.isDestroyed(); ++i) {
            tg.interrupt();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                tg.destroy();
                break;
            }
            catch (IllegalThreadStateException e) {
                log.println("...waiting for ThreadGroup.interrupt() to work its magic");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (interrupted) {
            System.out.println("TEST CASE SUMMARY: run interrupted");
        } else if (!allWereAlive) {
            System.out.println("TEST CASE SUMMARY: abnormal termination due to error(s) -- see test log (./" + testName + "/" + testName + ".log) for details ");
        } else {
            System.out.println("TEST CASE SUMMARY: normal termination");
            if (i < 180) {
                try {
                    MultiTest.seqRunCases(suite.getFinalCases(), "last checks", inputDir, outputDir);
                }
                catch (ijFatalException e) {
                    System.out.println("...error running final test cases");
                }
            } else {
                System.out.println("...timed out trying to kill all testers,\n   skipping last scripts (if any).  NOTE: the\n   likely cause of the problem killing testers is\n   probably not enough VM memory OR test cases that\n   run for very long periods of time (so testers do not\n   have a chance to notice stop() requests");
            }
        }
        return duration;
    }

    public static boolean allAlive(Thread[] threads) {
        int i;
        for (i = 0; i < threads.length && threads[i].isAlive(); ++i) {
        }
        return i == threads.length;
    }

    public static boolean allDead(Thread[] threads) {
        int i;
        for (i = 0; i < threads.length && !threads[i].isAlive(); ++i) {
        }
        return i == threads.length;
    }

    private static LocalizedOutput openFile(String dir, String fileName) throws IOException {
        File file = new File(dir, fileName);
        return new LocalizedOutput((OutputStream)new FileOutputStream(file));
    }

    private static void seqRunCases(Vector cases, String descr, String inputDir, String outputDir) throws FileNotFoundException, IOException, ijFatalException {
        if (cases == null) {
            System.out.println("...no " + descr + " being performed");
            return;
        }
        Enumeration e = cases.elements();
        while (e.hasMoreElements()) {
            mtTestCase testCase = (mtTestCase)e.nextElement();
            String testName = testCase.getFile();
            System.out.println("...running " + descr + " via " + testName);
            String logFileName = testName.substring(0, testName.lastIndexOf(46));
            LocalizedOutput out = MultiTest.openFile(outputDir, logFileName + ".out");
            BufferedInputStream in = testCase.initialize(inputDir);
            testCase.runMe(log, out, in);
        }
    }

    private static String getTestName(String cmdFile) {
        int dotSpot;
        int slash = cmdFile.lastIndexOf("/");
        if (slash == -1) {
            slash = 0;
        }
        if ((dotSpot = cmdFile.lastIndexOf(".")) == -1) {
            dotSpot = cmdFile.length();
        }
        return cmdFile.substring(slash, dotSpot);
    }
}

