/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.DerbyDistribution;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.Utilities;

public class ReleaseRepository {
    private static final String OVERRIDE_HOME_PROP = "derbyTesting.oldReleasePath";
    private static final File DEFAULT_HOME;
    private static ReleaseRepository repos;
    private final File reposLocation;
    private List<DerbyDistribution> dists;

    public static synchronized ReleaseRepository getInstance() throws IOException {
        if (repos == null) {
            File location = DEFAULT_HOME;
            String overrideLoc = BaseTestCase.getSystemProperty(OVERRIDE_HOME_PROP);
            if (overrideLoc != null && !PrivilegedFileOpsForTests.exists(location = new File(overrideLoc))) {
                throw new IOException("the specified Derby release repository doesn't exist: " + location.getPath());
            }
            repos = new ReleaseRepository(location);
            repos.buildDistributionList();
        }
        return repos;
    }

    private ReleaseRepository(File reposLocation) {
        this.reposLocation = reposLocation;
    }

    public DerbyDistribution[] getDistributions() {
        DerbyDistribution[] clone = new DerbyDistribution[this.dists.size()];
        this.dists.toArray(clone);
        return clone;
    }

    private void buildDistributionList() {
        if (this.dists != null) {
            throw new IllegalStateException("repository already initialized");
        }
        File[] tmpCandDists = this.reposLocation.listFiles(new FileFilter(this){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isDirectory()) {
                    return false;
                }
                String name = pathname.getName();
                int dots = 0;
                for (int i = 0; i < name.length(); ++i) {
                    char ch = name.charAt(i);
                    if (ch == '.') {
                        ++dots;
                        continue;
                    }
                    if (Character.isDigit(ch)) continue;
                    return false;
                }
                return dots == 3;
            }
        });
        if (tmpCandDists == null) {
            tmpCandDists = new File[]{};
        }
        ReleaseRepository.traceit("{ReleaseRepository} " + tmpCandDists.length + " candidate releases at " + String.valueOf(this.reposLocation));
        this.dists = new ArrayList<DerbyDistribution>(tmpCandDists.length);
        for (int i = 0; i < tmpCandDists.length; ++i) {
            DerbyVersion version;
            File dir = tmpCandDists[i];
            String[] comp = Utilities.split(dir.getName(), '.');
            try {
                version = new DerbyVersion(Integer.parseInt(comp[0]), Integer.parseInt(comp[1]), Integer.parseInt(comp[2]), Integer.parseInt(comp[3]));
            }
            catch (NumberFormatException nfe) {
                ReleaseRepository.traceit("skipped distribution, invalid version: " + dir.getAbsolutePath());
                continue;
            }
            DerbyDistribution dist = DerbyDistribution.newInstance(version, dir);
            if (dist == null) {
                ReleaseRepository.traceit("skipped invalid distribution: " + dir.getAbsolutePath());
                continue;
            }
            this.dists.add(dist);
        }
        this.filterDistributions(this.dists);
        Collections.sort(this.dists);
        this.dists = Collections.unmodifiableList(this.dists);
    }

    private void filterDistributions(List dists) {
        DerbyVersion jsr169Support = DerbyVersion._10_1;
        DerbyVersion noPhoneMEBoot = DerbyVersion._10_3_1_4;
        for (int i = dists.size() - 1; i >= 0; --i) {
            DerbyDistribution dist = (DerbyDistribution)dists.get(i);
            DerbyVersion distVersion = dist.getVersion();
            if (JDBC.vmSupportsJSR169() && distVersion.lessThan(jsr169Support)) {
                ReleaseRepository.println("skipping " + distVersion.toString() + " on JSR169");
                dists.remove(i);
                continue;
            }
            if (!BaseTestCase.isPhoneME() || !noPhoneMEBoot.equals(distVersion)) continue;
            ReleaseRepository.println("skipping " + noPhoneMEBoot.toString() + " on CVM/phoneme");
            dists.remove(i);
        }
    }

    private static void traceit(String msg) {
        BaseTestCase.traceit(msg);
    }

    private static void println(String msg) {
        BaseTestCase.println(msg);
    }

    static {
        String home = BaseTestCase.getSystemProperty("user.home");
        DEFAULT_HOME = new File(home, ".derbyTestingReleases");
    }
}

