/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.utilXid;

public class XATestUtil {
    public static Xid getXid(int formatId, int b1, int b2) {
        int i;
        byte[] globalId = new byte[64];
        byte[] branchId = new byte[64];
        for (i = 0; i < globalId.length; ++i) {
            globalId[i] = (byte)(b1 + i);
        }
        for (i = 0; i < branchId.length; ++i) {
            branchId[i] = (byte)(b2 + i);
        }
        return XATestUtil.getXid(formatId, globalId, branchId);
    }

    public static Xid getXid(int formatId, byte[] globalId, byte[] branchId) {
        return new utilXid(formatId, globalId, branchId);
    }

    public static void dumpXAException(String tag, XAException xae) {
        System.out.println(tag + " : XAException - " + xae.getMessage() + " errorCode " + XATestUtil.errorCode(xae));
        xae.printStackTrace(System.out);
    }

    public static void createXATransactionView(Statement s) throws SQLException {
        s.execute("create view XATESTUTIL.global_xactTable as select  cast(global_xid as char(2)) as gxid, status,  CAST (case when first_instant is NULL then 'NULL' else 'false' end AS VARCHAR(8)) as readOnly,  cast (username as char(10)) as username, type  from syscs_diag.transaction_table");
    }

    public static void checkXATransactionView(Connection conn, String[][] expectedRows) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select * from XATESTUTIL.global_xactTable where gxid is not null order by gxid");
        if (expectedRows == null) {
            JDBC.assertEmpty(rs);
        } else {
            JDBC.assertUnorderedResultSet(rs, expectedRows);
        }
        rs.close();
    }

    public static String errorCode(XAException e) {
        return switch (e.errorCode) {
            case 7 -> "XA_HEURCOM ";
            case 8 -> "XA_HEURHAZ";
            case 5 -> "XA_HEURMIX";
            case 6 -> "XA_HEURRB ";
            case 9 -> "XA_NOMIGRATE ";
            case 101 -> "XA_RBCOMMFAIL ";
            case 102 -> "XA_RBDEADLOCK ";
            case 103 -> "XA_RBINTEGRITY ";
            case 104 -> "XA_RBOTHER ";
            case 105 -> "XA_RBPROTO ";
            case 100 -> "XA_RBROLLBACK ";
            case 106 -> "XA_RBTIMEOUT ";
            case 107 -> "XA_RBTRANSIENT ";
            case 3 -> "XA_RDONLY ";
            case 4 -> "XA_RETRY ";
            case -2 -> "XAER_ASYNC ";
            case -8 -> "XAER_DUPID ";
            case -5 -> "XAER_INVAL ";
            case -4 -> "XAER_NOTA ";
            case -9 -> "XAER_OUTSIDE ";
            case -6 -> "XAER_PROTO ";
            case -3 -> "XAER_RMERR ";
            case -7 -> "XAER_RMFAIL ";
            default -> Integer.toString(e.errorCode);
        };
    }
}

