/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.store.T_Compensation;

public class T_Undoable
implements Undoable {
    static final int REMOVE_NONE = 0;
    static final int REMOVE_ME = 1;
    static final int REMOVE_TO_ME = 2;
    protected ByteArray preparedLog;
    protected DynamicByteArrayOutputStream logBuffer;
    GlobalTransactionId tid = null;
    int tranSeq = -1;
    int recordSeq = -1;
    int removeWhat = 0;
    int LWMTranSeq = 0;
    boolean rollBack = true;
    int lastRecord = -1;
    boolean lastTransaction = false;
    int optionalDataLen;
    boolean verbose;

    public T_Undoable() {
    }

    T_Undoable(GlobalTransactionId tid, int tranSeq, int recordSeq, int removeWhat, int LWMTranSeq, boolean rollBack, int lastRecord, boolean lastTransaction, int optionalDataLen, boolean verbose) throws T_Fail {
        T_Fail.T_ASSERT(removeWhat >= 0 && removeWhat <= 2);
        T_Fail.T_ASSERT(rollBack == recordSeq < 0);
        T_Fail.T_ASSERT(rollBack == tranSeq < 0);
        this.tid = tid;
        this.tranSeq = tranSeq;
        this.recordSeq = recordSeq;
        this.removeWhat = removeWhat;
        this.LWMTranSeq = LWMTranSeq;
        this.rollBack = rollBack;
        this.lastRecord = lastRecord;
        this.lastTransaction = lastTransaction;
        this.optionalDataLen = optionalDataLen;
        this.verbose = verbose;
        try {
            this.writeOptionalDataToBuffer();
        }
        catch (IOException ioe) {
            throw T_Fail.exceptionFail(ioe);
        }
        catch (StandardException se) {
            throw T_Fail.exceptionFail(se);
        }
    }

    private void writeOptionalDataToBuffer() throws StandardException, IOException {
        int optionalDataLength;
        if (this.logBuffer == null) {
            this.logBuffer = new DynamicByteArrayOutputStream(1024);
        } else {
            this.logBuffer.reset();
        }
        int optionalDataStart = this.logBuffer.getPosition();
        SanityManager.ASSERT((optionalDataStart == 0 ? 1 : 0) != 0, (String)"Buffer for writing the optional data should start at position 0");
        if (this.optionalDataLen > 0) {
            byte[] buf = new byte[this.optionalDataLen];
            for (int ix = 0; ix < this.optionalDataLen; ++ix) {
                buf[ix] = (byte)ix;
            }
            this.logBuffer.write(buf);
        }
        if ((optionalDataLength = this.logBuffer.getPosition() - optionalDataStart) != this.logBuffer.getUsed()) {
            SanityManager.THROWASSERT((String)("wrong optional data length, optionalDataLength = " + optionalDataLength + ", logBuffer.getUsed() = " + this.logBuffer.getUsed()));
        }
        this.logBuffer.setPosition(optionalDataStart);
        this.preparedLog = new ByteArray(this.logBuffer.getByteArray(), optionalDataStart, optionalDataLength);
    }

    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) {
        if (this.verbose) {
            System.out.println("Loggable.doMe(" + this.toString() + ")");
        }
    }

    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    public boolean needsRedo(Transaction xact) {
        return false;
    }

    public void releaseResource(Transaction xact) {
    }

    public int group() {
        return 256;
    }

    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        return new T_Compensation();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((this.removeWhat >= 0 && this.removeWhat <= 2 ? 1 : 0) != 0);
        SanityManager.ASSERT((this.rollBack == this.recordSeq < 0 ? 1 : 0) != 0);
        SanityManager.ASSERT((this.rollBack == this.tranSeq < 0 ? 1 : 0) != 0);
        out.writeObject(this.tid);
        out.writeInt(this.tranSeq);
        out.writeInt(this.recordSeq);
        out.writeInt(this.removeWhat);
        out.writeInt(this.LWMTranSeq);
        out.writeBoolean(this.rollBack);
        out.writeInt(this.lastRecord);
        out.writeBoolean(this.lastTransaction);
        out.writeInt(this.optionalDataLen);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.tid = (GlobalTransactionId)in.readObject();
            this.tranSeq = in.readInt();
            this.recordSeq = in.readInt();
            this.removeWhat = in.readInt();
            this.LWMTranSeq = in.readInt();
            this.rollBack = in.readBoolean();
            this.lastRecord = in.readInt();
            this.lastTransaction = in.readBoolean();
            this.optionalDataLen = in.readInt();
        }
        catch (ClassCastException exception) {
            throw new StreamCorruptedException();
        }
    }

    public int getTypeFormatId() {
        return 2;
    }

    public String toString() {
        Object traceTid = "tid: null";
        if (this.tid != null) {
            traceTid = "tid: " + String.valueOf(this.tid);
        }
        return (String)traceTid + " tranSeq: " + this.tranSeq + " recordSeq: " + this.recordSeq + " " + (switch (this.removeWhat) {
            case 0 -> "REMOVE_NONE";
            case 1 -> "REMOVE_ME";
            case 2 -> "REMOVE_TO_ME";
            default -> "removeWhat: invalidValue";
        }) + " LWMTranSeq: " + this.LWMTranSeq + " rollback: " + this.rollBack + " lastRecord: " + this.lastRecord + " optionalDataLen: " + this.optionalDataLen + " lastTransaction: " + this.lastTransaction;
    }
}

