/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.apache.derby.tools.sysinfo;
import org.apache.derbyTesting.functionTests.tests.compatibility.ClientCompatibilityRunControl;
import org.apache.derbyTesting.functionTests.tests.compatibility.VersionedNetworkServerTestSetup;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DerbyDistribution;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class VersionCombinationConfigurator {
    private static final String EMB_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private final String name;
    private final boolean limitToTrunk;
    private final boolean newestFixpackOnly;
    private List<DerbyVersion> toInclude = Collections.emptyList();
    private List<DerbyVersion> toExclude = Collections.emptyList();

    public static VersionCombinationConfigurator getInstanceDevMATS() {
        return new VersionCombinationConfigurator("default/MATS configuration", true, true);
    }

    public static VersionCombinationConfigurator getInstanceDevFull() {
        return new VersionCombinationConfigurator("full development configuration", true, false);
    }

    public static VersionCombinationConfigurator getInstanceOld() {
        return new VersionCombinationConfigurator("historical configuration", false, true);
    }

    public static VersionCombinationConfigurator getInstanceOldFull() {
        return new VersionCombinationConfigurator("full historical configuration", false, false);
    }

    private VersionCombinationConfigurator(String name, boolean limitToTrunk, boolean newestFixpackOnly) {
        this.name = name;
        this.limitToTrunk = limitToTrunk;
        this.newestFixpackOnly = newestFixpackOnly;
    }

    public String getName() {
        return this.name;
    }

    public int addTests(BaseTestSuite suite) {
        int runsAdded = 0;
        List<DerbyDistribution> dists = this.filterVersions();
        DerbyDistribution newestDist = dists.get(0);
        String newestTestingCode = newestDist.getTestingClasspath();
        for (DerbyDistribution server : dists) {
            DerbyVersion serverVersion = server.getVersion();
            if (this.skipServerVersion(serverVersion)) continue;
            BaseTestSuite clientSuites = new BaseTestSuite("Client runs against server " + serverVersion.toString());
            for (DerbyDistribution client : dists) {
                if (this.limitToTrunk && !server.equals(newestDist) && !client.equals(newestDist)) continue;
                clientSuites.addTest((Test)new ClientCompatibilityRunControl(client, newestTestingCode, serverVersion));
                ++runsAdded;
            }
            VersionedNetworkServerTestSetup setup = new VersionedNetworkServerTestSetup((Test)clientSuites, server, newestTestingCode);
            suite.addTest((Test)setup);
        }
        return runsAdded;
    }

    public void setIncludes(List<DerbyVersion> toInclude) {
        if (toInclude != null) {
            this.toInclude = toInclude;
        }
    }

    public void setExcludes(List<DerbyVersion> toExclude) {
        if (toExclude != null) {
            this.toExclude = toExclude;
        }
    }

    private boolean skipServerVersion(DerbyVersion version) {
        if (!JDBC.vmSupportsJNDI() && version.lessThan(DerbyVersion._10_10)) {
            VersionCombinationConfigurator.println("Server version " + String.valueOf(version) + " was skipped because it requires JNDI to run.");
            return true;
        }
        return false;
    }

    private List<DerbyDistribution> filterVersions() {
        DerbyDistribution runningDist;
        DerbyDistribution[] dists = TestConfiguration.getReleaseRepository().getDistributions();
        List<DerbyDistribution> qualifiedDists = new ArrayList<DerbyDistribution>();
        for (DerbyDistribution dist : dists) {
            DerbyVersion version = dist.getVersion();
            if (!this.toInclude.isEmpty() && !this.toInclude.contains(version)) {
                VersionCombinationConfigurator.println(version.toString() + " not in include list");
                continue;
            }
            if (!this.toExclude.isEmpty() && this.toExclude.contains(version)) {
                VersionCombinationConfigurator.println(version.toString() + " in exclude list");
                continue;
            }
            qualifiedDists.add(dist);
        }
        if (qualifiedDists.isEmpty()) {
            VersionCombinationConfigurator.alarm("No old releases found for current configuration/environment");
        }
        if (!qualifiedDists.contains(runningDist = this.getRunningDistribution())) {
            qualifiedDists.add(runningDist);
        }
        qualifiedDists = this.sortAndFilterVersions(qualifiedDists);
        VersionCombinationConfigurator.println("--- " + qualifiedDists.size() + " distributions qualified");
        for (DerbyDistribution d : qualifiedDists) {
            VersionCombinationConfigurator.println(d.getVersion().toString());
        }
        return qualifiedDists;
    }

    private DerbyDistribution getRunningDistribution() {
        File libDir;
        try {
            libDir = this.getJarDirectoryOf(Class.forName(EMB_DRIVER));
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("missing Derby class: " + cnfe.getMessage(), cnfe);
        }
        File testingDir = this.getJarDirectoryOf(this.getClass());
        DerbyVersion version = DerbyVersion.parseVersionString(sysinfo.getVersionString());
        DerbyDistribution dist = DerbyDistribution.newInstance(version, libDir, testingDir);
        if (dist == null) {
            throw new IllegalStateException("failed to get running distribution (programming error?)");
        }
        return dist;
    }

    private File getJarDirectoryOf(Class clazz) {
        File jarPath = new File(VersionCombinationConfigurator.getClassURI(clazz));
        if (jarPath.isDirectory()) {
            throw new IllegalStateException("only running off jars is supported, currently running off directory " + String.valueOf(jarPath));
        }
        return jarPath.getParentFile();
    }

    private List<DerbyDistribution> sortAndFilterVersions(List<DerbyDistribution> distributions) {
        Collections.sort(distributions);
        Collections.reverse(distributions);
        DerbyDistribution prev = null;
        if (this.newestFixpackOnly) {
            ArrayList<DerbyDistribution> filtered = new ArrayList<DerbyDistribution>();
            for (DerbyDistribution d : distributions) {
                DerbyVersion ver = d.getVersion();
                if (prev == null || prev.getVersion().greaterMinorThan(ver)) {
                    filtered.add(d);
                } else {
                    VersionCombinationConfigurator.println("ignored " + ver.toString() + ", not the newest fixpack version for " + ver.getMajor() + "." + ver.getMinor());
                }
                prev = d;
            }
            distributions = filtered;
        }
        return distributions;
    }

    static URI getClassURI(Class cl) {
        CodeSource cs = cl.getProtectionDomain().getCodeSource();
        if (cs != null) {
            try {
                return cs.getLocation().toURI();
            }
            catch (URISyntaxException use) {
                BaseTestCase.alarm("bad URI: " + use.getMessage());
            }
        }
        return null;
    }

    private static void println(String msg) {
        BaseTestCase.println(msg);
    }

    private static void alarm(String msg) {
        BaseTestCase.alarm(msg);
    }
}

