/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LockInterruptTest
extends BaseJDBCTestCase {
    private static final String INTERRUPTED = "08000";
    private static final int LOCK_TIMEOUT = 60;
    private static final int DEADLOCK_TIMEOUT = 30;

    public LockInterruptTest(String name) {
        super(name);
    }

    public static Test suite() {
        Object test = TestConfiguration.embeddedSuite(LockInterruptTest.class);
        test = DatabasePropertyTestSetup.setLockTimeouts(test, 30, 60);
        Properties syspros = new Properties();
        syspros.put("derby.stream.error.extendedDiagSeverityLevel", "50000");
        test = new SystemPropertyTestSetup((Test)test, syspros, true);
        return new CleanDatabaseTestSetup((Test)test);
    }

    public void testInterruptLockWaiter() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table derby4711(x int)");
        this.commit();
        s.executeUpdate("lock table derby4711 in share mode");
        Waiter t1 = new Waiter(this);
        t1.start();
        Thread.sleep(2000L);
        Waiter t2 = new Waiter(this);
        t2.start();
        Thread.sleep(2000L);
        t1.interrupt();
        Thread.sleep(1000L);
        this.commit();
        t1.join();
        t2.join();
        Throwable e1 = t1.throwable;
        LockInterruptTest.assertNotNull((String)"First thread should fail because of interrupt", (Object)e1);
        if (!(e1 instanceof SQLException)) {
            LockInterruptTest.fail("Unexpected exception from first thread", e1);
        }
        LockInterruptTest.assertSQLState(INTERRUPTED, (SQLException)e1);
        if (LockInterruptTest.hasInterruptibleIO()) {
            LockInterruptTest.println("Skipping assert for t1.InterruptFlagSetOnThrow due  to interruptible IO.");
            LockInterruptTest.println("This is default on Solaris/Sun Java <= 1.6, use -XX:-UseVMInterruptibleIO if available.");
        } else {
            LockInterruptTest.assertTrue((boolean)t1.InterruptFlagSetOnThrow);
        }
        Throwable e2 = t2.throwable;
        if (e2 != null) {
            LockInterruptTest.fail("Unexpected exception from second thread", e2);
        }
        if (t2.elapsedTime >= 30000L) {
            LockInterruptTest.fail((String)("Second thread needed " + t2.elapsedTime + " ms to complete. Probably stuck waiting for a lock."));
        }
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from derby4711"), "1");
    }

    private class Waiter
    extends Thread {
        private final Connection c;
        private final PreparedStatement ps;
        private Throwable throwable;
        private boolean InterruptFlagSetOnThrow;
        private long elapsedTime;

        private Waiter(LockInterruptTest lockInterruptTest) throws SQLException {
            this.c = lockInterruptTest.openDefaultConnection();
            this.ps = this.c.prepareStatement("insert into derby4711 values 1");
        }

        @Override
        public void run() {
            try {
                this.runWaiter();
            }
            catch (Throwable t) {
                this.throwable = t;
                this.InterruptFlagSetOnThrow = Waiter.interrupted();
            }
        }

        private void runWaiter() throws SQLException {
            long start = System.currentTimeMillis();
            try {
                this.ps.executeUpdate();
            }
            finally {
                this.ps.close();
                this.c.close();
            }
            this.elapsedTime = System.currentTimeMillis() - start;
        }
    }
}

