/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;

public class JitTest {
    public static void main(String[] stringArray) {
        try {
            ij.getPropertyArg((String[])stringArray);
            Connection connection = ij.startJBMS();
            System.out.println("Start JitTest");
            JitTest.testDerby1327BadStartWithForAutoIncColumn(connection);
            connection.close();
        }
        catch (Exception exception) {
            System.out.println("FAIL -- unexpected exception " + String.valueOf(exception));
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)exception);
            exception.printStackTrace(System.out);
        }
    }

    public static void testDerby1327BadStartWithForAutoIncColumn(Connection connection) throws Exception {
        connection.setAutoCommit(false);
        Statement statement = null;
        JitTest.dropAllAppTables(connection);
        System.out.println("Create tables until we get a wrong Start with value");
        statement = connection.createStatement();
        int n = 0;
        String string = null;
        try {
            for (int i = 0; i < 200 && n == 0; ++i) {
                String string2 = "APP.MYTABLE" + i;
                string = "CREATE TABLE " + string2 + "  (ROLEID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 2, INCREMENT BY 1), INSTANCEID INTEGER, STATUS INTEGER, LOGICAL_STATE INTEGER, LSTATE_TSTAMP  TIMESTAMP, UPDT_TSTAMP TIMESTAMP, TSTAMP TIMESTAMP, CLALEVEL1_CLALEVEL2_CLALEVEL2ID VARCHAR(255),  CLALEVEL1_CLALEVEL2_CLALEVEL3_CLALEVEL3ID VARCHAR(255))";
                statement.executeUpdate(string);
                connection.commit();
                n = JitTest.checkBadStartWithCols(connection, 2);
                if (n <= 0) {
                    continue;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Failed on " + string);
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
        }
        if (n == 0) {
            System.out.println("PASS: All 200 tables created without problems");
            JitTest.dropAllAppTables(connection);
        }
        statement.close();
        connection.rollback();
    }

    private static int checkBadStartWithCols(Connection connection, int n) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(autoincrementstart) from sys.syscolumns c, sys.systables t, sys.sysschemas s WHERE t.schemaid =  s.schemaid and CAST(s.schemaname AS VARCHAR(128))= 'APP' and autoincrementstart > " + n);
        resultSet.next();
        int n2 = resultSet.getInt(1);
        if (n2 > 0) {
            System.out.println(n2 + " columns have bad START WITH VALUE");
        }
        resultSet.close();
        if (n2 > 0) {
            resultSet = statement.executeQuery("select tablename, columnname, autoincrementstart from sys.syscolumns c, sys.systables t, CAST(sys.sysschemas AS VARCHAR(128)) s WHERE t.schemaid = s.schemaid and CAST(s.schemaname AS VARCHAR(128)) = 'APP' and autoincrementstart > 2 ORDER BY tablename");
            while (resultSet.next()) {
                System.out.println("Unexpected start value: " + resultSet.getLong(3) + " on column " + resultSet.getString(1) + "(" + resultSet.getString(2) + ")");
            }
        }
        return n2;
    }

    private static void dropAllAppTables(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        Statement statement2 = connection.createStatement();
        System.out.println("Drop all tables in APP schema");
        ResultSet resultSet = statement.executeQuery("SELECT tablename from sys.systables t, sys.sysschemas s where t.schemaid = s.schemaid and CAST(s.schemaname AS VARCHAR(128)) = 'APP'");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            try {
                statement2.executeUpdate("DROP TABLE " + string);
            }
            catch (SQLException sQLException) {
                System.out.println("Error dropping table:" + string);
                sQLException.printStackTrace();
            }
        }
    }
}

