/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.api.message.MessageBundle;
import org.apache.deltaspike.core.api.message.MessageTemplate;
import org.apache.deltaspike.core.impl.message.MessageBundleInvocationHandler;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.BeanConfiguratorUtils;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;

public class MessageBundleExtension
implements Extension,
Deactivatable {
    private final Collection<AnnotatedType<?>> messageBundleTypes = new HashSet();
    private List<String> deploymentErrors = new ArrayList<String>();
    private Boolean isActivated = true;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    protected void detectInterfaces(@Observes ProcessAnnotatedType processAnnotatedType) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        AnnotatedType type = processAnnotatedType.getAnnotatedType();
        if (type.isAnnotationPresent(MessageBundle.class) && this.validateMessageBundle(type.getJavaClass())) {
            this.messageBundleTypes.add(type);
        }
    }

    private boolean validateMessageBundle(Class<?> currentClass) {
        boolean ok = true;
        if (!currentClass.isInterface()) {
            this.deploymentErrors.add("@MessageBundle must only be used on Interfaces, but got used on class " + currentClass.getName());
            return false;
        }
        for (Method currentMethod : currentClass.getDeclaredMethods()) {
            if (!currentMethod.isAnnotationPresent(MessageTemplate.class) || String.class.isAssignableFrom(currentMethod.getReturnType()) || Message.class.isAssignableFrom(currentMethod.getReturnType())) continue;
            this.deploymentErrors.add(currentMethod.getReturnType().getName() + " isn't supported. Details: " + currentMethod.getDeclaringClass().getName() + "#" + currentMethod.getName() + " only " + String.class.getName() + " or " + Message.class.getName());
            ok = false;
        }
        return ok;
    }

    protected void installMessageBundleProducerBeans(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        if (!this.deploymentErrors.isEmpty()) {
            abd.addDefinitionError((Throwable)new IllegalArgumentException("The following MessageBundle problems where found: " + Arrays.toString(this.deploymentErrors.toArray())));
            return;
        }
        for (AnnotatedType<?> type : this.messageBundleTypes) {
            this.addAsBean(abd, beanManager, type);
        }
    }

    protected <T> void addAsBean(AfterBeanDiscovery abd, BeanManager beanManager, AnnotatedType<T> type) {
        BeanConfigurator beanConfigurator = abd.addBean().createWith(cc -> {
            Bean invocationHandlerBean = beanManager.resolve(beanManager.getBeans(MessageBundleInvocationHandler.class, new Annotation[0]));
            return this.createMessageBundleProxy(type.getJavaClass(), (MessageBundleInvocationHandler)beanManager.getReference(invocationHandlerBean, MessageBundleInvocationHandler.class, cc));
        });
        BeanConfiguratorUtils.read((BeanManager)beanManager, (BeanConfigurator)beanConfigurator, type).types(new Type[]{type.getJavaClass(), Object.class, Serializable.class}).addQualifier((Annotation)Default.Literal.INSTANCE).scope(ApplicationScoped.class).id("MessageBundleBean#" + type.getJavaClass().getName());
    }

    protected void cleanup(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        this.messageBundleTypes.clear();
    }

    private <T> T createMessageBundleProxy(Class<T> type, MessageBundleInvocationHandler handler) {
        return type.cast(Proxy.newProxyInstance(ClassUtils.getClassLoader(null), new Class[]{type, Serializable.class}, (InvocationHandler)handler));
    }
}

