/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.wizards;

import java.io.File;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportCertificateWizardPage
extends WizardPage {
    private Text fileText;
    private Button overwriteFileButton;
    private ComboViewer formatComboViewer;

    public ExportCertificateWizardPage() {
        super("ExportCertificateWizardPage");
        this.setTitle(Messages.getString("ExportCertificateWizardPage.ExportCertificate"));
        this.setDescription(Messages.getString("ExportCertificateWizardPage.PleaseSelectFileAndFormat"));
        this.setImageDescriptor(ConnectionUIPlugin.getDefault().getImageDescriptor("resources/icons/certificate_export_wizard.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        Group fileGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("ExportCertificateWizardPage.File"), (int)1);
        fileGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite fileComposite = BaseWidgetUtils.createColumnContainer((Composite)fileGroup, (int)2, (int)1);
        fileComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fileText = BaseWidgetUtils.createText((Composite)fileComposite, (String)"", (int)1);
        this.fileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fileText.addModifyListener(event -> this.validate());
        Button browseButton = BaseWidgetUtils.createButton((Composite)fileComposite, (String)Messages.getString("ExportCertificateWizardPage.Browse"), (int)1);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportCertificateWizardPage.this.chooseExportFile();
                ExportCertificateWizardPage.this.validate();
            }
        });
        this.overwriteFileButton = BaseWidgetUtils.createCheckbox((Composite)fileComposite, (String)Messages.getString("ExportCertificateWizardPage.OverwriteExistingFile"), (int)2);
        this.overwriteFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportCertificateWizardPage.this.validate();
            }
        });
        Group formatGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("ExportCertificateWizardPage.Format"), (int)1);
        formatGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.formatComboViewer = new ComboViewer((Composite)formatGroup);
        this.formatComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.formatComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CertificateExportFormat) {
                    CertificateExportFormat format = (CertificateExportFormat)((Object)element);
                    if (format == CertificateExportFormat.DER) {
                        return Messages.getString("ExportCertificateWizardPage.X509CertificateDER");
                    }
                    return Messages.getString("ExportCertificateWizardPage.X509CertificatePEM");
                }
                return super.getText(element);
            }
        });
        this.formatComboViewer.setInput((Object)new CertificateExportFormat[]{CertificateExportFormat.DER, CertificateExportFormat.PEM});
        this.formatComboViewer.setSelection((ISelection)new StructuredSelection((Object)CertificateExportFormat.DER));
        this.formatComboViewer.getControl().setLayoutData((Object)new GridData(4, 0, true, false));
        this.displayErrorMessage(null);
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    private void validate() {
        File file = new File(this.fileText.getText());
        if (file.isDirectory()) {
            this.displayErrorMessage(Messages.getString("ExportCertificateWizardPage.ErrorFileNotAFile"));
            return;
        }
        if (file.exists() && !this.overwriteFileButton.getSelection()) {
            this.displayErrorMessage(Messages.getString("ExportCertificateWizardPage.ErrorFileAlreadyExists"));
            return;
        }
        if (file.exists() && !file.canWrite()) {
            this.displayErrorMessage(Messages.getString("ExportCertificateWizardPage.ErrorFileNotWritable"));
            return;
        }
        if (file.getParentFile() == null) {
            this.displayErrorMessage(Messages.getString("ExportCertificateWizardPage.ErrorFileDirectoryNotWritable"));
            return;
        }
        this.displayErrorMessage(null);
    }

    protected void displayErrorMessage(String message) {
        this.setMessage(null, 0);
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void chooseExportFile() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.setText(Messages.getString("ExportCertificateWizardPage.ChooseFile"));
        if (!Strings.isEmpty((String)this.fileText.getText())) {
            dialog.setFilterPath(this.fileText.getText());
        }
        String selectedFile = dialog.open();
        this.fileText.setText(CommonUIUtils.getTextValue((String)selectedFile));
    }

    public File getExportFile() {
        return new File(this.fileText.getText());
    }

    public CertificateExportFormat getCertificateExportFormat() {
        StructuredSelection selection = (StructuredSelection)this.formatComboViewer.getSelection();
        if (!selection.isEmpty()) {
            return (CertificateExportFormat)((Object)selection.getFirstElement());
        }
        return CertificateExportFormat.DER;
    }

    static enum CertificateExportFormat {
        DER,
        PEM;

    }
}

