/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.dolphinscheduler.plugin.task.api;

import java.io.Serializable;

import lombok.Data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 *  k8s Task ExecutionContext
 */
@Data
public class K8sTaskExecutionContext implements Serializable {

    private String configYaml;

    private String namespace;

    private String connectionParams;

    public K8sTaskExecutionContext() {
    }

    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    public K8sTaskExecutionContext(
                                   @JsonProperty("configYaml") String configYaml,
                                   @JsonProperty("namespace") String namespace) {
        this.configYaml = configYaml;
        this.namespace = namespace;
    }

    @Override
    public String toString() {
        return "K8sTaskExecutionContext{"
                + "namespace=" + namespace
                + ", configYaml='" + configYaml + '\''
                + ", connectionParams='" + connectionParams + '\''
                + '}';
    }
}
