-- TABLES: customer,orders,lineitem
-- ERROR: not stable
SELECT  /*+SET_VAR(enable_fallback_to_original_planner=false) */
  CAST(L.var["L_ORDERKEY"] AS INT),
  SUM(CAST(L.var["L_EXTENDEDPRICE"] AS DOUBLE) * (1 - CAST(L.var["L_DISCOUNT"] AS DOUBLE))) AS REVENUE,
  CAST(O.var["O_ORDERDATE"] AS TEXT),
  CAST(O.var["O_SHIPPRIORITY"] AS INT)
FROM
  customer C,
  orders O,
  lineitem L
WHERE
  CAST(C.var["C_MKTSEGMENT"] AS TEXT) = 'BUILDING'
  AND CAST(C.var["C_CUSTKEY"] AS INT) = CAST(O.var["O_CUSTKEY"] AS INT)
  AND CAST(L.var["L_ORDERKEY"] AS INT) = CAST(O.var["O_ORDERKEY"] AS INT)
  AND CAST(O.var["O_ORDERDATE"] AS TEXT) < '1995-03-15'
  AND CAST(L.var["L_SHIPDATE"] AS TEXT) > '1995-03-15'
GROUP BY
  CAST(L.var["L_ORDERKEY"] AS INT),
  CAST(O.var["O_ORDERDATE"] AS TEXT),
  CAST(O.var["O_SHIPPRIORITY"] AS INT)
ORDER BY
  REVENUE DESC,
  CAST(O.var["O_ORDERDATE"] AS TEXT)
LIMIT 10
