/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: first.proto

package multiprotos

import (
	context "context"
	fmt "fmt"
	math "math"
)

import (
	proto "github.com/golang/protobuf/proto"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

import (
	"dubbo.apache.org/dubbo-go/v3/protocol"
	"dubbo.apache.org/dubbo-go/v3/protocol/invocation"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type FirstRequest struct {
	Message              string   `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FirstRequest) Reset()         { *m = FirstRequest{} }
func (m *FirstRequest) String() string { return proto.CompactTextString(m) }
func (*FirstRequest) ProtoMessage()    {}
func (*FirstRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_55120e8023d656fd, []int{0}
}

func (m *FirstRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FirstRequest.Unmarshal(m, b)
}
func (m *FirstRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FirstRequest.Marshal(b, m, deterministic)
}
func (m *FirstRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FirstRequest.Merge(m, src)
}
func (m *FirstRequest) XXX_Size() int {
	return xxx_messageInfo_FirstRequest.Size(m)
}
func (m *FirstRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FirstRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FirstRequest proto.InternalMessageInfo

func (m *FirstRequest) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type FirstResponse struct {
	Message              string   `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FirstResponse) Reset()         { *m = FirstResponse{} }
func (m *FirstResponse) String() string { return proto.CompactTextString(m) }
func (*FirstResponse) ProtoMessage()    {}
func (*FirstResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_55120e8023d656fd, []int{1}
}

func (m *FirstResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FirstResponse.Unmarshal(m, b)
}
func (m *FirstResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FirstResponse.Marshal(b, m, deterministic)
}
func (m *FirstResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FirstResponse.Merge(m, src)
}
func (m *FirstResponse) XXX_Size() int {
	return xxx_messageInfo_FirstResponse.Size(m)
}
func (m *FirstResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FirstResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FirstResponse proto.InternalMessageInfo

func (m *FirstResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func init() {
	proto.RegisterType((*FirstRequest)(nil), "multiprotos.FirstRequest")
	proto.RegisterType((*FirstResponse)(nil), "multiprotos.FirstResponse")
}

func init() { proto.RegisterFile("first.proto", fileDescriptor_55120e8023d656fd) }

var fileDescriptor_55120e8023d656fd = []byte{
	// 137 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xe2, 0x4e, 0xcb, 0x2c, 0x2a,
	0x2e, 0xd1, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0xe2, 0xce, 0x2d, 0xcd, 0x29, 0xc9, 0x04, 0xb3,
	0x8b, 0x95, 0x34, 0xb8, 0x78, 0xdc, 0x40, 0x72, 0x41, 0xa9, 0x85, 0xa5, 0xa9, 0xc5, 0x25, 0x42,
	0x12, 0x5c, 0xec, 0xb9, 0xa9, 0xc5, 0xc5, 0x89, 0xe9, 0xa9, 0x12, 0x8c, 0x0a, 0x8c, 0x1a, 0x9c,
	0x41, 0x30, 0xae, 0x92, 0x26, 0x17, 0x2f, 0x54, 0x65, 0x71, 0x41, 0x7e, 0x5e, 0x71, 0x2a, 0x6e,
	0xa5, 0x46, 0x41, 0x5c, 0x3c, 0x6e, 0x45, 0x99, 0xc5, 0x25, 0xc1, 0xa9, 0x45, 0x65, 0x99, 0xc9,
	0xa9, 0x42, 0x4e, 0x5c, 0xec, 0x30, 0xa6, 0xa4, 0x1e, 0x92, 0xed, 0x7a, 0xc8, 0x56, 0x4b, 0x49,
	0x61, 0x93, 0x82, 0xd8, 0xa5, 0xc4, 0x90, 0xc4, 0x06, 0x16, 0x37, 0x06, 0x04, 0x00, 0x00, 0xff,
	0xff, 0x83, 0xb7, 0xe6, 0xc5, 0xcb, 0x00, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FristServiceClient is the client API for FristService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FristServiceClient interface {
	Service(ctx context.Context, in *FirstRequest, opts ...grpc.CallOption) (*FirstResponse, error)
}

type fristServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFristServiceClient(cc grpc.ClientConnInterface) FristServiceClient {
	return &fristServiceClient{cc}
}

func (c *fristServiceClient) Service(ctx context.Context, in *FirstRequest, opts ...grpc.CallOption) (*FirstResponse, error) {
	out := new(FirstResponse)
	err := c.cc.Invoke(ctx, "/multiprotos.FristService/Service", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FristServiceServer is the server API for FristService service.
type FristServiceServer interface {
	Service(context.Context, *FirstRequest) (*FirstResponse, error)
}

// UnimplementedFristServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFristServiceServer struct {
}

func (*UnimplementedFristServiceServer) Service(ctx context.Context, req *FirstRequest) (*FirstResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Service not implemented")
}

func RegisterFristServiceServer(s *grpc.Server, srv FristServiceServer) {
	s.RegisterService(&_FristService_serviceDesc, srv)
}

func _FristService_Service_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FirstRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FristServiceServer).Service(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/multiprotos.FristService/Service",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FristServiceServer).Service(ctx, req.(*FirstRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FristService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "multiprotos.FristService",
	HandlerType: (*FristServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Service",
			Handler:    _FristService_Service_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "first.proto",
}

// FristServiceClientImpl is the client API for FristService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FristServiceClientImpl struct {
	Service func(ctx context.Context, in *FirstRequest, out *FirstResponse) error
}

func (c *FristServiceClientImpl) Reference() string {
	return "fristServiceImpl"
}

func (c *FristServiceClientImpl) GetDubboStub(cc *grpc.ClientConn) FristServiceClient {
	return NewFristServiceClient(cc)
}

type FristServiceProviderBase struct {
	proxyImpl protocol.Invoker
}

func (s *FristServiceProviderBase) SetProxyImpl(impl protocol.Invoker) {
	s.proxyImpl = impl
}

func (s *FristServiceProviderBase) GetProxyImpl() protocol.Invoker {
	return s.proxyImpl
}

func (c *FristServiceProviderBase) Reference() string {
	return "fristServiceImpl"
}

func _DUBBO_FristService_Service_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FirstRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	// DubboGrpcService is gRPC service
	type DubboGrpcService interface {
		// SetProxyImpl sets proxy.
		SetProxyImpl(impl protocol.Invoker)
		// GetProxyImpl gets proxy.
		GetProxyImpl() protocol.Invoker
		// ServiceDesc gets an RPC service's specification.
		ServiceDesc() *grpc.ServiceDesc
	}
	base := srv.(DubboGrpcService)
	args := []interface{}{}
	args = append(args, in)
	invo := invocation.NewRPCInvocation("Service", args, nil)
	if interceptor == nil {
		result := base.GetProxyImpl().Invoke(ctx, invo)
		return result.Result(), result.Error()
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/multiprotos.FristService/Service",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		result := base.GetProxyImpl().Invoke(ctx, invo)
		return result.Result(), result.Error()
	}
	return interceptor(ctx, in, info, handler)
}

func (s *FristServiceProviderBase) ServiceDesc() *grpc.ServiceDesc {
	return &grpc.ServiceDesc{
		ServiceName: "multiprotos.FristService",
		HandlerType: (*FristServiceServer)(nil),
		Methods: []grpc.MethodDesc{
			{
				MethodName: "Service",
				Handler:    _DUBBO_FristService_Service_Handler,
			},
		},
		Streams:  []grpc.StreamDesc{},
		Metadata: "first.proto",
	}
}
