/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.Collection;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBRecordBean
extends DBRecordBase {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBRecordBean.class);
    protected transient DBContext tempContext;
    protected transient DBRowSet rowset;
    protected boolean enableRollbackHandling;

    public static Object[] key(Object ... values) {
        if (values.length == 0) {
            throw new InvalidArgumentException("values", values);
        }
        return values;
    }

    public DBRecordBean(boolean enableRollbackHandling) {
        this.enableRollbackHandling = enableRollbackHandling;
    }

    public DBRecordBean() {
        this(false);
    }

    @Override
    public DBContext getContext() {
        if (this.tempContext == null) {
            throw new ObjectNotValidException(this);
        }
        return this.tempContext;
    }

    @Override
    public DBRowSet getRowSet() {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        return this.rowset;
    }

    @Override
    public boolean isRollbackHandlingEnabled() {
        return this.enableRollbackHandling;
    }

    public void setRollbackHandlingEnabled(boolean enabled) {
        this.enableRollbackHandling = enabled;
    }

    public long getIdentity() {
        Column[] keyColumns = this.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(this.getRowSet());
        }
        if (keyColumns.length != 1 || !keyColumns[0].getDataType().isNumeric()) {
            throw new NotSupportedException(this, "getIdentity");
        }
        return this.getLong(keyColumns[0]);
    }

    @Override
    public void close() {
        super.close();
        this.rowset = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecordBean create(DBContext context, DBRowSet rowset, Object[] initalKey) {
        try {
            this.tempContext = context;
            rowset.createRecord(this, initalKey, true);
            DBRecordBean dBRecordBean = this;
            return dBRecordBean;
        }
        finally {
            this.tempContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecordBean create(DBContext context, DBRowSet rowset) {
        try {
            this.tempContext = context;
            rowset.createRecord(this, null, false);
            DBRecordBean dBRecordBean = this;
            return dBRecordBean;
        }
        finally {
            this.tempContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecordBean read(DBContext context, DBRowSet rowset, Object[] key) {
        try {
            this.tempContext = context;
            DBCompareExpr keyConstraints = rowset.getKeyConstraints(key);
            rowset.readRecord((DBRecordBase)this, keyConstraints);
            DBRecordBean dBRecordBean = this;
            return dBRecordBean;
        }
        finally {
            this.tempContext = null;
        }
    }

    public DBRecordBean read(DBContext context, DBRowSet rowset, Object id) {
        if (ObjectUtils.isEmpty(id)) {
            throw new InvalidArgumentException("id", id);
        }
        Object[] key = id instanceof Object[] ? (Object[])id : (id instanceof Collection ? ((Collection)id).toArray() : new Object[]{id});
        return this.read(context, rowset, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecordBean read(DBContext context, DBRowSet rowset, DBCompareExpr whereConstraints) {
        try {
            this.tempContext = context;
            rowset.readRecord((DBRecordBase)this, whereConstraints);
            DBRecordBean dBRecordBean = this;
            return dBRecordBean;
        }
        finally {
            this.tempContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRecordBean read(DBContext context, DBRowSet rowset, Object[] key, DBRowSet.PartialMode mode, DBColumn ... columns) {
        try {
            this.tempContext = context;
            DBCompareExpr keyConstraints = rowset.getKeyConstraints(key);
            rowset.readRecord(this, keyConstraints, mode, columns);
            DBRecordBean dBRecordBean = this;
            return dBRecordBean;
        }
        finally {
            this.tempContext = null;
        }
    }

    @Override
    public DBRecordBean set(Column column, Object value) {
        return (DBRecordBean)super.set(column, value);
    }

    public void update(DBContext context) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (!this.isModified()) {
            return;
        }
        try {
            this.tempContext = context;
            this.checkUpdateable();
            if (this.enableRollbackHandling && context.isRollbackHandlingEnabled()) {
                context.appendRollbackHandler(this.createRollbackHandler());
            }
            this.assignParentIdentities();
            this.getRowSet().updateRecord(this);
        }
        finally {
            this.tempContext = null;
        }
    }

    public void delete(DBContext context) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        this.checkUpdateable();
        if (this.enableRollbackHandling && context.isRollbackHandlingEnabled()) {
            context.appendRollbackHandler(this.createRollbackHandler());
        }
        if (!this.isNew()) {
            Object[] key = this.getKey();
            log.info("Deleting record {}", (Object)StringUtils.arrayToString(key));
            this.getRowSet().deleteRecord(key, context);
        }
        this.close();
    }
}

