/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;

public class AggregateDependency
extends OSGiTestCase {
    private Element[] deps;
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.AggregateDependency");
        this.deps = meta.getElements("requires");
    }

    public void testCallbackBind() {
        Element dep = this.getDependencyById(this.deps, "Bar");
        String opt = dep.getAttribute("aggregate");
        AggregateDependency.assertEquals((String)"Check aggregate", (String)"true", (String)opt);
    }

    public void testCallbackUnbind() {
        Element dep = this.getDependencyById(this.deps, "Baz");
        String opt = dep.getAttribute("aggregate");
        AggregateDependency.assertEquals((String)"Check aggregate", (String)"true", (String)opt);
    }

    public void testBindOnly() {
        Element dep = this.getDependencyById(this.deps, "bindonly");
        String opt = dep.getAttribute("aggregate");
        AggregateDependency.assertEquals((String)"Check aggregate", (String)"true", (String)opt);
    }

    public void testUnbindOnly() {
        Element dep = this.getDependencyById(this.deps, "unbindonly");
        String opt = dep.getAttribute("aggregate");
        AggregateDependency.assertEquals((String)"Check aggregate", (String)"true", (String)opt);
    }

    private Element getDependencyById(Element[] deps, String name) {
        int i = 0;
        while (i < deps.length) {
            String na = deps[i].getAttribute("id");
            String field = deps[i].getAttribute("field");
            if (na != null && na.equalsIgnoreCase(name)) {
                return deps[i];
            }
            if (field != null && field.equalsIgnoreCase(name)) {
                return deps[i];
            }
            ++i;
        }
        AggregateDependency.fail((String)("Dependency  " + name + " not found"));
        return null;
    }

    private String getBind(Element dep) {
        Element[] elem = dep.getElements("callback");
        int i = 0;
        while (elem != null && i < elem.length) {
            if (elem[i].getAttribute("type").equalsIgnoreCase("bind")) {
                return elem[i].getAttribute("method");
            }
            ++i;
        }
        return null;
    }

    private String getUnbind(Element dep) {
        Element[] elem = dep.getElements("callback");
        int i = 0;
        while (elem != null && i < elem.length) {
            if (elem[i].getAttribute("type").equalsIgnoreCase("unbind")) {
                return elem[i].getAttribute("method");
            }
            ++i;
        }
        return null;
    }
}

