/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;

public class LifecycleCallbacks
extends OSGiTestCase {
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
    }

    public void testCallbacks() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.Lifecycle");
        Element[] cbs = meta.getElements("callback");
        LifecycleCallbacks.assertNotNull((String)"Callbacks exists ", (Object)cbs);
        LifecycleCallbacks.assertEquals((String)"Callbacks count ", (int)2, (int)cbs.length);
        Element elem = this.getCallbackByMethodName(cbs, "start");
        LifecycleCallbacks.assertEquals((String)"Check start method", (String)"start", (String)elem.getAttribute("method"));
        LifecycleCallbacks.assertEquals((String)"Check start transition", (String)"validate", (String)elem.getAttribute("transition"));
        elem = this.getCallbackByMethodName(cbs, "stop");
        LifecycleCallbacks.assertEquals((String)"Check stop method", (String)"stop", (String)elem.getAttribute("method"));
        LifecycleCallbacks.assertEquals((String)"Check stop transition", (String)"invalidate", (String)elem.getAttribute("transition"));
    }

    public void testImmediate() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.Immediate");
        LifecycleCallbacks.assertNotNull((String)"Immediate attribute", (Object)meta.getAttribute("immediate"));
        LifecycleCallbacks.assertEquals((String)"Immediate attribute value", (String)"true", (String)meta.getAttribute("immediate"));
    }

    public void testNoImmediate() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.NoImmediate");
        LifecycleCallbacks.assertNotNull((String)"Immediate attribute", (Object)meta.getAttribute("immediate"));
        LifecycleCallbacks.assertEquals((String)"Immediate attribute value", (String)"false", (String)meta.getAttribute("immediate"));
    }

    private Element getCallbackByMethodName(Element[] cbs, String method) {
        int i = 0;
        while (i < cbs.length) {
            String met = cbs[i].getAttribute("method");
            if (met != null && met.equalsIgnoreCase(method)) {
                return cbs[i];
            }
            ++i;
        }
        LifecycleCallbacks.fail((String)("Cannot found the callback with the method " + method));
        return null;
    }
}

