/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.manipulation;

import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.test.scenarios.component.InnerClasses;
import org.apache.felix.ipojo.test.scenarios.manipulation.service.CheckService;
import org.osgi.framework.ServiceReference;

public class NestedClassesTests
extends OSGiTestCase {
    private ComponentInstance instance;
    private CheckService service;
    IPOJOHelper helper;
    static /* synthetic */ Class class$0;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
        Properties map = new Properties();
        map.put("publicObject", "publicObject");
        map.put("publicInt", new Integer(0));
        map.put("packageObject", "packageObject");
        map.put("packageInt", new Integer(1));
        map.put("protectedObject", "protectedObject");
        map.put("protectedInt", new Integer(2));
        map.put("privateObject", "privateObject");
        map.put("privateInt", new Integer(3));
        map.put("nonObject", "nonObject");
        map.put("nonInt", new Integer(4));
        this.instance = this.helper.createComponentInstance("inners", (Dictionary)map);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.felix.ipojo.test.scenarios.manipulation.service.CheckService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference ref = this.helper.getServiceReferenceByName(clazz.getName(), this.instance.getInstanceName());
        NestedClassesTests.assertNotNull((String)"Check service availability", (Object)ref);
        this.service = (CheckService)this.getServiceObject(ref);
    }

    public void tearDown() {
        this.helper.dispose();
        this.service = null;
    }

    public void testPrivateInnerClass() {
        Map data = (Map)this.service.getProps().get("privateInner");
        NestedClassesTests.assertNotNull((String)"Check data existency", (Object)data);
        NestedClassesTests.assertEquals((String)"Check public object", (Object)"publicObject", data.get("publicObject"));
        NestedClassesTests.assertEquals((String)"Check public int", (Object)new Integer(0), data.get("publicInt"));
        NestedClassesTests.assertEquals((String)"Check protected object", (Object)"protectedObject", data.get("protectedObject"));
        NestedClassesTests.assertEquals((String)"Check protected int", (Object)new Integer(2), data.get("protectedInt"));
        NestedClassesTests.assertEquals((String)"Check package object", (Object)"packageObject", data.get("packageObject"));
        NestedClassesTests.assertEquals((String)"Check package int", (Object)new Integer(1), data.get("packageInt"));
        NestedClassesTests.assertEquals((String)"Check private object", (Object)"privateObject", data.get("privateObject"));
        NestedClassesTests.assertEquals((String)"Check private int", (Object)new Integer(3), data.get("privateInt"));
        NestedClassesTests.assertEquals((String)"Check non-managed object", (Object)"not-managed", data.get("nonObject"));
        NestedClassesTests.assertEquals((String)"Check non-managed int", (Object)new Integer(5), data.get("nonInt"));
    }

    public void testProtectedInnerClass() {
        Map data = (Map)this.service.getProps().get("protectedInner");
        NestedClassesTests.assertNotNull((String)"Check data existency", (Object)data);
        NestedClassesTests.assertEquals((String)"Check public object", (Object)"publicObject", data.get("publicObject"));
        NestedClassesTests.assertEquals((String)"Check public int", (Object)new Integer(0), data.get("publicInt"));
        NestedClassesTests.assertEquals((String)"Check protected object", (Object)"protectedObject", data.get("protectedObject"));
        NestedClassesTests.assertEquals((String)"Check protected int", (Object)new Integer(2), data.get("protectedInt"));
        NestedClassesTests.assertEquals((String)"Check package object", (Object)"packageObject", data.get("packageObject"));
        NestedClassesTests.assertEquals((String)"Check package int", (Object)new Integer(1), data.get("packageInt"));
        NestedClassesTests.assertEquals((String)"Check private object", (Object)"privateObject", data.get("privateObject"));
        NestedClassesTests.assertEquals((String)"Check private int", (Object)new Integer(3), data.get("privateInt"));
        NestedClassesTests.assertEquals((String)"Check non-managed object", (Object)"not-managed", data.get("nonObject"));
        NestedClassesTests.assertEquals((String)"Check non-managed int", (Object)new Integer(5), data.get("nonInt"));
    }

    public void testPackageInnerClass() {
        Map data = (Map)this.service.getProps().get("packageInner");
        NestedClassesTests.assertNotNull((String)"Check data existency", (Object)data);
        NestedClassesTests.assertEquals((String)"Check public object", (Object)"publicObject", data.get("publicObject"));
        NestedClassesTests.assertEquals((String)"Check public int", (Object)new Integer(0), data.get("publicInt"));
        NestedClassesTests.assertEquals((String)"Check protected object", (Object)"protectedObject", data.get("protectedObject"));
        NestedClassesTests.assertEquals((String)"Check protected int", (Object)new Integer(2), data.get("protectedInt"));
        NestedClassesTests.assertEquals((String)"Check package object", (Object)"packageObject", data.get("packageObject"));
        NestedClassesTests.assertEquals((String)"Check package int", (Object)new Integer(1), data.get("packageInt"));
        NestedClassesTests.assertEquals((String)"Check private object", (Object)"privateObject", data.get("privateObject"));
        NestedClassesTests.assertEquals((String)"Check private int", (Object)new Integer(3), data.get("privateInt"));
        NestedClassesTests.assertEquals((String)"Check non-managed object", (Object)"not-managed", data.get("nonObject"));
        NestedClassesTests.assertEquals((String)"Check non-managed int", (Object)new Integer(5), data.get("nonInt"));
    }

    public void testPublicInnerClass() {
        Map data = (Map)this.service.getProps().get("publicInner");
        NestedClassesTests.assertNotNull((String)"Check data existency", (Object)data);
        NestedClassesTests.assertEquals((String)"Check public object", (Object)"publicObject", data.get("publicObject"));
        NestedClassesTests.assertEquals((String)"Check public int", (Object)new Integer(0), data.get("publicInt"));
        NestedClassesTests.assertEquals((String)"Check protected object", (Object)"protectedObject", data.get("protectedObject"));
        NestedClassesTests.assertEquals((String)"Check protected int", (Object)new Integer(2), data.get("protectedInt"));
        NestedClassesTests.assertEquals((String)"Check package object", (Object)"packageObject", data.get("packageObject"));
        NestedClassesTests.assertEquals((String)"Check package int", (Object)new Integer(1), data.get("packageInt"));
        NestedClassesTests.assertEquals((String)"Check private object", (Object)"privateObject", data.get("privateObject"));
        NestedClassesTests.assertEquals((String)"Check private int", (Object)new Integer(3), data.get("privateInt"));
        NestedClassesTests.assertEquals((String)"Check non-managed object", (Object)"not-managed", data.get("nonObject"));
        NestedClassesTests.assertEquals((String)"Check non-managed int", (Object)new Integer(5), data.get("nonInt"));
    }

    public void testConstructorInnerClass() {
        Map data = (Map)this.service.getProps().get("constructorInner");
        NestedClassesTests.assertNotNull((String)"Check data existency", (Object)data);
        NestedClassesTests.assertEquals((String)"Check public object", (Object)"publicObject", data.get("publicObject"));
        NestedClassesTests.assertEquals((String)"Check public int", (Object)new Integer(0), data.get("publicInt"));
        NestedClassesTests.assertEquals((String)"Check protected object", (Object)"protectedObject", data.get("protectedObject"));
        NestedClassesTests.assertEquals((String)"Check protected int", (Object)new Integer(2), data.get("protectedInt"));
        NestedClassesTests.assertEquals((String)"Check package object", (Object)"packageObject", data.get("packageObject"));
        NestedClassesTests.assertEquals((String)"Check package int", (Object)new Integer(1), data.get("packageInt"));
        NestedClassesTests.assertEquals((String)"Check private object", (Object)"privateObject", data.get("privateObject"));
        NestedClassesTests.assertEquals((String)"Check private int", (Object)new Integer(3), data.get("privateInt"));
        NestedClassesTests.assertEquals((String)"Check non-managed object", (Object)"not-managed", data.get("nonObject"));
        NestedClassesTests.assertEquals((String)"Check non-managed int", (Object)new Integer(5), data.get("nonInt"));
    }

    public void testStaticInnerClass() {
        Map data = (Map)this.service.getProps().get("staticInner");
        NestedClassesTests.assertNotNull((String)"Check data existency", (Object)data);
        NestedClassesTests.assertEquals((String)"Check static", (Object)new Boolean(true), data.get("static"));
        NestedClassesTests.assertEquals((String)"Check static int", (Object)new Integer(6), data.get("staticint"));
    }

    public void testAnonymousInnerClass() {
        Map data = (Map)this.service.getProps().get("anonymous");
        NestedClassesTests.assertNotNull((String)"Check data existency", (Object)data);
        NestedClassesTests.assertEquals((String)"Check public object", (Object)"publicObject", data.get("publicObject"));
        NestedClassesTests.assertEquals((String)"Check public int", (Object)new Integer(0), data.get("publicInt"));
        NestedClassesTests.assertEquals((String)"Check protected object", (Object)"protectedObject", data.get("protectedObject"));
        NestedClassesTests.assertEquals((String)"Check protected int", (Object)new Integer(2), data.get("protectedInt"));
        NestedClassesTests.assertEquals((String)"Check package object", (Object)"packageObject", data.get("packageObject"));
        NestedClassesTests.assertEquals((String)"Check package int", (Object)new Integer(1), data.get("packageInt"));
        NestedClassesTests.assertEquals((String)"Check private object", (Object)"privateObject", data.get("privateObject"));
        NestedClassesTests.assertEquals((String)"Check private int", (Object)new Integer(3), data.get("privateInt"));
        NestedClassesTests.assertEquals((String)"Check non-managed object", (Object)"not-managed", data.get("nonObject"));
        NestedClassesTests.assertEquals((String)"Check non-managed int", (Object)new Integer(5), data.get("nonInt"));
    }

    public void testInnerAccess() {
        Properties map = this.service.getProps();
        NestedClassesTests.assertNotNull((String)"Check map existency", (Object)map);
        InnerClasses.PublicNested p = (InnerClasses.PublicNested)map.get("public");
        Map data = p.doSomething();
        NestedClassesTests.assertEquals((String)"Check public object", (Object)"publicObject", data.get("publicObject"));
        NestedClassesTests.assertEquals((String)"Check public int", (Object)new Integer(0), data.get("publicInt"));
        NestedClassesTests.assertEquals((String)"Check protected object", (Object)"protectedObject", data.get("protectedObject"));
        NestedClassesTests.assertEquals((String)"Check protected int", (Object)new Integer(2), data.get("protectedInt"));
        NestedClassesTests.assertEquals((String)"Check package object", (Object)"packageObject", data.get("packageObject"));
        NestedClassesTests.assertEquals((String)"Check package int", (Object)new Integer(1), data.get("packageInt"));
        NestedClassesTests.assertEquals((String)"Check private object", (Object)"privateObject", data.get("privateObject"));
        NestedClassesTests.assertEquals((String)"Check private int", (Object)new Integer(3), data.get("privateInt"));
        NestedClassesTests.assertEquals((String)"Check non-managed object", (Object)"not-managed", data.get("nonObject"));
        NestedClassesTests.assertEquals((String)"Check non-managed int", (Object)new Integer(5), data.get("nonInt"));
    }
}

