/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.UnknownTypeException;
import flex.messaging.io.amf.AbstractAmfInput;
import flex.messaging.io.amf.Amf3Types;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.TraitsInfo;
import flex.messaging.log.Log;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class Amf3Input
extends AbstractAmfInput
implements Amf3Types {
    protected List objectTable;
    protected List stringTable = new ArrayList(64);
    protected List traitsTable;

    public Amf3Input(SerializationContext context) {
        super(context);
        this.objectTable = new ArrayList(64);
        this.traitsTable = new ArrayList(10);
    }

    @Override
    public void reset() {
        super.reset();
        this.stringTable.clear();
        this.objectTable.clear();
        this.traitsTable.clear();
    }

    public Object saveObjectTable() {
        List table = this.objectTable;
        this.objectTable = new ArrayList(64);
        return table;
    }

    public void restoreObjectTable(Object table) {
        this.objectTable = (ArrayList)table;
    }

    public Object saveTraitsTable() {
        List table = this.traitsTable;
        this.traitsTable = new ArrayList(10);
        return table;
    }

    public void restoreTraitsTable(Object table) {
        this.traitsTable = (ArrayList)table;
    }

    public Object saveStringTable() {
        List table = this.stringTable;
        this.stringTable = new ArrayList(64);
        return table;
    }

    public void restoreStringTable(Object table) {
        this.stringTable = (ArrayList)table;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        byte type = this.in.readByte();
        Object value = this.readObjectValue(type);
        return value;
    }

    protected Object readObjectValue(int type) throws ClassNotFoundException, IOException {
        Object value = null;
        switch (type) {
            case 6: {
                ClassUtil.validateCreation(String.class);
                value = this.readString();
                if (!this.isDebug) break;
                this.trace.writeString((String)value);
                break;
            }
            case 10: {
                value = this.readScriptObject();
                break;
            }
            case 9: {
                value = this.readArray();
                break;
            }
            case 2: {
                ClassUtil.validateCreation(Boolean.class);
                value = Boolean.FALSE;
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 3: {
                ClassUtil.validateCreation(Boolean.class);
                value = Boolean.TRUE;
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 4: {
                ClassUtil.validateCreation(Integer.class);
                int i = this.readUInt29();
                i = i << 3 >> 3;
                value = new Integer(i);
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 5: {
                value = this.readDouble();
                break;
            }
            case 0: {
                if (!this.isDebug) break;
                this.trace.writeUndefined();
                break;
            }
            case 1: {
                if (!this.isDebug) break;
                this.trace.writeNull();
                break;
            }
            case 7: 
            case 11: {
                value = this.readXml();
                break;
            }
            case 8: {
                value = this.readDate();
                break;
            }
            case 12: {
                value = this.readByteArray();
                break;
            }
            case 17: {
                value = this.readDictionary();
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                value = this.readTypedVector(type);
                break;
            }
            default: {
                UnknownTypeException ex = new UnknownTypeException();
                ex.setMessage(10301, new Object[]{new Integer(type)});
                throw ex;
            }
        }
        return value;
    }

    @Override
    public double readDouble() throws IOException {
        ClassUtil.validateCreation(Double.class);
        double d = super.readDouble();
        if (this.isDebug) {
            this.trace.write(d);
        }
        return d;
    }

    protected String readString() throws IOException {
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getStringReference(ref >> 1);
        }
        int len = ref >> 1;
        if (0 == len) {
            return "";
        }
        String str = this.readUTF(len);
        this.stringTable.add(str);
        return str;
    }

    protected Date readDate() throws IOException {
        ClassUtil.validateCreation(Date.class);
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return (Date)this.getObjectReference(ref >> 1);
        }
        long time = (long)this.in.readDouble();
        Date d = new Date(time);
        this.objectTable.add(d);
        if (this.isDebug) {
            this.trace.write(d);
        }
        return d;
    }

    protected Object readDictionary() throws IOException, ClassNotFoundException {
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getObjectReference(ref >> 1);
        }
        this.readBoolean();
        int len = ref >> 1;
        Hashtable dictionary = (Hashtable)ClassUtil.createDefaultInstance(Hashtable.class, null, true);
        this.objectTable.add(dictionary);
        if (this.isDebug) {
            this.trace.startAMFDictionary(this.objectTable.size() - 1);
        }
        for (int i = 0; i < len; ++i) {
            if (this.isDebug) {
                this.trace.startDictionaryElement();
            }
            Object key = this.readObjectOneLevelDown(true);
            if (this.isDebug) {
                this.trace.addDictionaryEquals();
            }
            Object value = this.readObjectOneLevelDown(true);
            ClassUtil.validateAssignment((Object)dictionary, key != null ? key.toString() : null, value);
            ((Dictionary)dictionary).put(key, value);
        }
        if (this.isDebug) {
            this.trace.endAMFDictionary();
        }
        return dictionary;
    }

    protected Object readTypedVector(int type) throws IOException, ClassNotFoundException {
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getObjectReference(ref >> 1);
        }
        int len = ref >> 1;
        boolean fixed = this.readBoolean();
        Object vector = null;
        switch (type) {
            case 13: {
                vector = this.readTypedIntVector(len, fixed);
                break;
            }
            case 14: {
                vector = this.readTypedUintVector(len, fixed);
                break;
            }
            case 15: {
                vector = this.readTypedDoubleVector(len, fixed);
                break;
            }
            case 16: {
                vector = this.readTypedObjectVector(len, fixed);
                break;
            }
            default: {
                UnknownTypeException ex = new UnknownTypeException();
                ex.setMessage(10301, new Object[]{type});
                throw ex;
            }
        }
        return vector;
    }

    protected Object readTypedIntVector(int len, boolean fixed) throws IOException {
        Object vector;
        boolean useListTemporarily = false;
        if (fixed) {
            boolean bl = useListTemporarily = len > 1024;
            if (useListTemporarily) {
                ClassUtil.validateCreation(ArrayList.class);
                vector = new ArrayList(1024);
            } else {
                ClassUtil.validateCreation(Integer[].class);
                vector = new Integer[len];
            }
        } else {
            ClassUtil.validateCreation(ArrayList.class);
            int initialCapacity = len < 1024 ? len : 1024;
            vector = new ArrayList(initialCapacity);
        }
        int objectId = this.rememberObject(vector);
        if (this.isDebug) {
            this.trace.startAMFVector(this.objectTable.size() - 1, AmfTrace.VectorType.INT);
        }
        for (int i = 0; i < len; ++i) {
            if (this.isDebug) {
                this.trace.arrayElement(i);
            }
            ClassUtil.validateCreation(Integer.class);
            int value = this.readInt();
            if (this.isDebug) {
                this.trace.write(value);
            }
            Integer item = value;
            ClassUtil.validateAssignment(vector, i, (Object)item);
            if (vector instanceof Integer[]) {
                Array.set(vector, i, item);
                continue;
            }
            ((List)vector).add(item);
        }
        if (useListTemporarily) {
            vector = ((ArrayList)vector).toArray();
            this.objectTable.set(objectId, vector);
        }
        if (this.isDebug) {
            this.trace.endAMFVector();
        }
        return vector;
    }

    protected Object readTypedUintVector(int len, boolean fixed) throws IOException {
        Object vector;
        boolean useListTemporarily = false;
        if (fixed) {
            boolean bl = useListTemporarily = len > 1024;
            if (useListTemporarily) {
                ClassUtil.validateCreation(ArrayList.class);
                vector = new ArrayList(1024);
            } else {
                ClassUtil.validateCreation(Long[].class);
                vector = new Long[len];
            }
        } else {
            ClassUtil.validateCreation(ArrayList.class);
            int initialCapacity = len < 1024 ? len : 1024;
            vector = new ArrayList(initialCapacity);
        }
        int objectId = this.rememberObject(vector);
        if (this.isDebug) {
            this.trace.startAMFVector(this.objectTable.size() - 1, AmfTrace.VectorType.UINT);
        }
        for (int i = 0; i < len; ++i) {
            if (this.isDebug) {
                this.trace.arrayElement(i);
            }
            ClassUtil.validateCreation(Long.class);
            long value = (long)(this.in.readByte() & 0xFF) << 24;
            value += (long)(this.in.readByte() & 0xFF) << 16;
            value += (long)(this.in.readByte() & 0xFF) << 8;
            value += (long)(this.in.readByte() & 0xFF);
            if (this.isDebug) {
                this.trace.write(value);
            }
            Long item = value;
            ClassUtil.validateAssignment(vector, i, (Object)item);
            if (vector instanceof Long[]) {
                Array.set(vector, i, item);
                continue;
            }
            ((List)vector).add(item);
        }
        if (useListTemporarily) {
            vector = ((ArrayList)vector).toArray();
            this.objectTable.set(objectId, vector);
        }
        if (this.isDebug) {
            this.trace.endAMFVector();
        }
        return vector;
    }

    protected Object readTypedDoubleVector(int len, boolean fixed) throws IOException {
        Object vector;
        boolean useListTemporarily = false;
        if (fixed) {
            boolean bl = useListTemporarily = len > 1024;
            if (useListTemporarily) {
                ClassUtil.validateCreation(ArrayList.class);
                vector = new ArrayList(1024);
            } else {
                ClassUtil.validateCreation(Double[].class);
                vector = new Double[len];
            }
        } else {
            ClassUtil.validateCreation(ArrayList.class);
            int initialCapacity = len < 1024 ? len : 1024;
            vector = new ArrayList(initialCapacity);
        }
        int objectId = this.rememberObject(vector);
        if (this.isDebug) {
            this.trace.startAMFVector(this.objectTable.size() - 1, AmfTrace.VectorType.DOUBLE);
        }
        for (int i = 0; i < len; ++i) {
            if (this.isDebug) {
                this.trace.arrayElement(i);
            }
            Double item = this.readDouble();
            ClassUtil.validateAssignment(vector, i, (Object)item);
            if (vector instanceof Double[]) {
                Array.set(vector, i, item);
                continue;
            }
            ((List)vector).add(item);
        }
        if (useListTemporarily) {
            vector = ((ArrayList)vector).toArray();
            this.objectTable.set(objectId, vector);
        }
        if (this.isDebug) {
            this.trace.endAMFVector();
        }
        return vector;
    }

    protected Object readTypedObjectVector(int len, boolean fixed) throws IOException, ClassNotFoundException {
        Object vector;
        String className = this.readString();
        if (className == null || className.length() == 0 || className.equals("")) {
            className = Object.class.getName();
        }
        boolean useListTemporarily = false;
        if (fixed) {
            boolean bl = useListTemporarily = len > 1024;
            if (useListTemporarily) {
                ClassUtil.validateCreation(ArrayList.class);
                vector = new ArrayList(1024);
            } else {
                ClassUtil.validateCreation(Object[].class);
                vector = new Object[len];
            }
        } else {
            ClassUtil.validateCreation(ArrayList.class);
            int initialCapacity = len < 1024 ? len : 1024;
            vector = new ArrayList(initialCapacity);
        }
        int objectId = this.rememberObject(vector);
        if (this.isDebug) {
            this.trace.startAMFVector(this.objectTable.size() - 1, AmfTrace.VectorType.OBJECT);
        }
        for (int i = 0; i < len; ++i) {
            if (this.isDebug) {
                this.trace.arrayElement(i);
            }
            Object item = this.readObjectOneLevelDown(true);
            ClassUtil.validateAssignment(vector, i, item);
            if (vector instanceof Object[]) {
                Array.set(vector, i, item);
                continue;
            }
            ((List)vector).add(item);
        }
        if (useListTemporarily) {
            vector = ((ArrayList)vector).toArray();
            this.objectTable.set(objectId, vector);
        }
        if (this.isDebug) {
            this.trace.endAMFVector();
        }
        return vector;
    }

    protected Object readArray() throws ClassNotFoundException, IOException {
        String name;
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getObjectReference(ref >> 1);
        }
        int len = ref >> 1;
        Object array = null;
        Object[] map = null;
        while ((name = this.readString()) != null && name.length() != 0) {
            if (map == null) {
                array = map = (Object[])ClassUtil.createDefaultInstance(HashMap.class, null, true);
                this.objectTable.add(array);
                if (this.isDebug) {
                    this.trace.startECMAArray(this.objectTable.size() - 1);
                }
            }
            if (this.isDebug) {
                this.trace.namedElement(name);
            }
            Object value = this.readObjectOneLevelDown(true);
            ClassUtil.validateAssignment((Object)map, name, value);
            map.put(name, value);
        }
        if (map == null) {
            boolean useListTemporarily = false;
            if (this.context.legacyCollection || len > 1024) {
                useListTemporarily = !this.context.legacyCollection;
                ClassUtil.validateCreation(ArrayList.class);
                int initialCapacity = len < 1024 ? len : 1024;
                array = new ArrayList(initialCapacity);
            } else {
                ClassUtil.validateCreation(Object[].class);
                array = new Object[len];
            }
            int objectId = this.rememberObject(array);
            if (this.isDebug) {
                this.trace.startAMFArray(this.objectTable.size() - 1);
            }
            for (int i = 0; i < len; ++i) {
                if (this.isDebug) {
                    this.trace.arrayElement(i);
                }
                Object item = this.readObjectOneLevelDown(true);
                ClassUtil.validateAssignment(array, i, item);
                if (array instanceof ArrayList) {
                    ((ArrayList)array).add(item);
                    continue;
                }
                Array.set(array, i, item);
            }
            if (useListTemporarily) {
                array = ((ArrayList)array).toArray();
                this.objectTable.set(objectId, array);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (this.isDebug) {
                    this.trace.arrayElement(i);
                }
                Object item = this.readObjectOneLevelDown(true);
                String key = Integer.toString(i);
                ClassUtil.validateAssignment((Object)map, key, item);
                map.put(key, item);
            }
        }
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
        return array;
    }

    protected Object readScriptObject() throws ClassNotFoundException, IOException {
        Object newObj;
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getObjectReference(ref >> 1);
        }
        TraitsInfo ti = this.readTraits(ref);
        String className = ti.getClassName();
        boolean externalizable = ti.isExternalizable();
        Object[] params = new Object[]{className, null};
        Object object = this.createObjectInstance(params);
        className = (String)params[0];
        PropertyProxy proxy = (PropertyProxy)params[1];
        int objectId = this.rememberObject(object);
        if (externalizable) {
            this.readExternalizable(className, object);
        } else {
            if (this.isDebug) {
                this.trace.startAMFObject(className, this.objectTable.size() - 1);
            }
            boolean isCollectionClass = Amf3Input.isCollectionClass(object);
            int len = ti.getProperties().size();
            for (int i = 0; i < len; ++i) {
                String propName = ti.getProperty(i);
                if (this.isDebug) {
                    this.trace.namedElement(propName);
                }
                Object value = this.readObjectOneLevelDown(isCollectionClass);
                proxy.setValue(object, propName, value);
            }
            if (ti.isDynamic()) {
                String name;
                while ((name = this.readString()) != null && name.length() != 0) {
                    if (this.isDebug) {
                        this.trace.namedElement(name);
                    }
                    Object value = this.readObjectOneLevelDown(isCollectionClass);
                    proxy.setValue(object, name, value);
                }
            }
        }
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
        if ((newObj = proxy.instanceComplete(object)) != object) {
            this.objectTable.set(objectId, newObj);
            object = newObj;
        }
        return object;
    }

    protected void readExternalizable(String className, Object object) throws ClassNotFoundException, IOException {
        if (object instanceof Externalizable) {
            if (this.isDebug) {
                this.trace.startExternalizableObject(className, this.objectTable.size() - 1);
            }
        } else {
            SerializationException ex = new SerializationException();
            ex.setMessage(10305, new Object[]{object.getClass().getName()});
            throw ex;
        }
        ((Externalizable)object).readExternal(this);
    }

    protected byte[] readByteArray() throws IOException {
        ClassUtil.validateCreation(byte[].class);
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return (byte[])this.getObjectReference(ref >> 1);
        }
        int len = ref >> 1;
        int initialCapacity = len < 1024 ? len : 1024;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(initialCapacity);
        for (int i = 0; i < len; ++i) {
            outStream.write(this.in.read());
        }
        byte[] ba = outStream.toByteArray();
        this.objectTable.add(ba);
        if (this.isDebug) {
            this.trace.startByteArray(this.objectTable.size() - 1, len);
        }
        return ba;
    }

    protected TraitsInfo readTraits(int ref) throws IOException {
        if ((ref & 3) == 1) {
            return this.getTraitReference(ref >> 2);
        }
        boolean externalizable = (ref & 4) == 4;
        boolean dynamic = (ref & 8) == 8;
        int count = ref >> 4;
        String className = this.readString();
        TraitsInfo ti = new TraitsInfo(className, dynamic, externalizable, count);
        this.traitsTable.add(ti);
        for (int i = 0; i < count; ++i) {
            String propName = this.readString();
            ti.addProperty(propName);
        }
        return ti;
    }

    protected String readUTF(int utflen) throws IOException {
        this.checkUTFLength(utflen);
        byte[] bytearr = new byte[utflen];
        this.in.readFully(bytearr, 0, utflen);
        String s = new String(bytearr, "utf-8");
        return s;
    }

    protected int readUInt29() throws IOException {
        int b = this.in.readByte() & 0xFF;
        if (b < 128) {
            return b;
        }
        int value = (b & 0x7F) << 7;
        b = this.in.readByte() & 0xFF;
        if (b < 128) {
            return value | b;
        }
        value = (value | b & 0x7F) << 7;
        b = this.in.readByte() & 0xFF;
        if (b < 128) {
            return value | b;
        }
        value = (value | b & 0x7F) << 8;
        b = this.in.readByte() & 0xFF;
        return value | b;
    }

    protected Object readXml() throws IOException {
        String xml = null;
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            xml = (String)this.getObjectReference(ref >> 1);
        } else {
            int len = ref >> 1;
            xml = 0 == len ? (String)ClassUtil.createDefaultInstance(String.class, null) : this.readUTF(len);
            this.objectTable.add(xml);
            if (this.isDebug) {
                this.trace.write(xml);
            }
        }
        if (this.context.allowXml) {
            return this.stringToDocument(xml);
        }
        Log.getLogger((String)"Configuration").warn("Xml deserialization is disabled, please enable by setting allowXml to 'true'");
        return null;
    }

    protected Object getObjectReference(int ref) {
        if (this.isDebug) {
            this.trace.writeRef(ref);
        }
        return this.objectTable.get(ref);
    }

    protected String getStringReference(int ref) {
        String str = (String)this.stringTable.get(ref);
        if (Trace.amf && this.isDebug) {
            this.trace.writeStringRef(ref);
        }
        return str;
    }

    protected TraitsInfo getTraitReference(int ref) {
        if (Trace.amf && this.isDebug) {
            this.trace.writeTraitsInfoRef(ref);
        }
        return (TraitsInfo)this.traitsTable.get(ref);
    }

    protected int rememberObject(Object obj) {
        int id = this.objectTable.size();
        this.objectTable.add(obj);
        return id;
    }

    protected Object readObjectOneLevelDown(boolean nestCollectionLevelDown) throws ClassNotFoundException, IOException {
        this.increaseNestObjectLevel();
        if (nestCollectionLevelDown) {
            this.increaseNestCollectionLevel();
        }
        Object value = this.readObject();
        this.decreaseNestObjectLevel();
        if (nestCollectionLevelDown) {
            this.decreaseNestCollectionLevel();
        }
        return value;
    }
}

