/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.MessageException;
import flex.messaging.io.TypeMarshaller;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.util.MethodKey;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodMatcher {
    private final Map<MethodKey, Method> methodCache = new HashMap<MethodKey, Method>();
    private static final int ARGUMENT_CONVERSION_ERROR = 10006;
    private static final int CANNOT_INVOKE_METHOD = 10007;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(Class c, String methodName, List parameters) {
        Object thisMethodName2;
        Match bestMatch = new Match(methodName);
        Class[] suppliedParamTypes = MethodMatcher.paramTypes(parameters);
        MethodKey methodKey = new MethodKey(c, methodName, suppliedParamTypes);
        Method method = null;
        if (this.methodCache.containsKey(methodKey)) {
            method = this.methodCache.get(methodKey);
            bestMatch.matchedMethodName = thisMethodName2 = method.getName();
        } else {
            try {
                method = c.getMethod(methodName, suppliedParamTypes);
                thisMethodName2 = this.methodCache;
                synchronized (thisMethodName2) {
                    Method method2 = this.methodCache.get(methodKey);
                    if (method2 == null) {
                        this.methodCache.put(methodKey, method);
                    } else {
                        method = method2;
                    }
                }
            }
            catch (SecurityException thisMethodName2) {
            }
            catch (NoSuchMethodException thisMethodName2) {
                // empty catch block
            }
            if (method == null) {
                Method[] methods = c.getMethods();
                for (Method thisMethod : c.getMethods()) {
                    String thisMethodName3 = thisMethod.getName();
                    if (!thisMethodName3.equalsIgnoreCase(methodName)) continue;
                    Match currentMatch = new Match(methodName);
                    currentMatch.matchedMethodName = thisMethodName3;
                    if (bestMatch.matchedMethodName == null) {
                        bestMatch = currentMatch;
                    }
                    Class[] desiredParamTypes = thisMethod.getParameterTypes();
                    currentMatch.methodParamTypes = desiredParamTypes;
                    if (desiredParamTypes.length != suppliedParamTypes.length) continue;
                    currentMatch.matchedByNumberOfParams = true;
                    if (!bestMatch.matchedByNumberOfParams && bestMatch.matchedParamCount == 0) {
                        bestMatch = currentMatch;
                    }
                    MethodMatcher.convertParams(parameters, desiredParamTypes, currentMatch, false);
                    if (currentMatch.matchedParamCount >= bestMatch.matchedParamCount && currentMatch.exactMatchedParamCount >= bestMatch.exactMatchedParamCount) {
                        bestMatch = currentMatch;
                    }
                    if (currentMatch.matchedParamCount != desiredParamTypes.length || bestMatch != currentMatch) continue;
                    method = thisMethod;
                    Map<MethodKey, Method> map = this.methodCache;
                    synchronized (map) {
                        Method method2 = this.methodCache.get(methodKey);
                        if (method2 == null || method2 != method) {
                            this.methodCache.put(methodKey, method);
                        } else {
                            method = method2;
                        }
                    }
                }
            }
        }
        if (method == null) {
            MethodMatcher.methodNotFound(methodName, suppliedParamTypes, bestMatch);
        } else if (bestMatch.paramTypeConversionFailure != null) {
            MessageException me = new MessageException();
            me.setMessage(10006);
            me.setCode("Server.Processing");
            me.setRootCause(bestMatch.paramTypeConversionFailure);
            throw me;
        }
        Class[] desiredParamTypes = method.getParameterTypes();
        bestMatch.methodParamTypes = desiredParamTypes;
        MethodMatcher.convertParams(parameters, desiredParamTypes, bestMatch, true);
        return method;
    }

    public static void convertParams(List parameters, Class[] desiredParamTypes, Match currentMatch, boolean convert) {
        int matchCount = 0;
        int exactMatchCount = 0;
        currentMatch.matchedParamCount = 0;
        currentMatch.convertedSuppliedTypes = new Class[desiredParamTypes.length];
        TypeMarshaller marshaller = TypeMarshallingContext.getTypeMarshaller();
        for (int i = 0; i < desiredParamTypes.length; ++i) {
            Object param = parameters.get(i);
            if (param != null) {
                Class objClass;
                Object obj;
                block9: {
                    obj = null;
                    objClass = null;
                    if (marshaller != null) {
                        try {
                            obj = marshaller.convert(param, desiredParamTypes[i]);
                            break block9;
                        }
                        catch (MessageException ex) {
                            currentMatch.paramTypeConversionFailure = ex;
                            break;
                        }
                        catch (ClassCastException ex) {
                            currentMatch.paramTypeConversionFailure = ex;
                            break;
                        }
                        catch (Exception e) {
                            currentMatch.paramTypeConversionFailure = e;
                            break;
                        }
                    }
                    obj = param;
                }
                Class clazz = currentMatch.convertedSuppliedTypes[i] = obj != null ? (objClass = obj.getClass()) : null;
                if (objClass == null || !MethodMatcher.isAssignableFrom(desiredParamTypes[i], objClass)) break;
                if (MethodMatcher.isAssignableFrom(desiredParamTypes[i], param.getClass())) {
                    ++exactMatchCount;
                }
                if (convert) {
                    parameters.set(i, obj);
                }
                ++matchCount;
                continue;
            }
            ++matchCount;
        }
        currentMatch.matchedParamCount = matchCount;
        currentMatch.exactMatchedParamCount = exactMatchCount;
    }

    private static boolean isAssignableFrom(Class first, Class second) {
        return first.isAssignableFrom(second) || first == Integer.TYPE && Integer.class.isAssignableFrom(second) || first == Double.TYPE && Double.class.isAssignableFrom(second) || first == Long.TYPE && Long.class.isAssignableFrom(second) || first == Boolean.TYPE && Boolean.class.isAssignableFrom(second) || first == Character.TYPE && Character.class.isAssignableFrom(second) || first == Float.TYPE && Float.class.isAssignableFrom(second) || first == Short.TYPE && Short.class.isAssignableFrom(second) || first == Byte.TYPE && Byte.class.isAssignableFrom(second);
    }

    public static Class[] paramTypes(List parameters) {
        Class[] paramTypes = new Class[parameters.size()];
        for (int i = 0; i < paramTypes.length; ++i) {
            Object p = parameters.get(i);
            paramTypes[i] = p == null ? Object.class : p.getClass();
        }
        return paramTypes;
    }

    public static void methodNotFound(String methodName, Class[] suppliedParamTypes, Match bestMatch) {
        int errorCode = 10007;
        Object[] errorParams = new Object[]{methodName};
        String errorDetailVariant = "0";
        Object[] errorDetailParams = new Object[]{methodName};
        if (bestMatch.matchedMethodName != null) {
            int expectedParamCount;
            errorCode = 10007;
            errorParams = new Object[]{bestMatch.matchedMethodName};
            int suppliedParamCount = suppliedParamTypes.length;
            int n = expectedParamCount = bestMatch.methodParamTypes != null ? bestMatch.methodParamTypes.length : 0;
            if (suppliedParamCount != expectedParamCount) {
                errorDetailVariant = "1";
                errorDetailParams = new Object[]{new Integer(suppliedParamCount), new Integer(expectedParamCount)};
            } else {
                String suppliedTypes = bestMatch.listTypes(suppliedParamTypes);
                String convertedTypes = bestMatch.listConvertedTypes();
                String expectedTypes = bestMatch.listExpectedTypes();
                if (expectedTypes != null) {
                    if (suppliedTypes != null) {
                        if (convertedTypes != null) {
                            errorDetailVariant = "2";
                            errorDetailParams = new Object[]{expectedTypes, suppliedTypes, convertedTypes};
                        } else {
                            errorDetailVariant = "3";
                            errorDetailParams = new Object[]{expectedTypes, suppliedTypes};
                        }
                    } else {
                        errorDetailVariant = "4";
                        errorDetailParams = new Object[]{expectedTypes};
                    }
                } else {
                    errorDetailVariant = "5";
                    errorDetailParams = new Object[]{suppliedTypes};
                }
            }
        }
        MessageException ex = new MessageException();
        ex.setMessage(errorCode, errorParams);
        ex.setCode("Server.ResourceUnavailable");
        if (errorDetailVariant != null) {
            ex.setDetails(errorCode, errorDetailVariant, errorDetailParams);
        }
        if (bestMatch.paramTypeConversionFailure != null) {
            ex.setRootCause(bestMatch.paramTypeConversionFailure);
        }
        throw ex;
    }

    public static class Match {
        final String methodName;
        String matchedMethodName;
        boolean matchedByNumberOfParams;
        int matchedParamCount;
        int exactMatchedParamCount;
        Class[] methodParamTypes;
        Class[] convertedSuppliedTypes;
        Exception paramTypeConversionFailure;

        public Match(String name) {
            this.methodName = name;
        }

        public boolean matchedExactlyByName() {
            return this.matchedMethodName != null ? this.matchedMethodName.equals(this.methodName) : false;
        }

        public boolean matchedLooselyByName() {
            return this.matchedMethodName != null ? !this.matchedExactlyByName() && this.matchedMethodName.equalsIgnoreCase(this.methodName) : false;
        }

        public String listExpectedTypes() {
            return this.listTypes(this.methodParamTypes);
        }

        public String listConvertedTypes() {
            return this.listTypes(this.convertedSuppliedTypes);
        }

        public String listTypes(Class[] types) {
            if (types == null || types.length == 0) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < types.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((c = types[i]) != null) {
                    if (c.isArray()) {
                        c = c.getComponentType();
                        sb.append(c.getName()).append("[]");
                        continue;
                    }
                    sb.append(c.getName());
                    continue;
                }
                sb.append("null");
            }
            return sb.toString();
        }
    }
}

