/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.flex.compiler.tree.mxml;

import org.apache.flex.compiler.definitions.IParameterDefinition;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IFunctionCallNode;

/**
 * This AST node represents an MXML tag or attribute which specifies
 * event-handling code.
 * <p>
 * An {@link IMXMLEventSpecifierNode} has N child nodes representing the
 * ActionScript statements specified to handle the event. For example, for an
 * event attribute such as <code>click="doThis(event); doThat(event)"</code>,
 * the two children would be {@link IFunctionCallNode} objects.
 */
public interface IMXMLEventSpecifierNode extends IMXMLSpecifierNode
{
    /**
     * Gets the event-handling code as parsed ActionScript nodes.
     * 
     * @return The value as an array of {@link IASNode} objects.
     */
    IASNode[] getASNodes();

    /**
     * Gets the definition of the <code>event</code> argument of the implied
     * event handler method.
     * 
     * @return An {@link IParameterDefinition} object.
     */
    IParameterDefinition getEventParameterDefinition();

    /**
     * Determines whether the autogenerated event handler must be public.
     * 
     * @return <code>true</code> if a public handler is required.
     */
    boolean needsPublicHandler();
}
