/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.externals.pass;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import org.apache.flex.compiler.internal.codegen.externals.pass.AbstractCompilerPass;
import org.apache.flex.compiler.internal.codegen.externals.reference.ClassReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.FieldReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.FunctionReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.MethodReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.ParameterReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.ReferenceModel;

public class CollectImportsPass
extends AbstractCompilerPass {
    public CollectImportsPass(ReferenceModel model, AbstractCompiler compiler) {
        super(model, compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        for (ClassReference classReference : this.model.getClasses()) {
            this.collectClassImports(classReference);
        }
        for (FunctionReference functionReference : this.model.getFunctions()) {
            this.collectFunctionImports(functionReference);
        }
    }

    private void collectClassImports(ClassReference reference) {
        MethodReference constructor = reference.getConstructor();
        List<ClassReference> superClasses = reference.getSuperClasses();
        List<ClassReference> interfaces = reference.getInterfaces();
        List<ClassReference> extendedInterfaces = reference.getExtendedInterfaces();
        ArrayList<FieldReference> fields = reference.getAllFields();
        ArrayList<MethodReference> methods = reference.getAllMethods();
        for (ClassReference superClass : superClasses) {
            if (this.model.isExcludedClass(superClass) != null) continue;
            this.addClassImport(reference, superClass);
        }
        for (ClassReference _interface : interfaces) {
            if (this.model.isExcludedClass(_interface) != null) continue;
            this.addClassImport(reference, _interface);
        }
        for (ClassReference _interface : extendedInterfaces) {
            if (this.model.isExcludedClass(_interface) != null) continue;
            this.addClassImport(reference, _interface);
        }
        for (FieldReference field : fields) {
            if (field.isExcluded() != null) continue;
            this.addClassImport(reference, this.getType(field));
        }
        if (constructor != null) {
            for (ParameterReference parameterReference : constructor.getParameters()) {
                this.addClassImport(reference, this.getType(parameterReference));
            }
        }
        for (MethodReference method : methods) {
            if (method.isExcluded() != null) continue;
            this.addClassImport(reference, this.getReturnType(method));
            for (ParameterReference parameterReference : method.getParameters()) {
                this.addClassImport(reference, this.getType(parameterReference));
            }
        }
    }

    private void addClassImport(ClassReference thisReference, ClassReference referenceToImport) {
        if (this.canImport(referenceToImport)) {
            String thisPackageName = thisReference.getPackageName();
            String importPackageName = referenceToImport.getPackageName();
            if (!importPackageName.equals(thisPackageName)) {
                thisReference.addImport(referenceToImport);
            }
        }
    }

    private void collectFunctionImports(FunctionReference function) {
        if (function.isExcluded() == null) {
            ClassReference returnType = this.getReturnType(function);
            if (this.canImport(returnType)) {
                function.addImport(returnType);
            }
            for (ParameterReference parameterReference : function.getParameters()) {
                ClassReference type = this.getType(parameterReference);
                if (!this.canImport(type)) continue;
                function.addImport(type);
            }
        }
    }

    private ClassReference getType(FieldReference field) {
        return this.model.getClassReference(field.toTypeString());
    }

    private ClassReference getReturnType(MethodReference method) {
        return this.model.getClassReference(method.transformReturnString());
    }

    private ClassReference getReturnType(FunctionReference function) {
        return this.model.getClassReference(function.transformReturnString());
    }

    private ClassReference getType(ParameterReference parameter) {
        return this.model.getClassReference(parameter.getQualifiedName());
    }

    private boolean canImport(ClassReference reference) {
        return reference != null && reference.isQualifiedName() && this.model.isExcludedClass(reference) == null;
    }

    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return false;
    }

    public void visit(NodeTraversal t, Node n, Node parent) {
    }
}

