/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IStatementNode;

public class StatementEmitter
extends JSSubEmitter
implements ISubEmitter<IASNode> {
    public StatementEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IASNode node) {
        this.getWalker().walk(node);
        if (node.getNodeID() == ASTNodeID.ImportID) {
            return;
        }
        if (node.getParent().getNodeID() != ASTNodeID.LabledStatementID && node.getNodeID() != ASTNodeID.ConfigBlockID && !(node instanceof IStatementNode)) {
            this.startMapping((ISourceLocation)node, (ISourceLocation)node);
            this.write(ASEmitterTokens.SEMICOLON);
            this.endMapping((ISourceLocation)node);
        }
        if (!StatementEmitter.isLastStatement(node)) {
            this.writeNewline();
        }
    }

    protected static boolean isLastStatement(IASNode node) {
        return StatementEmitter.getChildIndex(node.getParent(), node) == node.getParent().getChildCount() - 1;
    }

    private static int getChildIndex(IASNode parent, IASNode node) {
        int len = parent.getChildCount();
        for (int i = 0; i < len; ++i) {
            if (parent.getChild(i) != node) continue;
            return i;
        }
        return -1;
    }
}

