/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IConditionalNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.ISwitchNode;
import org.apache.flex.compiler.tree.as.ITerminalNode;
import org.apache.flex.compiler.utils.ASNodeUtils;

public class SwitchEmitter
extends JSSubEmitter
implements ISubEmitter<ISwitchNode> {
    public SwitchEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(ISwitchNode node) {
        this.startMapping((ISourceLocation)node);
        this.writeToken(ASEmitterTokens.SWITCH);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.endMapping((ISourceLocation)node);
        IASNode expressionNode = node.getChild(0);
        this.getWalker().walk(expressionNode);
        this.startMapping((ISourceLocation)node, (ISourceLocation)expressionNode);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.endMapping((ISourceLocation)node);
        IASNode statementContentsNode = node.getStatementContentsNode();
        this.startMapping((ISourceLocation)statementContentsNode);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.endMapping((ISourceLocation)statementContentsNode);
        this.indentPush();
        this.writeNewline();
        IConditionalNode[] cnodes = ASNodeUtils.getCaseNodes(node);
        ITerminalNode dnode = ASNodeUtils.getDefaultNode(node);
        for (int i = 0; i < cnodes.length; ++i) {
            IConditionalNode casen = cnodes[i];
            IContainerNode cnode = (IContainerNode)casen.getChild(1);
            this.startMapping((ISourceLocation)casen);
            this.writeToken(ASEmitterTokens.CASE);
            this.endMapping((ISourceLocation)casen);
            IExpressionNode conditionalExpressionNode = casen.getConditionalExpressionNode();
            this.getWalker().walk((IASNode)conditionalExpressionNode);
            this.startMapping((ISourceLocation)casen, (ISourceLocation)conditionalExpressionNode);
            this.write(ASEmitterTokens.COLON);
            if (!EmitterUtils.isImplicit(cnode)) {
                this.write(ASEmitterTokens.SPACE);
            }
            this.endMapping((ISourceLocation)casen);
            this.getWalker().walk(casen.getStatementContentsNode());
            if (i == cnodes.length - 1 && dnode == null) {
                this.indentPop();
                this.writeNewline();
                continue;
            }
            this.writeNewline();
        }
        if (dnode != null) {
            IContainerNode cnode = (IContainerNode)dnode.getChild(0);
            this.startMapping((ISourceLocation)dnode);
            this.write(ASEmitterTokens.DEFAULT);
            this.write(ASEmitterTokens.COLON);
            if (!EmitterUtils.isImplicit(cnode)) {
                this.write(ASEmitterTokens.SPACE);
            }
            this.endMapping((ISourceLocation)dnode);
            this.getWalker().walk((IASNode)dnode);
            this.indentPop();
            this.writeNewline();
        }
        this.startMapping((ISourceLocation)node, node.getEndLine(), node.getEndColumn() - 1);
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.endMapping((ISourceLocation)node);
    }
}

