/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.fxg.dom.richtext;

import java.util.Collection;
import org.apache.flex.compiler.fxg.dom.IFXGNode;
import org.apache.flex.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.flex.compiler.internal.fxg.dom.richtext.AbstractRichTextLeafNode;
import org.apache.flex.compiler.internal.fxg.dom.types.NumberPercentAuto;
import org.apache.flex.compiler.problems.FXGUnknownAttributeValueProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;

public class ImgNode
extends AbstractRichTextLeafNode {
    public NumberPercentAuto width = NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
    public NumberPercentAuto height = NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
    public String source = "";

    @Override
    public String getNodeName() {
        return "img";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("width".equals(name)) {
            this.width = this.getNumberPercentAuto(this, name, value, this.width.getNumberPercentAutoAsEnum(), problems);
        } else if ("height".equals(name)) {
            this.height = this.getNumberPercentAuto(this, name, value, this.height.getNumberPercentAutoAsEnum(), problems);
        } else if ("source".equals(name)) {
            this.source = value;
        } else {
            super.setAttribute(name, value, problems);
            return;
        }
        this.rememberAttribute(name, value);
    }

    private NumberPercentAuto getNumberPercentAuto(IFXGNode node, String name, String value, NumberPercentAuto.NumberPercentAutoAsEnum defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return NumberPercentAuto.newInstance(DOMParserHelper.parseNumberPercent(this, value, Double.MIN_VALUE, Double.MAX_VALUE));
        }
        catch (Exception e) {
            if ("auto".equals(value)) {
                return NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return NumberPercentAuto.newInstance(defaultValue);
        }
    }
}

