/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.flex.compiler.internal.as.codegen.MXMLClassDirectiveProcessor;
import org.apache.flex.compiler.internal.scopes.MXMLFileScope;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLLibraryNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLModelNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLPrivateNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.mxml.IMXMLTagAttributeData;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.problems.MXMLPrivateTagLocationProblem;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.mxml.IMXMLDocumentNode;

public class MXMLDocumentNode
extends MXMLClassDefinitionNode
implements IMXMLDocumentNode {
    public MXMLClassDirectiveProcessor cdp;
    protected final Map<String, String> rootAttributes = new HashMap<String, String>();
    private static ImmutableSet<String> SKIP_ATTRIBUTES = ImmutableSet.of((Object)"excludeFrom", (Object)"includeIn", (Object)"itemCreationPolicy", (Object)"frameRate", (Object)"pageTitle", (Object)"preloader", (Object[])new String[]{"rsl", "runtimeDPIProvider", "scriptRecursionLimit", "scriptTimeLimit", "splashScreenImage", "theme", "useDirectBlit", "useGPU", "usePreloader", "Library"});

    public MXMLDocumentNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLDocumentID;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLFileScope fileScope = builder.getFileScope();
        MXMLNodeBase childNode = null;
        if (fileScope.isLibraryTag(childTag)) {
            childNode = new MXMLLibraryNode(this);
        } else if (fileScope.isModelTag(childTag)) {
            childNode = new MXMLModelNode(this);
        } else if (fileScope.isPrivateTag(childTag)) {
            if (childTag.getNextSibling(true) != null) {
                MXMLPrivateTagLocationProblem problem = new MXMLPrivateTagLocationProblem(childTag);
                builder.addProblem(problem);
            } else {
                childNode = new MXMLPrivateNode(this);
            }
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
        if (childNode != null) {
            childNode.initializeFromTag(builder, childTag);
            info.addChildNode(childNode);
        }
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        String name = attribute.getName();
        this.rootAttributes.put(name, attribute.getRawValue());
        if (!SKIP_ATTRIBUTES.contains((Object)name)) {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }
}

