/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import com.google.common.truth.ReflectionUtil;
import com.google.common.truth.StringUtil;
import com.google.common.truth.TestVerb;
import java.lang.reflect.Field;

public class Subject<S extends Subject<S, T>, T> {
    protected final FailureStrategy failureStrategy;
    private final T subject;
    private String customName = null;

    public Subject(FailureStrategy failureStrategy, T subject) {
        this.failureStrategy = failureStrategy;
        this.subject = subject;
    }

    protected String internalCustomName() {
        return this.customName;
    }

    public S named(String name) {
        this.customName = (String)Preconditions.checkNotNull((Object)name, (Object)"Name passed to named() cannot be null.");
        return (S)this;
    }

    @Deprecated
    public S labeled(String label) {
        return this.named(label);
    }

    @Deprecated
    public void is(Object other) {
        this.isEqualTo(other);
    }

    public void isNull() {
        if (this.getSubject() != null) {
            this.fail("is null");
        }
    }

    public void isNotNull() {
        if (this.getSubject() == null) {
            this.failWithoutSubject("is a non-null reference");
        }
    }

    public void isEqualTo(Object other) {
        if (!Objects.equal(this.getSubject(), (Object)other)) {
            this.fail("is equal to", other);
        }
    }

    public void isNotEqualTo(Object other) {
        if (Objects.equal(this.getSubject(), (Object)other)) {
            this.fail("is not equal to", other);
        }
    }

    public void isSameAs(Object other) {
        if (this.getSubject() != other) {
            this.fail("is the same instance as", other);
        }
    }

    public void isNotSameAs(Object other) {
        if (this.getSubject() == other) {
            this.fail("is not the same instance as", other);
        }
    }

    @Deprecated
    public void isA(Class<?> clazz) {
        this.isInstanceOf(clazz);
    }

    @Deprecated
    public void isNotA(Class<?> clazz) {
        this.isNotInstanceOf(clazz);
    }

    public void isInstanceOf(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (!Platform.isInstanceOfType(this.getSubject(), clazz)) {
            if (this.getSubject() != null) {
                this.failWithBadResults("is an instance of", clazz.getName(), "is an instance of", this.getSubject().getClass().getName());
            } else {
                this.fail("is an instance of", (Object)clazz.getName());
            }
        }
    }

    public void isNotInstanceOf(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (this.getSubject() == null) {
            return;
        }
        if (Platform.isInstanceOfType(this.getSubject(), clazz)) {
            this.failWithRawMessage("%s expected not to be an instance of %s, but was.", this.getDisplaySubject(), clazz.getName());
        }
    }

    protected T getSubject() {
        return this.subject;
    }

    protected String getDisplaySubject() {
        String name = this.customName == null ? "" : "\"" + this.customName + "\" ";
        return name + "<" + this.getSubject() + ">";
    }

    protected TestVerb check() {
        return new TestVerb(this.failureStrategy);
    }

    protected void fail(String verb) {
        this.failureStrategy.fail("Not true that " + this.getDisplaySubject() + " " + verb);
    }

    protected void fail(String verb, Object part) {
        boolean needsDisambiguation;
        StringBuilder message = new StringBuilder("Not true that ").append(this.getDisplaySubject()).append(" ");
        boolean bl = needsDisambiguation = part != null && this.getSubject() != null && this.getSubject().toString().equals(part.toString()) && !this.getSubject().getClass().equals(part.getClass());
        if (needsDisambiguation) {
            message.append("(").append(this.getSubject().getClass().getName()).append(") ");
        }
        message.append(verb).append(" <").append(part).append(">");
        if (needsDisambiguation) {
            message.append(" (").append(part.getClass().getName()).append(")");
        }
        this.failureStrategy.fail(message.toString());
    }

    protected void fail(String verb, Object ... messageParts) {
        if (messageParts.length == 0) {
            this.fail(verb);
        } else if (messageParts.length == 1) {
            this.fail(verb, messageParts[0]);
        } else {
            StringBuilder message = new StringBuilder("Not true that ");
            message.append(this.getDisplaySubject()).append(" ").append(verb);
            for (Object part : messageParts) {
                message.append(" <").append(part).append(">");
            }
            this.failureStrategy.fail(message.toString());
        }
    }

    protected void failWithBadResults(String verb, Object expected, String failVerb, Object actual) {
        String message = StringUtil.format("Not true that %s %s <%s>. It %s <%s>", this.getDisplaySubject(), verb, expected, failVerb, actual == null ? "null reference" : actual);
        this.failureStrategy.fail(message);
    }

    protected void failWithCustomSubject(String verb, Object expected, Object actual) {
        String message = StringUtil.format("Not true that <%s> %s <%s>", actual == null ? "null reference" : actual, verb, expected);
        this.failureStrategy.fail(message);
    }

    protected void failWithoutSubject(String verb) {
        String subject = this.customName == null ? "the subject" : "\"" + this.customName + "\"";
        this.failureStrategy.fail(StringUtil.format("Not true that %s %s", subject, verb));
    }

    protected void failWithRawMessage(String message, Object ... parameters) {
        this.failureStrategy.fail(StringUtil.format(message, parameters));
    }

    @GwtIncompatible(value="java.lang.reflect.Field")
    public HasField hasField(final String fieldName) {
        Field field;
        final T subject = this.getSubject();
        if (subject == null) {
            this.failureStrategy.fail("Cannot determine a field name from a null object.");
            return new HasField(){

                @Override
                public void withValue(Object value) {
                    Subject.this.fail("Cannot test the presence of a value in a null object.");
                }
            };
        }
        final Class<?> subjectClass = subject.getClass();
        try {
            field = ReflectionUtil.getField(subjectClass, fieldName);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            StringBuilder message = new StringBuilder("Not true that ");
            message.append("<").append(subjectClass.getSimpleName()).append(">");
            message.append(" has a field named <").append(fieldName).append(">");
            this.failureStrategy.fail(message.toString());
            return new HasField(){

                @Override
                public void withValue(Object value) {
                    Subject.this.fail("Cannot test the presence of a value in a non-present field.");
                }
            };
        }
        return new HasField(){

            @Override
            public void withValue(Object expected) {
                try {
                    Object actual = field.get(subject);
                    if (expected == actual || expected != null && expected.equals(actual)) {
                        return;
                    }
                    StringBuilder message = new StringBuilder("Not true that ");
                    message.append("<").append(subjectClass.getSimpleName()).append(">'s");
                    message.append(" field <").append(fieldName).append(">");
                    message.append(" contains expected value <").append(expected).append(">.");
                    message.append(" It contains value <").append(actual).append(">");
                    Subject.this.failureStrategy.fail(message.toString());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Error checking field " + fieldName + " while testing for value " + expected);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Cannot access field " + fieldName + " to test for value " + expected);
                }
            }
        };
    }

    @Deprecated
    public boolean equals(Object o) {
        this.isEqualTo(o);
        return false;
    }

    @Deprecated
    public int hashCode() {
        throw new UnsupportedOperationException("Equals/Hashcode is not supported on Subjects. Their only use is as a holder of propositions. Use of equals() is deprecated and forwards to isEqualTo() and hashCode() is disallowed.");
    }

    @GwtIncompatible(value="java.lang.reflect.Field")
    public static interface HasField {
        public void withValue(Object var1);
    }
}

