/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.agents.api.configuration.ConfigOption;
import org.apache.flink.agents.api.configuration.Configuration;

public class AgentConfiguration
implements Configuration {
    private final Map<String, Object> confData;

    public AgentConfiguration() {
        this.confData = new HashMap<String, Object>();
    }

    public AgentConfiguration(Map<String, Object> confData) {
        this.confData = AgentConfiguration.flatten(confData, "", ".");
    }

    public Map<String, Object> getConfData() {
        return this.confData;
    }

    @Override
    public void setStr(String key, String value) {
        this.confData.put(key, value);
    }

    @Override
    public void setInt(String key, int value) {
        this.confData.put(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.confData.put(key, value);
    }

    @Override
    public void setFloat(String key, float value) {
        this.confData.put(key, Float.valueOf(value));
    }

    @Override
    public void setDouble(String key, double value) {
        this.confData.put(key, value);
    }

    @Override
    public void setBool(String key, boolean value) {
        this.confData.put(key, value);
    }

    @Override
    public <T> void set(ConfigOption<T> option, T value) {
        if (value == null && option.getDefaultValue() != null) {
            return;
        }
        this.confData.put(option.getKey(), value);
    }

    @Override
    public Integer getInt(String key, Integer defaultValue) {
        return Optional.ofNullable(this.confData.get(key)).map(Object::toString).map(Integer::parseInt).orElse(defaultValue);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return Optional.ofNullable(this.confData.get(key)).map(Object::toString).map(Long::parseLong).orElse(defaultValue);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        return Optional.ofNullable(this.confData.get(key)).map(Object::toString).map(Float::parseFloat).orElse(defaultValue);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        return Optional.ofNullable(this.confData.get(key)).map(Object::toString).map(Double::parseDouble).orElse(defaultValue);
    }

    @Override
    public Boolean getBool(String key, Boolean defaultValue) {
        return Optional.ofNullable(this.confData.get(key)).map(Object::toString).map(Boolean::valueOf).orElse(defaultValue);
    }

    @Override
    public String getStr(String key, String defaultValue) {
        return Optional.ofNullable(this.confData.get(key)).map(Object::toString).orElse(defaultValue);
    }

    @Override
    public <T> T get(ConfigOption<T> option) {
        Object rawValue = this.confData.get(option.getKey());
        if (rawValue == null) {
            return option.getDefaultValue();
        }
        Class<T> targetType = option.getType();
        if (targetType.isAssignableFrom(rawValue.getClass())) {
            return targetType.cast(rawValue);
        }
        if (String.class.equals(targetType)) {
            return targetType.cast(rawValue.toString());
        }
        if (Integer.class.equals(targetType)) {
            return targetType.cast(Integer.parseInt(rawValue.toString()));
        }
        if (Long.class.equals(targetType)) {
            return targetType.cast(Long.parseLong(rawValue.toString()));
        }
        if (Float.class.equals(targetType)) {
            return targetType.cast(Float.valueOf(Float.parseFloat(rawValue.toString())));
        }
        if (Double.class.equals(targetType)) {
            return targetType.cast(Double.parseDouble(rawValue.toString()));
        }
        if (Boolean.class.equals(targetType)) {
            return targetType.cast(Boolean.parseBoolean(rawValue.toString()));
        }
        throw new ClassCastException("Unsupported type conversion from " + rawValue.getClass().getName() + " to " + targetType.getName());
    }

    private static Map<String, Object> flatten(Map<String, Object> config, String keyPrefix, String keySeparator) {
        HashMap<String, Object> flattenedMap = new HashMap<String, Object>();
        config.forEach((key, value) -> {
            String flattenedKey = keyPrefix + key;
            if (value instanceof Map) {
                Map e = (Map)value;
                flattenedMap.putAll(AgentConfiguration.flatten(e, flattenedKey + keySeparator, keySeparator));
            } else {
                flattenedMap.put(flattenedKey, value);
            }
        });
        return flattenedMap;
    }
}

