//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.17.3
// source: request-reply.proto

package protocol

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type FromFunction_PersistedValueMutation_MutationType int32

const (
	FromFunction_PersistedValueMutation_DELETE FromFunction_PersistedValueMutation_MutationType = 0
	FromFunction_PersistedValueMutation_MODIFY FromFunction_PersistedValueMutation_MutationType = 1
)

// Enum value maps for FromFunction_PersistedValueMutation_MutationType.
var (
	FromFunction_PersistedValueMutation_MutationType_name = map[int32]string{
		0: "DELETE",
		1: "MODIFY",
	}
	FromFunction_PersistedValueMutation_MutationType_value = map[string]int32{
		"DELETE": 0,
		"MODIFY": 1,
	}
)

func (x FromFunction_PersistedValueMutation_MutationType) Enum() *FromFunction_PersistedValueMutation_MutationType {
	p := new(FromFunction_PersistedValueMutation_MutationType)
	*p = x
	return p
}

func (x FromFunction_PersistedValueMutation_MutationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FromFunction_PersistedValueMutation_MutationType) Descriptor() protoreflect.EnumDescriptor {
	return file_request_reply_proto_enumTypes[0].Descriptor()
}

func (FromFunction_PersistedValueMutation_MutationType) Type() protoreflect.EnumType {
	return &file_request_reply_proto_enumTypes[0]
}

func (x FromFunction_PersistedValueMutation_MutationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FromFunction_PersistedValueMutation_MutationType.Descriptor instead.
func (FromFunction_PersistedValueMutation_MutationType) EnumDescriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3, 0, 0}
}

type FromFunction_ExpirationSpec_ExpireMode int32

const (
	FromFunction_ExpirationSpec_NONE         FromFunction_ExpirationSpec_ExpireMode = 0
	FromFunction_ExpirationSpec_AFTER_WRITE  FromFunction_ExpirationSpec_ExpireMode = 1
	FromFunction_ExpirationSpec_AFTER_INVOKE FromFunction_ExpirationSpec_ExpireMode = 2
)

// Enum value maps for FromFunction_ExpirationSpec_ExpireMode.
var (
	FromFunction_ExpirationSpec_ExpireMode_name = map[int32]string{
		0: "NONE",
		1: "AFTER_WRITE",
		2: "AFTER_INVOKE",
	}
	FromFunction_ExpirationSpec_ExpireMode_value = map[string]int32{
		"NONE":         0,
		"AFTER_WRITE":  1,
		"AFTER_INVOKE": 2,
	}
)

func (x FromFunction_ExpirationSpec_ExpireMode) Enum() *FromFunction_ExpirationSpec_ExpireMode {
	p := new(FromFunction_ExpirationSpec_ExpireMode)
	*p = x
	return p
}

func (x FromFunction_ExpirationSpec_ExpireMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FromFunction_ExpirationSpec_ExpireMode) Descriptor() protoreflect.EnumDescriptor {
	return file_request_reply_proto_enumTypes[1].Descriptor()
}

func (FromFunction_ExpirationSpec_ExpireMode) Type() protoreflect.EnumType {
	return &file_request_reply_proto_enumTypes[1]
}

func (x FromFunction_ExpirationSpec_ExpireMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FromFunction_ExpirationSpec_ExpireMode.Descriptor instead.
func (FromFunction_ExpirationSpec_ExpireMode) EnumDescriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3, 5, 0}
}

// An Address is the unique identity of an individual StatefulFunction, containing
// a function's type and an unique identifier within the type. The function's
// type denotes the "class" of function to invoke, while the unique identifier addresses the
// invocation to a specific function instance.
type Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Namespace string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Type      string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Id        string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *Address) Reset() {
	*x = Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{0}
}

func (x *Address) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *Address) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Address) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type TypedValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Typename string `protobuf:"bytes,1,opt,name=typename,proto3" json:"typename,omitempty"`
	// has_value is set to differentiate a zero length value bytes explicitly set,
	// or a non existing value.
	HasValue bool   `protobuf:"varint,2,opt,name=has_value,json=hasValue,proto3" json:"has_value,omitempty"`
	Value    []byte `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *TypedValue) Reset() {
	*x = TypedValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TypedValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypedValue) ProtoMessage() {}

func (x *TypedValue) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypedValue.ProtoReflect.Descriptor instead.
func (*TypedValue) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{1}
}

func (x *TypedValue) GetTypename() string {
	if x != nil {
		return x.Typename
	}
	return ""
}

func (x *TypedValue) GetHasValue() bool {
	if x != nil {
		return x.HasValue
	}
	return false
}

func (x *TypedValue) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// The following section contains all the message types that are sent
// from Flink to a remote function.
type ToFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Request:
	//	*ToFunction_Invocation_
	Request isToFunction_Request `protobuf_oneof:"request"`
}

func (x *ToFunction) Reset() {
	*x = ToFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToFunction) ProtoMessage() {}

func (x *ToFunction) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToFunction.ProtoReflect.Descriptor instead.
func (*ToFunction) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{2}
}

func (m *ToFunction) GetRequest() isToFunction_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *ToFunction) GetInvocation() *ToFunction_InvocationBatchRequest {
	if x, ok := x.GetRequest().(*ToFunction_Invocation_); ok {
		return x.Invocation
	}
	return nil
}

type isToFunction_Request interface {
	isToFunction_Request()
}

type ToFunction_Invocation_ struct {
	Invocation *ToFunction_InvocationBatchRequest `protobuf:"bytes,100,opt,name=invocation,proto3,oneof"`
}

func (*ToFunction_Invocation_) isToFunction_Request() {}

// The following section contains messages sent from a remote function back to Flink.
type FromFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Response sent from the function, as a result of an io.statefun.sdk.reqreply.ToFunction.InvocationBatchRequest.
	// It can be one of the following types:
	//   - io.statefun.sdk.reqreply.FromFunction.InvocationResponse
	//   - io.statefun.sdk.reqreply.FromFunction.IncompleteInvocationContext
	//
	// Types that are assignable to Response:
	//	*FromFunction_InvocationResult
	//	*FromFunction_IncompleteInvocationContext_
	Response isFromFunction_Response `protobuf_oneof:"response"`
}

func (x *FromFunction) Reset() {
	*x = FromFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FromFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FromFunction) ProtoMessage() {}

func (x *FromFunction) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FromFunction.ProtoReflect.Descriptor instead.
func (*FromFunction) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3}
}

func (m *FromFunction) GetResponse() isFromFunction_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *FromFunction) GetInvocationResult() *FromFunction_InvocationResponse {
	if x, ok := x.GetResponse().(*FromFunction_InvocationResult); ok {
		return x.InvocationResult
	}
	return nil
}

func (x *FromFunction) GetIncompleteInvocationContext() *FromFunction_IncompleteInvocationContext {
	if x, ok := x.GetResponse().(*FromFunction_IncompleteInvocationContext_); ok {
		return x.IncompleteInvocationContext
	}
	return nil
}

type isFromFunction_Response interface {
	isFromFunction_Response()
}

type FromFunction_InvocationResult struct {
	InvocationResult *FromFunction_InvocationResponse `protobuf:"bytes,100,opt,name=invocation_result,json=invocationResult,proto3,oneof"`
}

type FromFunction_IncompleteInvocationContext_ struct {
	IncompleteInvocationContext *FromFunction_IncompleteInvocationContext `protobuf:"bytes,101,opt,name=incomplete_invocation_context,json=incompleteInvocationContext,proto3,oneof"`
}

func (*FromFunction_InvocationResult) isFromFunction_Response() {}

func (*FromFunction_IncompleteInvocationContext_) isFromFunction_Response() {}

// PersistedValue represents a PersistedValue's value that is managed by Flink on behalf of a remote function.
type ToFunction_PersistedValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the persisted state.
	StateName string `protobuf:"bytes,1,opt,name=state_name,json=stateName,proto3" json:"state_name,omitempty"`
	// The serialized state value
	StateValue *TypedValue `protobuf:"bytes,2,opt,name=state_value,json=stateValue,proto3" json:"state_value,omitempty"`
}

func (x *ToFunction_PersistedValue) Reset() {
	*x = ToFunction_PersistedValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToFunction_PersistedValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToFunction_PersistedValue) ProtoMessage() {}

func (x *ToFunction_PersistedValue) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToFunction_PersistedValue.ProtoReflect.Descriptor instead.
func (*ToFunction_PersistedValue) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ToFunction_PersistedValue) GetStateName() string {
	if x != nil {
		return x.StateName
	}
	return ""
}

func (x *ToFunction_PersistedValue) GetStateValue() *TypedValue {
	if x != nil {
		return x.StateValue
	}
	return nil
}

// Invocation represents a remote function call, it associated with an (optional) return address,
// and an argument.
type ToFunction_Invocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The address of the function that requested the invocation (possibly absent)
	Caller *Address `protobuf:"bytes,1,opt,name=caller,proto3" json:"caller,omitempty"`
	// The invocation argument (aka the message sent to the target function)
	Argument *TypedValue `protobuf:"bytes,2,opt,name=argument,proto3" json:"argument,omitempty"`
}

func (x *ToFunction_Invocation) Reset() {
	*x = ToFunction_Invocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToFunction_Invocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToFunction_Invocation) ProtoMessage() {}

func (x *ToFunction_Invocation) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToFunction_Invocation.ProtoReflect.Descriptor instead.
func (*ToFunction_Invocation) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{2, 1}
}

func (x *ToFunction_Invocation) GetCaller() *Address {
	if x != nil {
		return x.Caller
	}
	return nil
}

func (x *ToFunction_Invocation) GetArgument() *TypedValue {
	if x != nil {
		return x.Argument
	}
	return nil
}

// InvocationBatchRequest represents a request to invoke a remote function. It is always associated with a target
// address (the function to invoke), and a list of values for registered state.
type ToFunction_InvocationBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The address of the function to invoke
	Target *Address `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// A list of PersistedValues that were registered as a persisted state.
	State []*ToFunction_PersistedValue `protobuf:"bytes,2,rep,name=state,proto3" json:"state,omitempty"`
	// A non empty (at least one) list of invocations
	Invocations []*ToFunction_Invocation `protobuf:"bytes,3,rep,name=invocations,proto3" json:"invocations,omitempty"`
}

func (x *ToFunction_InvocationBatchRequest) Reset() {
	*x = ToFunction_InvocationBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToFunction_InvocationBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToFunction_InvocationBatchRequest) ProtoMessage() {}

func (x *ToFunction_InvocationBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToFunction_InvocationBatchRequest.ProtoReflect.Descriptor instead.
func (*ToFunction_InvocationBatchRequest) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{2, 2}
}

func (x *ToFunction_InvocationBatchRequest) GetTarget() *Address {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *ToFunction_InvocationBatchRequest) GetState() []*ToFunction_PersistedValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *ToFunction_InvocationBatchRequest) GetInvocations() []*ToFunction_Invocation {
	if x != nil {
		return x.Invocations
	}
	return nil
}

// MutatePersistedValueCommand represents a command sent from a remote function to Flink,
// requesting a change to a persisted value.
type FromFunction_PersistedValueMutation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MutationType FromFunction_PersistedValueMutation_MutationType `protobuf:"varint,1,opt,name=mutation_type,json=mutationType,proto3,enum=io.statefun.sdk.reqreply.FromFunction_PersistedValueMutation_MutationType" json:"mutation_type,omitempty"`
	StateName    string                                           `protobuf:"bytes,2,opt,name=state_name,json=stateName,proto3" json:"state_name,omitempty"`
	StateValue   *TypedValue                                      `protobuf:"bytes,3,opt,name=state_value,json=stateValue,proto3" json:"state_value,omitempty"`
}

func (x *FromFunction_PersistedValueMutation) Reset() {
	*x = FromFunction_PersistedValueMutation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FromFunction_PersistedValueMutation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FromFunction_PersistedValueMutation) ProtoMessage() {}

func (x *FromFunction_PersistedValueMutation) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FromFunction_PersistedValueMutation.ProtoReflect.Descriptor instead.
func (*FromFunction_PersistedValueMutation) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3, 0}
}

func (x *FromFunction_PersistedValueMutation) GetMutationType() FromFunction_PersistedValueMutation_MutationType {
	if x != nil {
		return x.MutationType
	}
	return FromFunction_PersistedValueMutation_DELETE
}

func (x *FromFunction_PersistedValueMutation) GetStateName() string {
	if x != nil {
		return x.StateName
	}
	return ""
}

func (x *FromFunction_PersistedValueMutation) GetStateValue() *TypedValue {
	if x != nil {
		return x.StateValue
	}
	return nil
}

// Invocation represents a remote function call, it associated with a (mandatory) target address,
// and an argument.
type FromFunction_Invocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target function to invoke
	Target *Address `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// The invocation argument (aka the message sent to the target function)
	Argument *TypedValue `protobuf:"bytes,2,opt,name=argument,proto3" json:"argument,omitempty"`
}

func (x *FromFunction_Invocation) Reset() {
	*x = FromFunction_Invocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FromFunction_Invocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FromFunction_Invocation) ProtoMessage() {}

func (x *FromFunction_Invocation) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FromFunction_Invocation.ProtoReflect.Descriptor instead.
func (*FromFunction_Invocation) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3, 1}
}

func (x *FromFunction_Invocation) GetTarget() *Address {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *FromFunction_Invocation) GetArgument() *TypedValue {
	if x != nil {
		return x.Argument
	}
	return nil
}

// DelayedInvocation represents a delayed remote function call with a target address, an argument
// and a delay in milliseconds, after which this message to be sent.
type FromFunction_DelayedInvocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// a boolean value (default false) that indicates rather this is a regular delayed message, or (true) a message
	// cancellation request.
	// in case of a regular delayed message all other fields are expected to be preset, otherwise only the
	// cancellation_token is expected
	IsCancellationRequest bool `protobuf:"varint,10,opt,name=is_cancellation_request,json=isCancellationRequest,proto3" json:"is_cancellation_request,omitempty"`
	// an optional cancellation token that can be used to request the "unsending" of a delayed message.
	CancellationToken string `protobuf:"bytes,11,opt,name=cancellation_token,json=cancellationToken,proto3" json:"cancellation_token,omitempty"`
	// the amount of milliseconds to wait before sending this message
	DelayInMs int64 `protobuf:"varint,1,opt,name=delay_in_ms,json=delayInMs,proto3" json:"delay_in_ms,omitempty"`
	// the target address to send this message to
	Target *Address `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	// the invocation argument
	Argument *TypedValue `protobuf:"bytes,3,opt,name=argument,proto3" json:"argument,omitempty"`
}

func (x *FromFunction_DelayedInvocation) Reset() {
	*x = FromFunction_DelayedInvocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FromFunction_DelayedInvocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FromFunction_DelayedInvocation) ProtoMessage() {}

func (x *FromFunction_DelayedInvocation) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FromFunction_DelayedInvocation.ProtoReflect.Descriptor instead.
func (*FromFunction_DelayedInvocation) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3, 2}
}

func (x *FromFunction_DelayedInvocation) GetIsCancellationRequest() bool {
	if x != nil {
		return x.IsCancellationRequest
	}
	return false
}

func (x *FromFunction_DelayedInvocation) GetCancellationToken() string {
	if x != nil {
		return x.CancellationToken
	}
	return ""
}

func (x *FromFunction_DelayedInvocation) GetDelayInMs() int64 {
	if x != nil {
		return x.DelayInMs
	}
	return 0
}

func (x *FromFunction_DelayedInvocation) GetTarget() *Address {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *FromFunction_DelayedInvocation) GetArgument() *TypedValue {
	if x != nil {
		return x.Argument
	}
	return nil
}

// EgressMessage an argument to forward to an egress.
// An egress is identified by a namespace and type (see EgressIdentifier SDK class).
// The argument is an io.statefun.sdk.reqreply.TypedValue.
type FromFunction_EgressMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target egress namespace
	EgressNamespace string `protobuf:"bytes,1,opt,name=egress_namespace,json=egressNamespace,proto3" json:"egress_namespace,omitempty"`
	// The target egress type
	EgressType string `protobuf:"bytes,2,opt,name=egress_type,json=egressType,proto3" json:"egress_type,omitempty"`
	// egress argument
	Argument *TypedValue `protobuf:"bytes,3,opt,name=argument,proto3" json:"argument,omitempty"`
}

func (x *FromFunction_EgressMessage) Reset() {
	*x = FromFunction_EgressMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FromFunction_EgressMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FromFunction_EgressMessage) ProtoMessage() {}

func (x *FromFunction_EgressMessage) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FromFunction_EgressMessage.ProtoReflect.Descriptor instead.
func (*FromFunction_EgressMessage) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3, 3}
}

func (x *FromFunction_EgressMessage) GetEgressNamespace() string {
	if x != nil {
		return x.EgressNamespace
	}
	return ""
}

func (x *FromFunction_EgressMessage) GetEgressType() string {
	if x != nil {
		return x.EgressType
	}
	return ""
}

func (x *FromFunction_EgressMessage) GetArgument() *TypedValue {
	if x != nil {
		return x.Argument
	}
	return nil
}

// InvocationResponse represents a result of an io.statefun.sdk.reqreply.ToFunction.InvocationBatchRequest
// it contains a list of state mutation to preform as a result of computing this batch, and a list of outgoing messages.
type FromFunction_InvocationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StateMutations     []*FromFunction_PersistedValueMutation `protobuf:"bytes,1,rep,name=state_mutations,json=stateMutations,proto3" json:"state_mutations,omitempty"`
	OutgoingMessages   []*FromFunction_Invocation             `protobuf:"bytes,2,rep,name=outgoing_messages,json=outgoingMessages,proto3" json:"outgoing_messages,omitempty"`
	DelayedInvocations []*FromFunction_DelayedInvocation      `protobuf:"bytes,3,rep,name=delayed_invocations,json=delayedInvocations,proto3" json:"delayed_invocations,omitempty"`
	OutgoingEgresses   []*FromFunction_EgressMessage          `protobuf:"bytes,4,rep,name=outgoing_egresses,json=outgoingEgresses,proto3" json:"outgoing_egresses,omitempty"`
}

func (x *FromFunction_InvocationResponse) Reset() {
	*x = FromFunction_InvocationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FromFunction_InvocationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FromFunction_InvocationResponse) ProtoMessage() {}

func (x *FromFunction_InvocationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FromFunction_InvocationResponse.ProtoReflect.Descriptor instead.
func (*FromFunction_InvocationResponse) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3, 4}
}

func (x *FromFunction_InvocationResponse) GetStateMutations() []*FromFunction_PersistedValueMutation {
	if x != nil {
		return x.StateMutations
	}
	return nil
}

func (x *FromFunction_InvocationResponse) GetOutgoingMessages() []*FromFunction_Invocation {
	if x != nil {
		return x.OutgoingMessages
	}
	return nil
}

func (x *FromFunction_InvocationResponse) GetDelayedInvocations() []*FromFunction_DelayedInvocation {
	if x != nil {
		return x.DelayedInvocations
	}
	return nil
}

func (x *FromFunction_InvocationResponse) GetOutgoingEgresses() []*FromFunction_EgressMessage {
	if x != nil {
		return x.OutgoingEgresses
	}
	return nil
}

// ExpirationSpec represents TTL (Time-To-Live) configuration for persisted states.
type FromFunction_ExpirationSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mode              FromFunction_ExpirationSpec_ExpireMode `protobuf:"varint,1,opt,name=mode,proto3,enum=io.statefun.sdk.reqreply.FromFunction_ExpirationSpec_ExpireMode" json:"mode,omitempty"`
	ExpireAfterMillis int64                                  `protobuf:"varint,2,opt,name=expire_after_millis,json=expireAfterMillis,proto3" json:"expire_after_millis,omitempty"`
}

func (x *FromFunction_ExpirationSpec) Reset() {
	*x = FromFunction_ExpirationSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FromFunction_ExpirationSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FromFunction_ExpirationSpec) ProtoMessage() {}

func (x *FromFunction_ExpirationSpec) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FromFunction_ExpirationSpec.ProtoReflect.Descriptor instead.
func (*FromFunction_ExpirationSpec) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3, 5}
}

func (x *FromFunction_ExpirationSpec) GetMode() FromFunction_ExpirationSpec_ExpireMode {
	if x != nil {
		return x.Mode
	}
	return FromFunction_ExpirationSpec_NONE
}

func (x *FromFunction_ExpirationSpec) GetExpireAfterMillis() int64 {
	if x != nil {
		return x.ExpireAfterMillis
	}
	return 0
}

// PersistedValueSpec represents specifications of a function's persisted value state.
type FromFunction_PersistedValueSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StateName      string                       `protobuf:"bytes,1,opt,name=state_name,json=stateName,proto3" json:"state_name,omitempty"`
	ExpirationSpec *FromFunction_ExpirationSpec `protobuf:"bytes,2,opt,name=expiration_spec,json=expirationSpec,proto3" json:"expiration_spec,omitempty"`
	TypeTypename   string                       `protobuf:"bytes,3,opt,name=type_typename,json=typeTypename,proto3" json:"type_typename,omitempty"`
}

func (x *FromFunction_PersistedValueSpec) Reset() {
	*x = FromFunction_PersistedValueSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FromFunction_PersistedValueSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FromFunction_PersistedValueSpec) ProtoMessage() {}

func (x *FromFunction_PersistedValueSpec) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FromFunction_PersistedValueSpec.ProtoReflect.Descriptor instead.
func (*FromFunction_PersistedValueSpec) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3, 6}
}

func (x *FromFunction_PersistedValueSpec) GetStateName() string {
	if x != nil {
		return x.StateName
	}
	return ""
}

func (x *FromFunction_PersistedValueSpec) GetExpirationSpec() *FromFunction_ExpirationSpec {
	if x != nil {
		return x.ExpirationSpec
	}
	return nil
}

func (x *FromFunction_PersistedValueSpec) GetTypeTypename() string {
	if x != nil {
		return x.TypeTypename
	}
	return ""
}

// IncompleteInvocationContext represents a result of an io.statefun.sdk.reqreply.ToFunction.InvocationBatchRequest,
// which should be used as the response if the InvocationBatchRequest provided incomplete information about the
// invocation, e.g. insufficient state values were provided.
type FromFunction_IncompleteInvocationContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MissingValues []*FromFunction_PersistedValueSpec `protobuf:"bytes,1,rep,name=missing_values,json=missingValues,proto3" json:"missing_values,omitempty"`
}

func (x *FromFunction_IncompleteInvocationContext) Reset() {
	*x = FromFunction_IncompleteInvocationContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_request_reply_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FromFunction_IncompleteInvocationContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FromFunction_IncompleteInvocationContext) ProtoMessage() {}

func (x *FromFunction_IncompleteInvocationContext) ProtoReflect() protoreflect.Message {
	mi := &file_request_reply_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FromFunction_IncompleteInvocationContext.ProtoReflect.Descriptor instead.
func (*FromFunction_IncompleteInvocationContext) Descriptor() ([]byte, []int) {
	return file_request_reply_proto_rawDescGZIP(), []int{3, 7}
}

func (x *FromFunction_IncompleteInvocationContext) GetMissingValues() []*FromFunction_PersistedValueSpec {
	if x != nil {
		return x.MissingValues
	}
	return nil
}

var File_request_reply_proto protoreflect.FileDescriptor

var file_request_reply_proto_rawDesc = []byte{
	0x0a, 0x13, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2d, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66,
	0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x22,
	0x4b, 0x0a, 0x07, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x5b, 0x0a, 0x0a,
	0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x79,
	0x70, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79,
	0x70, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x61, 0x73, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x68, 0x61, 0x73, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xee, 0x04, 0x0a, 0x0a, 0x54, 0x6f,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0a, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x69,
	0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72,
	0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x54, 0x6f, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x76, 0x0a, 0x0e, 0x50, 0x65, 0x72, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e,
	0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a,
	0x89, 0x01, 0x0a, 0x0a, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39,
	0x0a, 0x06, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b,
	0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x52, 0x06, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x12, 0x40, 0x0a, 0x08, 0x61, 0x72, 0x67,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x69, 0x6f,
	0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65,
	0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x08, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0xf1, 0x01, 0x0a, 0x16,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c,
	0x79, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x54, 0x6f, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x51, 0x0a, 0x0b,
	0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e,
	0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x54, 0x6f, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xac, 0x10, 0x0a, 0x0c, 0x46,
	0x72, 0x6f, 0x6d, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x11, 0x69,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c,
	0x79, 0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x48, 0x00, 0x52, 0x10, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x88, 0x01, 0x0a, 0x1d, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e,
	0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x48, 0x00, 0x52, 0x1b, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x1a, 0x97, 0x02, 0x0a, 0x16, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6f, 0x0a, 0x0d, 0x6d,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e,
	0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x46, 0x72,
	0x6f, 0x6d, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x0b, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x26, 0x0a, 0x0c, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x59, 0x10, 0x01, 0x1a, 0x89, 0x01, 0x0a, 0x0a, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x69, 0x6f, 0x2e, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72,
	0x65, 0x70, 0x6c, 0x79, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c,
	0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x61, 0x72,
	0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x97, 0x02, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x61, 0x79,
	0x65, 0x64, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17,
	0x69, 0x73, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x69,
	0x73, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x69, 0x6e, 0x5f,
	0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x49,
	0x6e, 0x4d, 0x73, 0x12, 0x39, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75,
	0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x40,
	0x0a, 0x08, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x1a, 0x9d, 0x01, 0x0a, 0x0d, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x40,
	0x0a, 0x08, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x1a, 0xaa, 0x03, 0x0a, 0x12, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x46, 0x72, 0x6f, 0x6d,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74,
	0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x5e, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x67, 0x6f, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x69, 0x6f, 0x2e,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71,
	0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6f,
	0x75, 0x74, 0x67, 0x6f, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12,
	0x69, 0x0a, 0x13, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x69,
	0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72,
	0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x61, 0x0a, 0x11, 0x6f, 0x75,
	0x74, 0x67, 0x6f, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79,
	0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x10, 0x6f, 0x75, 0x74,
	0x67, 0x6f, 0x69, 0x6e, 0x67, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x1a, 0xd1, 0x01,
	0x0a, 0x0e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x54, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40,
	0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b,
	0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x46, 0x72, 0x6f, 0x6d, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x11, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x41, 0x66, 0x74, 0x65, 0x72,
	0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x73, 0x22, 0x39, 0x0a, 0x0a, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0f,
	0x0a, 0x0b, 0x41, 0x46, 0x54, 0x45, 0x52, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x01, 0x12,
	0x10, 0x0a, 0x0c, 0x41, 0x46, 0x54, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x56, 0x4f, 0x4b, 0x45, 0x10,
	0x02, 0x1a, 0xb8, 0x01, 0x0a, 0x12, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x46, 0x72, 0x6f, 0x6d,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x74, 0x79, 0x70, 0x65, 0x54, 0x79, 0x70, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x7f, 0x0a, 0x1b,
	0x49, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x60, 0x0a, 0x0e, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x69, 0x6f, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75,
	0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x46,
	0x72, 0x6f, 0x6d, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x72, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0d,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x0a, 0x0a,
	0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x40, 0x0a, 0x30, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x66, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x72, 0x65, 0x71, 0x72, 0x65,
	0x70, 0x6c, 0x79, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x01, 0x5a,
	0x0a, 0x2e, 0x3b, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_request_reply_proto_rawDescOnce sync.Once
	file_request_reply_proto_rawDescData = file_request_reply_proto_rawDesc
)

func file_request_reply_proto_rawDescGZIP() []byte {
	file_request_reply_proto_rawDescOnce.Do(func() {
		file_request_reply_proto_rawDescData = protoimpl.X.CompressGZIP(file_request_reply_proto_rawDescData)
	})
	return file_request_reply_proto_rawDescData
}

var file_request_reply_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_request_reply_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_request_reply_proto_goTypes = []interface{}{
	(FromFunction_PersistedValueMutation_MutationType)(0), // 0: io.statefun.sdk.reqreply.FromFunction.PersistedValueMutation.MutationType
	(FromFunction_ExpirationSpec_ExpireMode)(0),           // 1: io.statefun.sdk.reqreply.FromFunction.ExpirationSpec.ExpireMode
	(*Address)(nil),                                  // 2: io.statefun.sdk.reqreply.Address
	(*TypedValue)(nil),                               // 3: io.statefun.sdk.reqreply.TypedValue
	(*ToFunction)(nil),                               // 4: io.statefun.sdk.reqreply.ToFunction
	(*FromFunction)(nil),                             // 5: io.statefun.sdk.reqreply.FromFunction
	(*ToFunction_PersistedValue)(nil),                // 6: io.statefun.sdk.reqreply.ToFunction.PersistedValue
	(*ToFunction_Invocation)(nil),                    // 7: io.statefun.sdk.reqreply.ToFunction.Invocation
	(*ToFunction_InvocationBatchRequest)(nil),        // 8: io.statefun.sdk.reqreply.ToFunction.InvocationBatchRequest
	(*FromFunction_PersistedValueMutation)(nil),      // 9: io.statefun.sdk.reqreply.FromFunction.PersistedValueMutation
	(*FromFunction_Invocation)(nil),                  // 10: io.statefun.sdk.reqreply.FromFunction.Invocation
	(*FromFunction_DelayedInvocation)(nil),           // 11: io.statefun.sdk.reqreply.FromFunction.DelayedInvocation
	(*FromFunction_EgressMessage)(nil),               // 12: io.statefun.sdk.reqreply.FromFunction.EgressMessage
	(*FromFunction_InvocationResponse)(nil),          // 13: io.statefun.sdk.reqreply.FromFunction.InvocationResponse
	(*FromFunction_ExpirationSpec)(nil),              // 14: io.statefun.sdk.reqreply.FromFunction.ExpirationSpec
	(*FromFunction_PersistedValueSpec)(nil),          // 15: io.statefun.sdk.reqreply.FromFunction.PersistedValueSpec
	(*FromFunction_IncompleteInvocationContext)(nil), // 16: io.statefun.sdk.reqreply.FromFunction.IncompleteInvocationContext
}
var file_request_reply_proto_depIdxs = []int32{
	8,  // 0: io.statefun.sdk.reqreply.ToFunction.invocation:type_name -> io.statefun.sdk.reqreply.ToFunction.InvocationBatchRequest
	13, // 1: io.statefun.sdk.reqreply.FromFunction.invocation_result:type_name -> io.statefun.sdk.reqreply.FromFunction.InvocationResponse
	16, // 2: io.statefun.sdk.reqreply.FromFunction.incomplete_invocation_context:type_name -> io.statefun.sdk.reqreply.FromFunction.IncompleteInvocationContext
	3,  // 3: io.statefun.sdk.reqreply.ToFunction.PersistedValue.state_value:type_name -> io.statefun.sdk.reqreply.TypedValue
	2,  // 4: io.statefun.sdk.reqreply.ToFunction.Invocation.caller:type_name -> io.statefun.sdk.reqreply.Address
	3,  // 5: io.statefun.sdk.reqreply.ToFunction.Invocation.argument:type_name -> io.statefun.sdk.reqreply.TypedValue
	2,  // 6: io.statefun.sdk.reqreply.ToFunction.InvocationBatchRequest.target:type_name -> io.statefun.sdk.reqreply.Address
	6,  // 7: io.statefun.sdk.reqreply.ToFunction.InvocationBatchRequest.state:type_name -> io.statefun.sdk.reqreply.ToFunction.PersistedValue
	7,  // 8: io.statefun.sdk.reqreply.ToFunction.InvocationBatchRequest.invocations:type_name -> io.statefun.sdk.reqreply.ToFunction.Invocation
	0,  // 9: io.statefun.sdk.reqreply.FromFunction.PersistedValueMutation.mutation_type:type_name -> io.statefun.sdk.reqreply.FromFunction.PersistedValueMutation.MutationType
	3,  // 10: io.statefun.sdk.reqreply.FromFunction.PersistedValueMutation.state_value:type_name -> io.statefun.sdk.reqreply.TypedValue
	2,  // 11: io.statefun.sdk.reqreply.FromFunction.Invocation.target:type_name -> io.statefun.sdk.reqreply.Address
	3,  // 12: io.statefun.sdk.reqreply.FromFunction.Invocation.argument:type_name -> io.statefun.sdk.reqreply.TypedValue
	2,  // 13: io.statefun.sdk.reqreply.FromFunction.DelayedInvocation.target:type_name -> io.statefun.sdk.reqreply.Address
	3,  // 14: io.statefun.sdk.reqreply.FromFunction.DelayedInvocation.argument:type_name -> io.statefun.sdk.reqreply.TypedValue
	3,  // 15: io.statefun.sdk.reqreply.FromFunction.EgressMessage.argument:type_name -> io.statefun.sdk.reqreply.TypedValue
	9,  // 16: io.statefun.sdk.reqreply.FromFunction.InvocationResponse.state_mutations:type_name -> io.statefun.sdk.reqreply.FromFunction.PersistedValueMutation
	10, // 17: io.statefun.sdk.reqreply.FromFunction.InvocationResponse.outgoing_messages:type_name -> io.statefun.sdk.reqreply.FromFunction.Invocation
	11, // 18: io.statefun.sdk.reqreply.FromFunction.InvocationResponse.delayed_invocations:type_name -> io.statefun.sdk.reqreply.FromFunction.DelayedInvocation
	12, // 19: io.statefun.sdk.reqreply.FromFunction.InvocationResponse.outgoing_egresses:type_name -> io.statefun.sdk.reqreply.FromFunction.EgressMessage
	1,  // 20: io.statefun.sdk.reqreply.FromFunction.ExpirationSpec.mode:type_name -> io.statefun.sdk.reqreply.FromFunction.ExpirationSpec.ExpireMode
	14, // 21: io.statefun.sdk.reqreply.FromFunction.PersistedValueSpec.expiration_spec:type_name -> io.statefun.sdk.reqreply.FromFunction.ExpirationSpec
	15, // 22: io.statefun.sdk.reqreply.FromFunction.IncompleteInvocationContext.missing_values:type_name -> io.statefun.sdk.reqreply.FromFunction.PersistedValueSpec
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_request_reply_proto_init() }
func file_request_reply_proto_init() {
	if File_request_reply_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_request_reply_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Address); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TypedValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FromFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToFunction_PersistedValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToFunction_Invocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToFunction_InvocationBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FromFunction_PersistedValueMutation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FromFunction_Invocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FromFunction_DelayedInvocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FromFunction_EgressMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FromFunction_InvocationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FromFunction_ExpirationSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FromFunction_PersistedValueSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_request_reply_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FromFunction_IncompleteInvocationContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_request_reply_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ToFunction_Invocation_)(nil),
	}
	file_request_reply_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*FromFunction_InvocationResult)(nil),
		(*FromFunction_IncompleteInvocationContext_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_request_reply_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_request_reply_proto_goTypes,
		DependencyIndexes: file_request_reply_proto_depIdxs,
		EnumInfos:         file_request_reply_proto_enumTypes,
		MessageInfos:      file_request_reply_proto_msgTypes,
	}.Build()
	File_request_reply_proto = out.File
	file_request_reply_proto_rawDesc = nil
	file_request_reply_proto_goTypes = nil
	file_request_reply_proto_depIdxs = nil
}
