/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.function.Consumer;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.util.ChildFirstClassLoader;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkUserCodeClassLoaders {
    private FlinkUserCodeClassLoaders() {
    }

    public static URLClassLoader parentFirst(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler, boolean checkClassLoaderLeak) {
        ParentFirstClassLoader classLoader = new ParentFirstClassLoader(urls, parent, classLoadingExceptionHandler);
        return FlinkUserCodeClassLoaders.wrapWithSafetyNet(classLoader, checkClassLoaderLeak);
    }

    public static URLClassLoader childFirst(URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns, Consumer<Throwable> classLoadingExceptionHandler, boolean checkClassLoaderLeak) {
        ChildFirstClassLoader classLoader = new ChildFirstClassLoader(urls, parent, alwaysParentFirstPatterns, classLoadingExceptionHandler);
        return FlinkUserCodeClassLoaders.wrapWithSafetyNet(classLoader, checkClassLoaderLeak);
    }

    public static URLClassLoader create(ResolveOrder resolveOrder, URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns, Consumer<Throwable> classLoadingExceptionHandler, boolean checkClassLoaderLeak) {
        switch (resolveOrder) {
            case CHILD_FIRST: {
                return FlinkUserCodeClassLoaders.childFirst(urls, parent, alwaysParentFirstPatterns, classLoadingExceptionHandler, checkClassLoaderLeak);
            }
            case PARENT_FIRST: {
                return FlinkUserCodeClassLoaders.parentFirst(urls, parent, classLoadingExceptionHandler, checkClassLoaderLeak);
            }
        }
        throw new IllegalArgumentException("Unknown class resolution order: " + (Object)((Object)resolveOrder));
    }

    private static URLClassLoader wrapWithSafetyNet(FlinkUserCodeClassLoader classLoader, boolean check) {
        return check ? new SafetyNetWrapperClassLoader(classLoader, classLoader.getParent()) : classLoader;
    }

    private static class SafetyNetWrapperClassLoader
    extends URLClassLoader
    implements Closeable {
        private static final Logger LOG = LoggerFactory.getLogger(SafetyNetWrapperClassLoader.class);
        private volatile FlinkUserCodeClassLoader inner;

        SafetyNetWrapperClassLoader(FlinkUserCodeClassLoader inner, ClassLoader parent) {
            super(new URL[0], parent);
            this.inner = inner;
        }

        @Override
        public void close() {
            FlinkUserCodeClassLoader inner = this.inner;
            if (inner != null) {
                try {
                    inner.close();
                }
                catch (IOException e) {
                    LOG.warn("Could not close user classloader", (Throwable)e);
                }
            }
            this.inner = null;
        }

        private FlinkUserCodeClassLoader ensureInner() {
            if (this.inner == null) {
                throw new IllegalStateException("Trying to access closed classloader. Please check if you store classloaders directly or indirectly in static fields. If the stacktrace suggests that the leak occurs in a third party library and cannot be fixed immediately, you can disable this check with the configuration '" + CoreOptions.CHECK_LEAKED_CLASSLOADER.key() + "'.");
            }
            return this.inner;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.ensureInner().loadClass(name);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return this.ensureInner().loadClass(name, resolve);
        }

        @Override
        public URL getResource(String name) {
            return this.ensureInner().getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.ensureInner().getResources(name);
        }

        @Override
        public URL[] getURLs() {
            return this.ensureInner().getURLs();
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    public static class ParentFirstClassLoader
    extends FlinkUserCodeClassLoader {
        ParentFirstClassLoader(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler) {
            super(urls, parent, classLoadingExceptionHandler);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    public static enum ResolveOrder {
        CHILD_FIRST,
        PARENT_FIRST;


        public static ResolveOrder fromString(String resolveOrder) {
            if (resolveOrder.equalsIgnoreCase("parent-first")) {
                return PARENT_FIRST;
            }
            if (resolveOrder.equalsIgnoreCase("child-first")) {
                return CHILD_FIRST;
            }
            throw new IllegalArgumentException("Unknown resolve order: " + resolveOrder);
        }
    }
}

