/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.heap.AbstractHeapState;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.internal.InternalValueState;

class HeapValueState<K, N, V>
extends AbstractHeapState<K, N, V>
implements InternalValueState<K, N, V> {
    private HeapValueState(StateTable<K, N, V> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, TypeSerializer<N> namespaceSerializer, V defaultValue) {
        super(stateTable, keySerializer, valueSerializer, namespaceSerializer, defaultValue);
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    @Override
    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public V value() {
        Object result = this.stateTable.get(this.currentNamespace);
        if (result == null) {
            return (V)this.getDefaultValue();
        }
        return (V)result;
    }

    @Override
    public void update(V value) {
        if (value == null) {
            this.clear();
            return;
        }
        this.stateTable.put(this.currentNamespace, value);
    }

    static <K, N, SV, S extends State, IS extends S> IS create(StateDescriptor<S, SV> stateDesc, StateTable<K, N, SV> stateTable, TypeSerializer<K> keySerializer) {
        return (IS)new HeapValueState<K, N, SV>(stateTable, keySerializer, stateTable.getStateSerializer(), stateTable.getNamespaceSerializer(), stateDesc.getDefaultValue());
    }

    static <K, N, SV, S extends State, IS extends S> IS update(StateDescriptor<S, SV> stateDesc, StateTable<K, N, SV> stateTable, IS existingState) {
        return (IS)((HeapValueState)existingState).setNamespaceSerializer(stateTable.getNamespaceSerializer()).setValueSerializer(stateTable.getStateSerializer()).setDefaultValue(stateDesc.getDefaultValue());
    }
}

